/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.support.LabelInfo;
import chemaxon.marvin.uif.dialog.model.PropertiesProvider;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.Item;
import javax.swing.Action;
import javax.swing.Icon;

public class PropertiesHelper
implements PropertiesProvider {
    private ActionRegistry registry;

    public PropertiesHelper(ActionRegistry registry) {
        this.registry = registry;
    }

    public static void configure(Action action, DisplayProperties properties) {
        LabelInfo.parse(properties.getDisplayName()).configure(action);
        action.putValue("SmallIcon", properties.getIcon());
        action.putValue("ShortDescription", properties.getDescription());
    }

    @Override
    public DisplayProperties getProperties(Item item) {
        DisplayProperties displayProperties;
        Action action = this.registry.getAction(item.getID());
        DisplayProperties result = new DisplayProperties();
        if (action != null) {
            result.setIcon((Icon)action.getValue("SmallIcon"));
            result.setDescription((String)action.getValue("LongDescription"));
            result.setDisplayName(LabelInfo.parse(action).getEncodedString());
        }
        if ((displayProperties = item.getDisplayProperties()) != null) {
            if (displayProperties.getIcon() != null) {
                result.setIcon(displayProperties.getIcon());
            }
            if (displayProperties.getDisplayName() != null) {
                result.setDisplayName(displayProperties.getDisplayName());
            }
            if (displayProperties.getDescription() != null) {
                result.setDescription(displayProperties.getDescription());
            }
        }
        return result;
    }
}

