/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.Category;
import chemaxon.marvin.uif.dialog.model.CategoryHelper;
import chemaxon.marvin.uif.dialog.model.DialogProvider;
import chemaxon.marvin.uif.dialog.model.ListModelAdapter;
import chemaxon.marvin.uif.dialog.model.ShortcutModel;
import chemaxon.marvin.uif.shortcut.Shortcut;
import chemaxon.marvin.uif.shortcut.ShortcutManager;
import chemaxon.marvin.uif.shortcut.ShortcutScheme;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SchemeManagerModel {
    private static final String CUSTOM_ID_PREFIX = "custom-";
    private static final String DUPLICATE_ACTION_NAME = "duplicate.name";
    private static final String ACTIVATE_ACTION_NAME = "activate.name";
    private static final String REMOVE_ACTION_NAME = "remove.name";
    private static final String REMOVE_SHORTCUT_ACTION_NAME = "removeShortcut.name";
    private static final String ADD_SHORTCUT_ACTION_NAME = "addShortcut.name";
    private static final String SCHEME_NAME_MESSAGE = "name.message";
    private static final String SCHEME_NAME_ERROR_TITLE = "name_error.title";
    private static final String SCHEME_NAME_ERROR_MESSAGE = "name_error.message";
    private DialogProvider shortcutEditor;
    private ShortcutManager manager;
    private ActionRegistry registry;
    private JComponent component;
    private DefaultListModel schemeModel;
    private ListSelectionModel schemeSelectionModel;
    private ListModel categoriesModel;
    private ListSelectionModel categoriesSelectionModel;
    private List commandIDs;
    private ListModelAdapter actionsModel;
    private ListSelectionModel actionSelectionModel;
    private ListModelAdapter shortcutsModel;
    private ListSelectionModel shortcutsSelectionModel;
    private CategoryHelper categoryHelper;
    private ResourceBundle bundle;
    private Action duplicateAction;
    private Action activateAction;
    private Action removeAction;
    private Action removeShortcutAction;
    private Action addShortcutAction;
    private boolean dirty;

    public SchemeManagerModel(ShortcutManager manager, ActionRegistry registry, DialogProvider shortcutEditor) {
        this.manager = manager;
        this.registry = registry;
        this.bundle = ResourceBundle.getBundle(SchemeManagerModel.class.getName());
        this.shortcutEditor = shortcutEditor;
        this.dirty = false;
        this.initModels();
        this.initActions();
        this.initEventHandling();
        this.updateSelection(this.categoriesModel, this.categoriesSelectionModel);
    }

    private void initModels() {
        this.schemeModel = new DefaultListModel();
        ShortcutScheme[] schemes = this.manager.getShortcutSchemes();
        for (int i = 0; i < schemes.length; ++i) {
            this.schemeModel.add(i, schemes[i]);
        }
        this.schemeSelectionModel = new DefaultListSelectionModel();
        this.schemeSelectionModel.setSelectionMode(0);
        this.updateSelection(this.schemeModel, this.schemeSelectionModel);
        this.categoryHelper = new CategoryHelper(this.registry);
        this.categoriesModel = new ListModelAdapter(this.categoryHelper.getCategories());
        this.categoriesSelectionModel = new DefaultListSelectionModel();
        this.categoriesSelectionModel.setSelectionMode(0);
        this.actionsModel = new ListModelAdapter(null);
        this.actionSelectionModel = new DefaultListSelectionModel();
        this.actionSelectionModel.setSelectionMode(0);
        this.shortcutsModel = new ListModelAdapter(null);
        this.shortcutsSelectionModel = new DefaultListSelectionModel();
        this.shortcutsSelectionModel.setSelectionMode(0);
    }

    private void initActions() {
        this.duplicateAction = new DuplicateAction(this.bundle.getString(DUPLICATE_ACTION_NAME));
        this.activateAction = new ActivateAction(this.bundle.getString(ACTIVATE_ACTION_NAME));
        this.removeAction = new DeleteAction(this.bundle.getString(REMOVE_ACTION_NAME));
        this.removeShortcutAction = new RemoveShortcutAction(this.bundle.getString(REMOVE_SHORTCUT_ACTION_NAME));
        this.addShortcutAction = new AddShortcutAction(this.bundle.getString(ADD_SHORTCUT_ACTION_NAME));
    }

    private void initEventHandling() {
        this.schemeSelectionModel.addListSelectionListener(new SchemeChangeHandler());
        this.categoriesSelectionModel.addListSelectionListener(new CategoryChangeHandler());
        this.actionSelectionModel.addListSelectionListener(new ActionChangeHandler());
    }

    private void updateActionList() {
        Category category = this.getSelectedCategory();
        this.commandIDs = category != null ? this.categoryHelper.getActionIDs(category) : Collections.EMPTY_LIST;
        this.actionsModel.setDelegate(this.categoryHelper.convertIDsToActons(this.commandIDs));
        this.updateSelection(this.actionsModel, this.actionSelectionModel);
    }

    private void updateShortcutList() {
        String id = this.getSelectedCommandID();
        if (id != null && this.hasSchemeSelection()) {
            this.shortcutsModel.setDelegate(new ArrayList<Shortcut>(Arrays.asList(this.getSelectedScheme().getShortcuts(id))));
        } else {
            this.shortcutsModel.setDelegate(Collections.EMPTY_LIST);
        }
        this.updateSelection(this.shortcutsModel, this.shortcutsSelectionModel);
    }

    private void updateSelection(ListModel listModel, ListSelectionModel selectionModel) {
        if (listModel.getSize() > 0) {
            selectionModel.setSelectionInterval(0, 0);
        } else {
            selectionModel.clearSelection();
        }
    }

    public ListModel getSchemesList() {
        return this.schemeModel;
    }

    public ListSelectionModel getSchemeSelection() {
        return this.schemeSelectionModel;
    }

    public ListModel getCategoriesList() {
        return this.categoriesModel;
    }

    public ListModel getActionsList() {
        return this.actionsModel;
    }

    public ListModel getShortcutsList() {
        return this.shortcutsModel;
    }

    public ListSelectionModel getCategorySelection() {
        return this.categoriesSelectionModel;
    }

    public ListSelectionModel getActionSelection() {
        return this.actionSelectionModel;
    }

    public ListSelectionModel getShortcutsSelection() {
        return this.shortcutsSelectionModel;
    }

    public void setComponent(JComponent component) {
        this.component = component;
    }

    public String getParentName() {
        if (this.getSelectedScheme() == null || this.getSelectedScheme().getParent() == null) {
            return null;
        }
        return this.getSelectedScheme().getParent().getName();
    }

    public Action getDuplicateAction() {
        return this.duplicateAction;
    }

    public Action getActivateAction() {
        return this.activateAction;
    }

    public Action getRemoveAction() {
        return this.removeAction;
    }

    public Action getRemoveShortcutAction() {
        return this.removeShortcutAction;
    }

    public Action getAddShortcutAction() {
        return this.addShortcutAction;
    }

    public void apply() {
        if (this.dirty) {
            this.dirty = false;
        }
    }

    private boolean hasCategorySelection() {
        return !this.categoriesSelectionModel.isSelectionEmpty();
    }

    private Category getSelectedCategory() {
        if (!this.hasCategorySelection()) {
            return null;
        }
        return (Category)this.categoriesModel.getElementAt(this.categoriesSelectionModel.getMinSelectionIndex());
    }

    private boolean isSelectedSchemeEditable() {
        return this.hasSchemeSelection() && this.getSelectedScheme().isEditable();
    }

    private boolean hasCommandSelection() {
        return !this.actionSelectionModel.isSelectionEmpty();
    }

    private String getSelectedCommandID() {
        if (!this.hasCommandSelection()) {
            return null;
        }
        return (String)this.commandIDs.get(this.actionSelectionModel.getMinSelectionIndex());
    }

    private boolean hasSchemeSelection() {
        return !this.schemeSelectionModel.isSelectionEmpty();
    }

    private ShortcutScheme getSelectedScheme() {
        if (!this.hasSchemeSelection()) {
            return null;
        }
        return (ShortcutScheme)this.schemeModel.get(this.schemeSelectionModel.getMinSelectionIndex());
    }

    private boolean hasShortcutSelection() {
        return !this.shortcutsSelectionModel.isSelectionEmpty();
    }

    private Shortcut getSelectedShortcut() {
        if (!this.hasShortcutSelection()) {
            return null;
        }
        return (Shortcut)this.shortcutsModel.getElementAt(this.shortcutsSelectionModel.getMinSelectionIndex());
    }

    private void doCopy() {
        String name = JOptionPane.showInputDialog(this.component, this.bundle.getString(SCHEME_NAME_MESSAGE), this.getSelectedScheme().getName());
        if (name == null || name.trim().length() == 0) {
            return;
        }
        if (this.hasSchemeNamed(name)) {
            JOptionPane.showMessageDialog(this.component, this.bundle.getString(SCHEME_NAME_ERROR_MESSAGE), this.bundle.getString(SCHEME_NAME_ERROR_TITLE), 0);
            return;
        }
        ShortcutScheme scheme = new ShortcutScheme(this.getSelectedScheme(), this.createCustomID(), name);
        this.manager.addShortcutScheme(scheme);
        this.schemeModel.addElement(scheme);
        this.schemeSelectionModel.setSelectionInterval(this.schemeModel.getSize() - 1, this.schemeModel.getSize() - 1);
        this.doActivate();
    }

    private void doActivate() {
        int oldActive = this.schemeModel.indexOf(this.getSelectedScheme());
        int newActive = this.schemeSelectionModel.getMinSelectionIndex();
        this.manager.setActive(this.getSelectedScheme().getID());
        this.schemeModel.set(oldActive, this.schemeModel.get(oldActive));
        this.schemeModel.set(newActive, this.schemeModel.get(newActive));
    }

    private void doRemove() {
        this.manager.removeShortcutSchema(this.getSelectedScheme().getID());
        this.schemeModel.removeElement(this.getSelectedScheme());
        if (!this.hasSchemeSelection()) {
            this.updateSelection(this.schemeModel, this.schemeSelectionModel);
        }
    }

    private void doRemoveShortcut() {
        this.getSelectedScheme().removeShortcut(this.getSelectedShortcut());
        this.shortcutsModel.removeElement(this.getSelectedShortcut());
        this.updateShortcutList();
    }

    private void doAddShortcut() {
        ShortcutModel model = new ShortcutModel(this.getSelectedScheme(), this.registry);
        AbstractDialog dialog = this.shortcutEditor.create(SwingUtilities.getWindowAncestor(this.component), model);
        dialog.open();
        if (!dialog.isCanceled() && model.getShortcut() != null) {
            this.getSelectedScheme().addShortcut(this.getSelectedCommandID(), model.getShortcut());
            this.updateShortcutList();
        }
    }

    private String createCustomID() {
        String id;
        int i = 0;
        while (this.manager.getShortcutScheme(id = CUSTOM_ID_PREFIX + ++i) != null) {
        }
        return id;
    }

    private boolean hasSchemeNamed(String name) {
        ShortcutScheme[] schemes = this.manager.getShortcutSchemes();
        for (int i = 0; i < schemes.length; ++i) {
            if (!name.equals(schemes[i].getName())) continue;
            return true;
        }
        return false;
    }

    private void schemeSelectionChanged() {
        this.updateShortcutList();
    }

    private class AddShortcutAction
    extends AbstractAction
    implements ListSelectionListener {
        public AddShortcutAction(String name) {
            super(name);
            this.update();
            SchemeManagerModel.this.getActionSelection().addListSelectionListener(this);
            SchemeManagerModel.this.getSchemeSelection().addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemeManagerModel.this.doAddShortcut();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.update();
        }

        private void update() {
            this.setEnabled(SchemeManagerModel.this.hasCommandSelection() && SchemeManagerModel.this.isSelectedSchemeEditable());
        }
    }

    private class RemoveShortcutAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveShortcutAction(String name) {
            super(name);
            this.update();
            SchemeManagerModel.this.getShortcutsSelection().addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemeManagerModel.this.doRemoveShortcut();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.update();
        }

        private void update() {
            this.setEnabled(SchemeManagerModel.this.hasShortcutSelection() && SchemeManagerModel.this.isSelectedSchemeEditable());
        }
    }

    private class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        public DeleteAction(String name) {
            super(name);
            this.update();
            SchemeManagerModel.this.getSchemeSelection().addListSelectionListener(this);
        }

        private void update() {
            this.setEnabled(SchemeManagerModel.this.hasSchemeSelection() && SchemeManagerModel.this.manager.canRemove(SchemeManagerModel.this.getSelectedScheme()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemeManagerModel.this.doRemove();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.update();
        }
    }

    private class DuplicateAction
    extends AbstractAction
    implements ListSelectionListener {
        public DuplicateAction(String name) {
            super(name);
            this.update();
            SchemeManagerModel.this.getSchemeSelection().addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemeManagerModel.this.doCopy();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.update();
        }

        private void update() {
            this.setEnabled(SchemeManagerModel.this.hasSchemeSelection());
        }
    }

    private class ActivateAction
    extends AbstractAction
    implements ListSelectionListener {
        public ActivateAction(String name) {
            super(name);
            this.update();
            SchemeManagerModel.this.getSchemeSelection().addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemeManagerModel.this.doActivate();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                this.update();
            }
        }

        private void update() {
            this.setEnabled(SchemeManagerModel.this.hasSchemeSelection() && !SchemeManagerModel.this.getSelectedScheme().isActive());
        }
    }

    private class ActionChangeHandler
    implements ListSelectionListener {
        private ActionChangeHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            SchemeManagerModel.this.updateShortcutList();
        }
    }

    private class CategoryChangeHandler
    implements ListSelectionListener {
        private CategoryChangeHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            SchemeManagerModel.this.updateActionList();
        }
    }

    private class SchemeChangeHandler
    implements ListSelectionListener {
        private SchemeChangeHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            SchemeManagerModel.this.schemeSelectionChanged();
        }
    }
}

