/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.shortcut.KeyboardShortcut;
import chemaxon.marvin.uif.shortcut.Shortcut;
import chemaxon.marvin.uif.shortcut.ShortcutScheme;
import chemaxon.marvin.uif.util.bean.Model;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class ShortcutModel
extends Model {
    public static final String PROPERTY_SHORTCUT = "shortcut";
    private static final String CLEAR_NAME = "clear.name";
    private static final String TAB_NAME = "tab.name";
    private ShortcutScheme scheme;
    private ActionRegistry registry;
    private Shortcut shortcut;
    private ResourceBundle bundle;
    private Action clearAction;
    private Action tabAction;

    public ShortcutModel(ShortcutScheme scheme, ActionRegistry registry) {
        this.scheme = scheme;
        this.registry = registry;
        this.shortcut = null;
        this.bundle = ResourceBundle.getBundle(ShortcutModel.class.getName());
        this.initActions();
    }

    private void initActions() {
        this.clearAction = new ClearAction(this.bundle.getString(CLEAR_NAME));
        this.tabAction = new TabAction(this.bundle.getString(TAB_NAME));
    }

    public Shortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(Shortcut shortcut) {
        Shortcut oldValue = this.getShortcut();
        this.shortcut = shortcut;
        this.firePropertyChange(PROPERTY_SHORTCUT, oldValue, this.getShortcut());
    }

    public String getAssignedCommand() {
        if (this.shortcut == null) {
            return null;
        }
        String commandID = this.scheme.getCommandID(this.shortcut);
        if (commandID == null || this.registry.getAction(commandID) == null) {
            return null;
        }
        return (String)this.registry.getAction(commandID).getValue("Name");
    }

    public Action getTabAction() {
        return this.tabAction;
    }

    public Action getClearAction() {
        return this.clearAction;
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShortcutModel.this.setShortcut(null);
        }
    }

    private class TabAction
    extends AbstractAction {
        public TabAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShortcutModel.this.setShortcut(new KeyboardShortcut(KeyStroke.getKeyStroke(9, 0)));
        }
    }
}

