/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.marvin.uif.action.support.LabelInfo;
import chemaxon.marvin.uif.dialog.model.DialogProvider;
import chemaxon.marvin.uif.dialog.model.ItemComparator;
import chemaxon.marvin.uif.dialog.model.ItemGroupModel;
import chemaxon.marvin.uif.dialog.model.OptionPanelUtils;
import chemaxon.marvin.uif.model.DefaultToolbarGroup;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.IDHelper;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.ToolBarGroup;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ToolBarManagerModel {
    private static final String ICON_AND_TEXT_ACTION = "iconAndText.name";
    private static final String ICON_ACTION = "icon.name";
    private static final String TEXT_ACTION = "text.name";
    private static final String NEW_ACTION = "new.name";
    private static final String DELETE_ACTION = "delete.name";
    private static final String RENAME_ACTION = "rename.name";
    private ResourceBundle bundle;
    private GUIRegistry guiRegistry;
    private ExtendedComboBoxModel toolbarList;
    private ItemGroupModel selectedGroup;
    private ActionRegistry actionRegistry;
    private Action newAction;
    private Action renameAction;
    private Action deleteAction;
    private StyleAction iconStyleAction;
    private StyleAction textStyleAction;
    private StyleAction iconAndTextStyleAction;
    private boolean canAddDelete;
    private Component component;

    public ToolBarManagerModel(GUIRegistry guiRegistry, ActionRegistry actionRegistry, DialogProvider categoriesDialog) {
        this(guiRegistry, actionRegistry, true, categoriesDialog);
    }

    public ToolBarManagerModel(GUIRegistry guiRegistry, ActionRegistry actionRegistry, boolean canAddDelete, DialogProvider categoriesDialog) {
        this.guiRegistry = guiRegistry;
        this.actionRegistry = actionRegistry;
        this.canAddDelete = canAddDelete;
        this.bundle = ResourceBundle.getBundle(ToolBarManagerModel.class.getName());
        this.initModels(categoriesDialog);
        this.initActions();
        this.initEventHandling();
    }

    private void initModels(DialogProvider categoriesDialog) {
        this.toolbarList = new ExtendedComboBoxModel(this.collectToolbars().toArray());
        this.selectedGroup = new ItemGroupModel(this.actionRegistry, (ItemGroup)this.toolbarList.getSelectedItem(), categoriesDialog);
    }

    private void initActions() {
        this.newAction = new NewAction();
        this.deleteAction = new DeleteAction();
        this.renameAction = new RenameAction();
        this.iconStyleAction = new StyleAction(0);
        this.textStyleAction = new StyleAction(1);
        this.iconAndTextStyleAction = new StyleAction(2);
        LabelInfo.configure(this.newAction, this.bundle.getString(NEW_ACTION));
        LabelInfo.configure(this.deleteAction, this.bundle.getString(DELETE_ACTION));
        LabelInfo.configure(this.renameAction, this.bundle.getString(RENAME_ACTION));
        LabelInfo.configure(this.iconStyleAction, this.bundle.getString(ICON_ACTION));
        LabelInfo.configure(this.textStyleAction, this.bundle.getString(TEXT_ACTION));
        LabelInfo.configure(this.iconAndTextStyleAction, this.bundle.getString(ICON_AND_TEXT_ACTION));
        this.updateActions();
    }

    private void updateActions() {
        this.deleteAction.setEnabled(this.hasSelection() && this.canAddDelete);
        this.renameAction.setEnabled(this.hasSelection());
        this.newAction.setEnabled(this.canAddDelete);
        this.updateStyleAction(this.iconStyleAction);
        this.updateStyleAction(this.textStyleAction);
        this.updateStyleAction(this.iconAndTextStyleAction);
    }

    private void updateStyleAction(StyleAction action) {
        action.setEnabled(this.hasSelection());
        action.setSelected(this.hasSelection() && this.getSelectedToolbar().getButtonStyle() == action.getStyle());
    }

    private boolean hasSelection() {
        return this.getSelectedToolbar() != null;
    }

    private void initEventHandling() {
        this.toolbarList.addListDataListener(new ToolBarSelectionHandler());
    }

    private List collectToolbars() {
        ArrayList<ToolBarGroup> result = new ArrayList<ToolBarGroup>();
        String[] ids = this.guiRegistry.getToolBarIDs();
        for (int i = 0; i < ids.length; ++i) {
            result.add(this.guiRegistry.getToolBar(ids[i]));
        }
        Collections.sort(result, new ItemComparator());
        return result;
    }

    private void updateSelection() {
        this.selectedGroup.setGroup(this.getSelectedToolbar());
        this.updateActions();
    }

    private ToolBarGroup getSelectedToolbar() {
        return (ToolBarGroup)this.toolbarList.getSelectedItem();
    }

    private void doDelete() {
        ToolBarGroup group = this.getSelectedToolbar();
        this.guiRegistry.removeToolBar(group.getID());
        this.toolbarList.removeElement(group);
    }

    private void doNew() {
        String name = OptionPanelUtils.showAddToolbarDialog(this.component);
        if (name == null) {
            return;
        }
        String id = IDHelper.createUniqueCustomToolBarID(this.guiRegistry);
        DefaultToolbarGroup group = new DefaultToolbarGroup(id, name);
        this.guiRegistry.addToolBar(group);
        this.toolbarList.addElement(group);
        this.toolbarList.setSelectedItem(group);
    }

    private void doRename() {
        String name = OptionPanelUtils.showToolbarRenameDialog(this.component, this.getSelectedToolbar().getDisplayProperties());
        if (name != null) {
            this.getSelectedToolbar().getDisplayProperties().setDisplayName(name);
            this.toolbarList.selectedChanged();
        }
    }

    private void doSetStyle(int style) {
        this.getSelectedToolbar().setButtonStyle(style);
        this.updateActions();
    }

    public void release() {
        this.toolbarList.setSelectedItem(null);
        this.selectedGroup.release();
    }

    public void setComponent(Component component) {
        this.component = component;
        this.selectedGroup.setComponent(component);
    }

    public void setSelectedToolBar(ItemGroup group) {
        this.toolbarList.setSelectedItem(group);
    }

    public ComboBoxModel getToolBarSelector() {
        return this.toolbarList;
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    public Action getRenameAction() {
        return this.renameAction;
    }

    public Action getNewAction() {
        return this.newAction;
    }

    public Action getIconAndTextStyleAction() {
        return this.iconAndTextStyleAction;
    }

    public Action getIconStyleAction() {
        return this.iconStyleAction;
    }

    public Action getTextStyleAction() {
        return this.textStyleAction;
    }

    public ItemGroupModel getSelectedToolBarModel() {
        return this.selectedGroup;
    }

    public boolean getCanAddDelete() {
        return this.canAddDelete;
    }

    public void setCanAddDelete(boolean canAddDelete) {
        this.canAddDelete = canAddDelete;
        this.updateActions();
    }

    public boolean getUseLargeIcons() {
        return this.guiRegistry.getUseLargeIcons();
    }

    public void setUseLargeIcons(boolean b) {
        this.guiRegistry.setUseLargeIcons(b);
    }

    private class ToolBarSelectionHandler
    implements ListDataListener {
        private ToolBarSelectionHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ToolBarManagerModel.this.updateSelection();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private class ExtendedComboBoxModel
    extends DefaultComboBoxModel {
        public ExtendedComboBoxModel(Object[] items) {
            super(items);
        }

        private void selectedChanged() {
            this.fireContentsChanged(this, -1, -1);
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolBarManagerModel.this.doDelete();
        }
    }

    private class StyleAction
    extends AbstractStateAction {
        private int style;

        public StyleAction(int style) {
            super(false, true);
            this.style = style;
        }

        public int getStyle() {
            return this.style;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolBarManagerModel.this.doSetStyle(this.style);
        }
    }

    private class RenameAction
    extends AbstractAction {
        private static final String ID = "rename";

        private RenameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolBarManagerModel.this.doRename();
        }
    }

    private class NewAction
    extends AbstractAction {
        private NewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolBarManagerModel.this.doNew();
        }
    }
}

