/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.view;

import chemaxon.marvin.uif.dialog.model.CategoriesModel;
import chemaxon.marvin.uif.dialog.view.ActionRenderer;
import chemaxon.marvin.uif.dialog.view.CategoryRenderer;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.swing.AbstractView;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CategoriesView
extends AbstractView {
    private static final String CATEGORY_LABEL = "category.label";
    private static final String COMMANDS_LABEL = "commands.label";
    private static final String DESCRIPTION_LABEL = "description.label";
    private final CategoriesModel model;
    private ResourceBundle bundle;
    private JList categoryList;
    private JList commandList;
    private JButton addButton;
    private JTextArea detailsArea;

    public CategoriesView(CategoriesModel model) {
        this.model = model;
        try {
            this.bundle = ResourceBundle.getBundle(CategoriesView.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println(CategoriesView.class.getName() + ".properties not found");
        }
    }

    private String getString(String key, String defaultValue) {
        return Utils.getString(this.bundle, key, defaultValue);
    }

    public JButton getDefaultButton() {
        return this.addButton;
    }

    @Override
    protected JComponent buildComponent() {
        this.initComponents();
        this.initEventHandling();
        FormLayout layout = new FormLayout("fill:max(100dlu;pref):grow(0.5), 4dlu, fill:max(150dlu;pref):grow(0.5), 4dlu, default", "default, 2dlu, fill:max(150dlu;pref):grow, 4dlu, default, 2dlu, default");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.addLabel(this.getString(CATEGORY_LABEL, "Category"), cc.xy(1, 1));
        builder.addLabel(this.getString(COMMANDS_LABEL, "Commands"), cc.xy(3, 1));
        builder.add((Component)new JScrollPane(this.categoryList), cc.xy(1, 3));
        builder.add((Component)new JScrollPane(this.commandList), cc.xy(3, 3));
        builder.add((Component)this.addButton, cc.xy(5, 3, CellConstraints.LEFT, CellConstraints.TOP));
        builder.addSeparator(this.getString(DESCRIPTION_LABEL, "Description"), cc.xyw(1, 5, 5));
        builder.add((Component)new JScrollPane(this.detailsArea), cc.xyw(1, 7, 5));
        return builder.getPanel();
    }

    private void initComponents() {
        this.categoryList = new JList(this.model.getCategoriesList());
        this.categoryList.setSelectionModel(this.model.getCategorySelection());
        this.categoryList.setCellRenderer(new CategoryRenderer());
        this.commandList = new JList(this.model.getCommandsList());
        this.commandList.setSelectionModel(this.model.getCommandSelection());
        this.commandList.setCellRenderer(new ActionRenderer());
        this.addButton = new JButton(this.model.getAddAction());
        this.detailsArea = new JTextArea(this.model.getDescription(), 3, 30);
        this.detailsArea.setEditable(false);
        this.detailsArea.setOpaque(false);
        this.detailsArea.setWrapStyleWord(true);
        this.detailsArea.setLineWrap(true);
    }

    private void updateView() {
        this.detailsArea.setText(this.model.getDescription());
    }

    private void initEventHandling() {
        this.commandList.addListSelectionListener(new SelectionChangeHandler());
        this.commandList.addMouseListener(this.model.getDoubleClickHandler());
    }

    private class SelectionChangeHandler
    implements ListSelectionListener {
        private SelectionChangeHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CategoriesView.this.updateView();
        }
    }
}

