/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.view;

import chemaxon.marvin.uif.dialog.model.ConfigurationModel;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.util.swing.AbstractView;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfigurationView
extends AbstractView {
    private static final String ACTIVE = "active";
    private ConfigurationModel model;
    private JList configurationList;
    private JButton activateButton;
    private JButton renameButton;
    private JButton deleteButton;
    private JButton copyButton;
    private JButton editButton;
    private JButton importButton;
    private JButton exportButton;

    public ConfigurationView(ConfigurationModel model) {
        this.model = model;
    }

    @Override
    protected JComponent buildComponent() {
        this.initComponents();
        FormLayout layout = new FormLayout("max(pref;150dlu), 4dlu, pref", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 0:grow, 2dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JScrollPane(this.configurationList), cc.xywh(1, 1, 1, 10));
        builder.add((Component)this.activateButton, cc.xy(3, 1));
        builder.add((Component)this.editButton, cc.xy(3, 3));
        builder.add((Component)this.renameButton, cc.xy(3, 5));
        builder.add((Component)this.copyButton, cc.xy(3, 7));
        builder.add((Component)this.deleteButton, cc.xy(3, 9));
        builder.add((Component)this.editButton, cc.xy(3, 3));
        builder.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)this.importButton, (JButton)this.exportButton), cc.xyw(1, 12, 3));
        this.model.setComponent(builder.getPanel());
        return builder.getPanel();
    }

    private void initComponents() {
        this.activateButton = new JButton(this.model.getActivateAction());
        this.editButton = new JButton(this.model.getEditAction());
        this.renameButton = new JButton(this.model.getRenameAction());
        this.copyButton = new JButton(this.model.getCopyAction());
        this.deleteButton = new JButton(this.model.getDeleteAction());
        this.importButton = new JButton(this.model.getImportAction());
        this.exportButton = new JButton(this.model.getExportAction());
        this.configurationList = new JList(this.model.getConfigurations());
        this.configurationList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = ConfigurationView.this.configurationList.getSelectedIndex();
                if (index != -1) {
                    ConfigurationView.this.configurationList.scrollRectToVisible(ConfigurationView.this.configurationList.getCellBounds(index, index));
                }
            }
        });
        this.configurationList.setSelectionModel(this.model.getConfigurationSelection());
        this.configurationList.setCellRenderer(new RegistryRenderer());
        this.configurationList.addMouseListener(this.model.getDoubleClickHandler());
    }

    private class RegistryRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate = new DefaultListCellRenderer();
        private Font boldFont;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean active;
            GUIRegistry registry = (GUIRegistry)value;
            String name = registry != null ? registry.getDisplayName() : null;
            boolean bl = active = registry != null && ConfigurationView.this.model.getActiveItemIndex() == index;
            if (active && name != null) {
                name = name + " " + ConfigurationView.this.getString(ConfigurationView.ACTIVE);
            }
            Component result = this.delegate.getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
            if (active) {
                result.setFont(this.getBoldFont(result.getFont()));
            }
            return result;
        }

        private Font getBoldFont(Font originalFont) {
            if (this.boldFont == null) {
                this.boldFont = originalFont.deriveFont(1);
            }
            return this.boldFont;
        }
    }
}

