/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.view;

import chemaxon.marvin.uif.action.GUIDefaults;
import chemaxon.marvin.uif.action.support.LabelInfo;
import chemaxon.marvin.uif.dialog.model.PropertiesProvider;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.util.swing.NullIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ItemRenderer
implements ListCellRenderer,
TableCellRenderer {
    private static final NullIcon NULL_ICON = new NullIcon(GUIDefaults.getDefaultMenuIconSize());
    private static final String SEPARATOR_TEXT = "---------------------------";
    private final PropertiesProvider provider;
    private JPanel renderer;
    private JLabel menuLabel;
    private JLabel arrowLabel;

    public ItemRenderer(PropertiesProvider provider) {
        this.provider = provider;
        this.renderer = new JPanel();
        this.menuLabel = new JLabel();
        this.arrowLabel = new JLabel(new ArrowIcon());
        this.arrowLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.renderer.setLayout(new BoxLayout(this.renderer, 0));
        this.renderer.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.renderer.add(this.menuLabel);
        this.renderer.add(Box.createHorizontalGlue());
        this.renderer.add(this.arrowLabel);
    }

    private void prepareRenderer(JList list, boolean isSelected) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.prepareRenderer((JComponent)list, this.renderer);
    }

    private void prepareRenderer(JComponent parent, JComponent component) {
        component.setEnabled(parent.isEnabled());
        component.setFont(parent.getFont());
        component.setOpaque(true);
    }

    private void prepareRenderer(JTable table, boolean isSelected) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.prepareRenderer((JComponent)table, this.renderer);
    }

    private void setForeground(Color foreground) {
        this.renderer.setForeground(foreground);
        this.menuLabel.setForeground(foreground);
        this.arrowLabel.setForeground(foreground);
    }

    private void setBackground(Color background) {
        this.renderer.setBackground(background);
        this.menuLabel.setBackground(background);
        this.arrowLabel.setBackground(background);
    }

    private void setValue(Object value) {
        Item item = (Item)value;
        if (item == null || item.isSeparator()) {
            this.menuLabel.setText(SEPARATOR_TEXT);
            this.menuLabel.setIcon(NULL_ICON);
        } else {
            DisplayProperties properties = this.provider.getProperties(item);
            LabelInfo label = LabelInfo.parse(properties.getDisplayName());
            this.menuLabel.setText(label.getName());
            this.menuLabel.setIcon(properties.getIcon() != null ? properties.getIcon() : NULL_ICON);
        }
        this.arrowLabel.setVisible(item instanceof ItemGroup);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setValue(value);
        this.prepareRenderer(table, isSelected);
        return this.renderer;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setValue(value);
        this.prepareRenderer(list, isSelected);
        return this.renderer;
    }

    private static class ArrowIcon
    implements Icon {
        private ArrowIcon() {
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public int getIconWidth() {
            return 4;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.drawLine(0, 0, 0, 7);
            g.drawLine(1, 1, 1, 6);
            g.drawLine(2, 2, 2, 5);
            g.drawLine(3, 3, 3, 4);
            g.translate(-x, -y);
        }
    }
}

