/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.view;

import chemaxon.marvin.uif.dialog.model.ItemGroupModel;
import chemaxon.marvin.uif.dialog.model.MenuManagerModel;
import chemaxon.marvin.uif.dialog.view.CustomFormBuilder;
import chemaxon.marvin.uif.dialog.view.ItemRenderer;
import chemaxon.marvin.uif.dialog.view.MenuPathRenderer;
import chemaxon.marvin.uif.dialog.view.ViewUtils;
import chemaxon.marvin.uif.util.swing.AbstractView;
import chemaxon.marvin.uif.util.swing.PopupButton;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MenuView
extends AbstractView {
    private final MenuManagerModel model;
    private final ItemGroupModel menuModel;
    private JComboBox menuComboBox;
    private JButton newMenuButton;
    private JList contentList;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton addButton;
    private PopupButton modifyButton;
    private PopupButton menuButton;
    private JTextArea detailsArea;

    public MenuView(MenuManagerModel model) {
        this.model = model;
        this.menuModel = model.getSelectedMenuModel();
    }

    private void initComponents() {
        this.menuComboBox = new JComboBox(this.model.getMenuSelector());
        this.menuComboBox.setRenderer(new MenuPathRenderer(this.model.getProvider()));
        this.newMenuButton = new JButton(this.model.getNewAction());
        this.menuButton = new PopupButton(this.getString("menu.name"));
        this.menuButton.getPopupMenu().add(this.model.getMoveAction());
        this.menuButton.getPopupMenu().add(this.model.getRenameAction());
        this.menuButton.getPopupMenu().addSeparator();
        this.menuButton.getPopupMenu().add(this.model.getDeleteAction());
        this.contentList = new JList(this.menuModel.getListModel());
        this.contentList.setSelectionModel(this.menuModel.getSelectionModel());
        this.contentList.setCellRenderer(new ItemRenderer(this.menuModel.getProvider()));
        this.contentList.setVisibleRowCount(8);
        this.moveUpButton = new JButton(this.menuModel.getMoveUpAction());
        this.moveDownButton = new JButton(this.menuModel.getMoveDownAction());
        this.addButton = new JButton(this.menuModel.getAddAction());
        this.modifyButton = new PopupButton(this.getString("modify.name"));
        this.modifyButton.getPopupMenu().add(this.menuModel.getAddSubMenuAction());
        this.modifyButton.getPopupMenu().add(this.menuModel.getAddSeparatorAction());
        this.modifyButton.getPopupMenu().addSeparator();
        this.modifyButton.getPopupMenu().add(this.menuModel.getRenameAction());
        this.modifyButton.getPopupMenu().addSeparator();
        this.modifyButton.getPopupMenu().add(this.menuModel.getDeleteAction());
        this.detailsArea = new JTextArea(this.menuModel.getDescription(), 3, 40);
        this.detailsArea.setEditable(false);
        this.detailsArea.setOpaque(false);
        this.detailsArea.setWrapStyleWord(true);
        this.detailsArea.setLineWrap(true);
        this.updateView();
    }

    private void initEventHandling() {
        this.contentList.addListSelectionListener(new SelectionChangeHandler());
    }

    @Override
    protected JComponent buildComponent() {
        this.initComponents();
        this.initEventHandling();
        CustomFormBuilder builder = ViewUtils.createFormBuilder();
        CellConstraints cc = new CellConstraints();
        builder.appendSeparator(this.getString("menu.label"));
        builder.append(this.getString("menus.label"), (Component)this.menuComboBox, (Component)this.newMenuButton);
        builder.append("", null, (Component)this.menuButton);
        builder.appendSeparator(this.getString("contents.label"));
        builder.append(this.getString("entries.label"), null, (Component)this.addButton);
        builder.append("", null, (Component)this.moveUpButton);
        builder.append("", null, (Component)this.moveDownButton);
        builder.append("", null, (Component)this.modifyButton);
        builder.setRowGroupingEnabled(false);
        builder.nextLine(-6);
        builder.nextColumn(2);
        builder.appendRow("p:grow");
        builder.add(new JScrollPane(this.contentList), cc.xywh(builder.getColumn(), builder.getRow(), 1, 8));
        builder.nextLine(builder.getRowCount() - builder.getRow() + 1);
        builder.appendSeparator(this.getString("details.label"));
        builder.append((Component)new JScrollPane(this.detailsArea), builder.getColumnCount() - builder.getLeadingColumnOffset());
        this.model.setComponent(builder.getPanel());
        return builder.getPanel();
    }

    private void updateView() {
        this.detailsArea.setText(this.menuModel.getDescription());
    }

    private class SelectionChangeHandler
    implements ListSelectionListener {
        private SelectionChangeHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MenuView.this.updateView();
        }
    }
}

