/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.view;

import chemaxon.marvin.uif.action.Category;
import chemaxon.marvin.uif.dialog.model.SchemeManagerModel;
import chemaxon.marvin.uif.dialog.view.ActionRenderer;
import chemaxon.marvin.uif.dialog.view.CategoryRenderer;
import chemaxon.marvin.uif.dialog.view.CustomFormBuilder;
import chemaxon.marvin.uif.dialog.view.ViewUtils;
import chemaxon.marvin.uif.shortcut.KeyboardShortcut;
import chemaxon.marvin.uif.shortcut.Shortcut;
import chemaxon.marvin.uif.shortcut.ShortcutScheme;
import chemaxon.marvin.uif.util.swing.AbstractView;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SchemeView
extends AbstractView {
    private static final String ACTIVE_LABEL = "active.label";
    private static final String SCHEMES_TITLE = "schemes.title";
    private static final String SCHEME_LABEL = "scheme.label";
    private static final String BASED_ON_LABEL = "basedOn.label";
    private static final String COMMANDS_TITLE = "commands.title";
    private static final String COMMANDS_LABEL = "commands.label";
    private static final String CATEGORIES_LABEL = "categories.label";
    private static final String SHORTCUTS_LABEL = "shortcuts.label";
    private SchemeManagerModel model;
    private ResourceBundle bundle;
    private JList schemeList;
    private JList categoryList;
    private JList commandList;
    private JList shortcutList;
    private JButton duplicateButton;
    private JButton activateButton;
    private JButton addShortcutButton;
    private JButton removeShortcutButton;
    private JButton deleteSchemeButton;
    private JLabel basedOnLabel;
    private MessageFormat basedOnLabelFormat;

    public SchemeView(SchemeManagerModel model) {
        this.model = model;
        this.bundle = ResourceBundle.getBundle(SchemeView.class.getName());
        this.basedOnLabelFormat = new MessageFormat(this.getString(BASED_ON_LABEL));
    }

    @Override
    protected JComponent buildComponent() {
        this.initComponents();
        this.initEventHandling();
        FormLayout layout = new FormLayout("p:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.buildSchemePanel());
        builder.append(this.buildCommandPanel());
        this.model.setComponent(builder.getPanel());
        return builder.getPanel();
    }

    private JComponent buildSchemePanel() {
        CustomFormBuilder builder = ViewUtils.createFormBuilder();
        CellConstraints cc = new CellConstraints();
        builder.appendSeparator(this.bundle.getString(SCHEMES_TITLE));
        builder.append(this.bundle.getString(SCHEME_LABEL), null, (Component)this.activateButton);
        builder.append("", null, (Component)this.duplicateButton);
        builder.append("", null, (Component)this.deleteSchemeButton);
        builder.appendRow("0:grow");
        builder.nextLine(2);
        builder.append("", (Component)this.basedOnLabel);
        builder.nextLine(-7);
        builder.nextColumn(2);
        builder.add(new JScrollPane(this.schemeList), cc.xywh(builder.getColumn(), builder.getRow(), 1, 6));
        return builder.getPanel();
    }

    private Component buildCommandPanel() {
        FormLayout layout = new FormLayout("6dlu, p:grow, 4dlu, p:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setLeadingColumnOffset(1);
        builder.appendSeparator(this.bundle.getString(COMMANDS_TITLE));
        builder.append(this.bundle.getString(CATEGORIES_LABEL));
        builder.append(this.bundle.getString(COMMANDS_LABEL));
        builder.append((Component)new JScrollPane(this.categoryList), (Component)new JScrollPane(this.commandList));
        builder.append(this.buildShortcutPanel());
        return builder.getPanel();
    }

    private Component buildShortcutPanel() {
        FormLayout layout = new FormLayout("p, 4dlu, p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.append(this.bundle.getString(SHORTCUTS_LABEL));
        builder.nextLine();
        builder.append("", (Component)this.addShortcutButton);
        builder.append("", (Component)this.removeShortcutButton);
        builder.appendRow("0:grow");
        builder.nextLine(-2);
        builder.add((Component)new JScrollPane(this.shortcutList), cc.xywh(builder.getColumn(), builder.getRow(), 1, 4));
        return builder.getPanel();
    }

    private void initComponents() {
        this.schemeList = new JList(this.model.getSchemesList());
        this.schemeList.setCellRenderer(new SchemeRenderer());
        this.schemeList.setSelectionModel(this.model.getSchemeSelection());
        this.schemeList.setVisibleRowCount(3);
        this.basedOnLabel = new JLabel();
        this.duplicateButton = new JButton(this.model.getDuplicateAction());
        this.activateButton = new JButton(this.model.getActivateAction());
        this.deleteSchemeButton = new JButton(this.model.getRemoveAction());
        this.categoryList = new JList(this.model.getCategoriesList());
        this.categoryList.setCellRenderer(new CategoryRenderer());
        this.categoryList.setPrototypeCellValue(new Category("dummy", "MMMMMMMMMMMMMMMMMMMM"));
        this.categoryList.setSelectionModel(this.model.getCategorySelection());
        this.categoryList.setVisibleRowCount(8);
        this.commandList = new JList(this.model.getActionsList());
        this.commandList.setSelectionModel(this.model.getActionSelection());
        this.commandList.setFixedCellWidth(this.categoryList.getFixedCellWidth());
        this.commandList.setCellRenderer(new ActionRenderer());
        this.commandList.setVisibleRowCount(8);
        this.shortcutList = new JList(this.model.getShortcutsList());
        this.shortcutList.setSelectionModel(this.model.getShortcutsSelection());
        this.shortcutList.setCellRenderer(new ShortcutRenderer());
        this.shortcutList.setVisibleRowCount(4);
        this.shortcutList.setPrototypeCellValue(new KeyboardShortcut(KeyStroke.getKeyStroke("shift control meta alt M")));
        this.addShortcutButton = new JButton(this.model.getAddShortcutAction());
        this.removeShortcutButton = new JButton(this.model.getRemoveShortcutAction());
        this.updateView();
    }

    private void initEventHandling() {
        this.schemeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SchemeView.this.updateView();
            }
        });
    }

    private void updateView() {
        String basedOn = this.model.getParentName();
        if (basedOn == null) {
            basedOn = "none";
        }
        this.basedOnLabel.setText(this.basedOnLabelFormat.format(new Object[]{basedOn}));
    }

    private class ShortcutRenderer
    extends DefaultListCellRenderer {
        private ShortcutRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Shortcut shortcut = (Shortcut)value;
            String name = shortcut != null ? shortcut.getName() : null;
            return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
        }
    }

    private class SchemeRenderer
    extends DefaultListCellRenderer {
        private Font boldFont;

        private SchemeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ShortcutScheme scheme;
            String name;
            if (this.boldFont == null) {
                this.boldFont = list.getFont().deriveFont(1);
            }
            String string = name = (scheme = (ShortcutScheme)value) != null ? scheme.getName() : null;
            if (scheme.isActive()) {
                name = name + SchemeView.this.bundle.getString(SchemeView.ACTIVE_LABEL);
            }
            Component delegate = super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            if (scheme.isActive()) {
                delegate.setFont(this.boldFont);
            }
            return delegate;
        }
    }
}

