/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.model;

import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.util.SerialUtils;
import chemaxon.marvin.uif.util.bean.Model;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractItem
extends Model
implements Item,
Externalizable {
    private static final long serialVersionUID = 0L;
    private ItemGroup parent;
    private String id;
    private boolean visible;
    private DisplayProperties properties;

    public AbstractItem(String id, DisplayProperties properties) {
        this.id = id;
        this.properties = properties;
        this.visible = true;
    }

    public AbstractItem(String id) {
        this(id, null);
    }

    public AbstractItem() {
        this(null);
    }

    @Override
    public ItemGroup getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ItemGroup parent) {
        ItemGroup oldParent = this.getParent();
        this.parent = parent;
        this.firePropertyChange("parent", oldParent, this.getParent());
    }

    @Override
    public final String getID() {
        return this.id;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean newValue) {
        boolean oldValue = this.isVisible();
        this.visible = newValue;
        this.firePropertyChange("visible", oldValue, this.isVisible());
    }

    @Override
    public DisplayProperties getDisplayProperties() {
        return this.properties;
    }

    @Override
    public Item clone() {
        AbstractItem result = (AbstractItem)super.clone();
        result.parent = null;
        if (this.properties != null) {
            result.properties = this.properties.clone();
        }
        return result;
    }

    public final int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractItem other = (AbstractItem)obj;
        return (this.id == other.id || this.id != null && this.id.equals(other.id)) && this.visible == other.visible && this.isSeparator() == other.isSeparator() && (this.properties == other.properties || this.properties != null && this.properties.equals(other.properties));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = SerialUtils.readString(in);
        this.visible = in.readBoolean();
        boolean b = in.readBoolean();
        if (b) {
            this.properties = new DisplayProperties();
            this.properties.readExternal(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeString(out, this.id);
        out.writeBoolean(this.visible);
        out.writeBoolean(this.properties != null);
        if (this.properties != null) {
            this.properties.writeExternal(out);
        }
    }
}

