/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.model;

import chemaxon.marvin.uif.model.DefaultItemGroup;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.ToolBarGroup;
import chemaxon.marvin.uif.util.SerialUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class DefaultToolbarGroup
extends DefaultItemGroup
implements ToolBarGroup {
    private static final long serialVersionUID = 1L;
    private int style;
    private String anchor;
    private int row;
    private int index;

    public DefaultToolbarGroup(String id, String name, int style) {
        super(id, new DisplayProperties(name));
        this.style = style;
        this.anchor = null;
        this.row = -1;
        this.index = Integer.MAX_VALUE;
    }

    public DefaultToolbarGroup(String id, String name) {
        this(id, name, 0);
    }

    public DefaultToolbarGroup(String id) {
        this(id, (String)null);
    }

    public DefaultToolbarGroup() {
        this(null);
    }

    @Override
    public int getButtonStyle() {
        return this.style;
    }

    @Override
    public void setButtonStyle(int style) {
        int oldValue = this.getButtonStyle();
        this.style = style;
        this.firePropertyChange("style", oldValue, this.getButtonStyle());
    }

    @Override
    protected boolean isAllowed(Item item) {
        return super.isAllowed(item) && !(item instanceof ItemGroup);
    }

    @Override
    public String getAnchor() {
        return this.anchor;
    }

    @Override
    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public void setRow(int row) {
        this.row = row;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DefaultToolbarGroup other = (DefaultToolbarGroup)obj;
        return this.style == other.style && (this.anchor == other.anchor || this.anchor != null && this.anchor.equals(other.anchor)) && this.row == other.row && this.index == other.index;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.anchor = SerialUtils.readString(in);
        this.style = in.readInt();
        this.row = in.readInt();
        this.index = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerialUtils.writeString(out, this.anchor);
        out.writeInt(this.style);
        out.writeInt(this.row);
        out.writeInt(this.index);
    }
}

