/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.model;

import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.util.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class IDHelper {
    private static final String SEPARATOR_PREFIX = "Separator-";
    private static final String CUSTOM_MENU_PREFIX = "CustomMenu-";
    private static final String CUSTOM_TOOLBAR_PREFIX = "CustomToolbar-";

    private IDHelper() {
    }

    private static Set<String> collectIDs(ItemGroup group) {
        HashSet<String> result = new HashSet<String>(group.getItemCount());
        for (int i = 0; i < group.getItemCount(); ++i) {
            result.add(group.getItem(i).getID());
        }
        return result;
    }

    public static String createUniqueSeparatorID(ItemGroup group) {
        return Utils.createUniqueID(SEPARATOR_PREFIX, IDHelper.collectIDs(group));
    }

    public static String createUniqueCustomMenuID(ItemGroup group) {
        return Utils.createUniqueID(CUSTOM_MENU_PREFIX, IDHelper.collectIDs(group));
    }

    public static String createUniqueCustomToolBarID(GUIRegistry registry) {
        return Utils.createUniqueID(CUSTOM_TOOLBAR_PREFIX, Arrays.asList(registry.getToolBarIDs()));
    }

    public static boolean isCustomToolBarID(String id) {
        return id.startsWith(CUSTOM_TOOLBAR_PREFIX);
    }
}

