/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.module;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.Category;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.GUIDefaults;
import chemaxon.marvin.uif.action.manager.ActionMapAdapter;
import chemaxon.marvin.uif.action.manager.ContextActionRegistry;
import chemaxon.marvin.uif.action.manager.SimpleContext;
import chemaxon.marvin.uif.component.ButtonFactory;
import chemaxon.marvin.uif.component.MenuFactory;
import chemaxon.marvin.uif.controller.Factory;
import chemaxon.marvin.uif.controller.StyledController;
import chemaxon.marvin.uif.controller.TopLevelController;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.RegistryEvent;
import chemaxon.marvin.uif.model.RegistryListener;
import chemaxon.marvin.uif.model.ToolBarGroup;
import chemaxon.marvin.uif.module.Configurer;
import chemaxon.marvin.uif.module.ModuleConfiguration;
import chemaxon.marvin.uif.module.support.ShortcutBinding;
import chemaxon.marvin.uif.shortcut.ShortcutManager;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.bean.Model;
import chemaxon.marvin.uif.util.listener.AbstractWeakListener;
import chemaxon.marvin.uif.util.listener.WeakPropertyChangeListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class GUIModule
extends Model {
    private static Logger logger = Logger.getLogger(GUIModule.class.getName());
    public static final String PROPERTY_SHOW_ICONS = "showIcons";
    public static final String PROPERTY_SHOW_MNEMONICS = "showMnemonics";
    public static final String PROPERTY_USE_LARGE_ICONS = "useLargeIcons";
    public static final String PROPERTY_CUSTOMIZED = "configurationLoaded";
    public static final String PROPERTY_GUI_REGISTRY = "guiRegistry";
    private ButtonFactory buttonFactory;
    private MenuFactory menuFactory;
    private ModuleConfiguration config;
    private ShortcutBinding shortcutBinding;
    private ShortcutManager shortcutManager;
    private ActionRegistry actionManager;
    private TopLevelController<JMenuBar> menuBarController;
    private GUIRegistry registry;
    private PropertyChangeListener configurationListener;
    private PropertyChangeListener iconHandler;
    private RegistryListener registryListener;
    private Map<String, StyledController<JToolBar>> toolBars;
    private Map<String, JToolBar> customToolBars;
    private List<Configurer> configurers;
    private ActionMapAdapter adapter = new ActionMapAdapter(new Category("cusom", "Custom"));
    private boolean showIcons = GUIDefaults.getDefaultMenuIconVisible();
    private boolean showMnemonic = GUIDefaults.getDefaultMnemonicVisible();
    private boolean toolbarFloatable = true;
    private boolean configurationLoaded = false;
    private boolean useLargeIcons = GUIDefaults.getDefaultUseLargeToolBarIcons();

    public GUIModule(ModuleConfiguration config) {
        this();
        this.setConfiguration(config);
    }

    protected GUIModule() {
        this.configurers = Utils.newList();
        this.toolBars = Utils.newMap(5);
        this.customToolBars = Utils.newMap(3);
    }

    protected void setConfiguration(ModuleConfiguration config) {
        this.config = config;
        this.configurationListener = new ConfigurationHandler(this, config);
        config.addPropertyChangeListener(this.configurationListener);
    }

    public synchronized String getActive() {
        return this.config.getActive();
    }

    public synchronized void setActive(String active) {
        this.config.setActive(active);
    }

    public synchronized void addConfigurer(Configurer configurer) {
        this.configurers.add(configurer);
    }

    private Configurer[] getConfigurers() {
        return this.configurers.toArray(new Configurer[this.configurers.size()]);
    }

    public synchronized TopLevelController<JMenuBar> getMenuBarController() {
        if (this.getGUIRegistry() == null) {
            return null;
        }
        if (this.menuBarController == null && this.getGUIRegistry().getMenuBar() != null) {
            this.menuBarController = this.createFactory(this.getActions()).createMenuBar(this.getGUIRegistry().getMenuBar());
            this.menuBarController.setShowMenuIcons(this.isShowIcons());
            this.menuBarController.setShowMnemonic(this.isShowMnemonic());
        }
        return this.menuBarController;
    }

    public synchronized JMenuBar getMenuBar() {
        if (this.getMenuBarController() == null) {
            return null;
        }
        return this.getMenuBarController().getComponent();
    }

    public synchronized StyledController<JToolBar> getToolBarController(String id) {
        if (this.getGUIRegistry() == null) {
            return null;
        }
        StyledController<JToolBar> controller = this.toolBars.get(id);
        if (controller == null && this.getGUIRegistry().getToolBar(id) != null) {
            ToolBarGroup group = this.getGUIRegistry().getToolBar(id);
            controller = this.createFactory(this.getActions()).createToolBar(group);
            controller.setUseLargeIcons(this.getGUIRegistry().getUseLargeIcons());
            this.toolBars.put(id, controller);
        }
        return controller;
    }

    public synchronized void addCustomToolBar(String id, JToolBar toolBar) {
        this.customToolBars.put(id, toolBar);
    }

    public synchronized JToolBar getToolBar(String id) {
        if (this.getToolBarController(id) == null) {
            return null;
        }
        if (this.customToolBars.containsKey(id)) {
            return this.customToolBars.get(id);
        }
        return (JToolBar)this.getToolBarController(id).getComponent();
    }

    public synchronized String[] getToolBarIDs() {
        if (this.getGUIRegistry() == null) {
            return null;
        }
        return this.getGUIRegistry().getToolBarIDs();
    }

    public synchronized TopLevelController<JPopupMenu> createPopupController(String id) {
        return this.createPopupController(id, SimpleContext.emptyContext());
    }

    public synchronized TopLevelController<JPopupMenu> createPopupController(String id, Context context) {
        if (this.getGUIRegistry() == null) {
            return null;
        }
        ItemGroup group = this.getGUIRegistry().getPopup(id);
        if (group == null) {
            return null;
        }
        TopLevelController<JPopupMenu> result = this.createFactory(new ContextActionRegistry(this.getActions(), context)).createPopup(group);
        result.setShowMnemonic(this.showMnemonic);
        result.setShowMenuIcons(this.showIcons);
        return result;
    }

    protected Factory createFactory(ActionRegistry actionRegistry) {
        Factory result = this.createFactory();
        result.setRegistry(actionRegistry);
        if (this.buttonFactory != null) {
            result.setButtonFactory(this.buttonFactory);
        }
        if (this.menuFactory != null) {
            result.setMenuFactory(this.menuFactory);
        }
        return result;
    }

    protected static final Object newInstance(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        catch (InstantiationException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return null;
    }

    protected Factory createFactory() {
        return (Factory)GUIModule.newInstance("chemaxon.marvin.uif.controller.impl.ControllerBuilder");
    }

    public synchronized String[] getPopupIDs() {
        return this.getGUIRegistry().getPopupIDs();
    }

    public synchronized JPopupMenu showPopup(String id, Context context, MouseEvent e) {
        TopLevelController<JPopupMenu> controller = this.createPopupController(id, context);
        return this.showPopup(controller, e);
    }

    private JPopupMenu showPopup(TopLevelController<JPopupMenu> controller, MouseEvent e) {
        if (controller == null) {
            return null;
        }
        JPopupMenu popup = controller.getComponent();
        popup.show(e.getComponent(), e.getX(), e.getY());
        return popup;
    }

    public synchronized JPopupMenu showPopup(String id, MouseEvent e) {
        return this.showPopup(this.createPopupController(id), e);
    }

    public final synchronized ActionRegistry getActions() {
        this.checkManager();
        return this.actionManager;
    }

    protected void actionsLoaded() {
    }

    private void checkManager() {
        if (this.actionManager == null) {
            this.actionManager = this.config.createActions(this.adapter, this.getConfigurers());
            this.shortcutBinding = new ShortcutBinding(this.getShortcutManager(), this.actionManager);
            this.actionsLoaded();
        }
    }

    private void setGUIRegistry(GUIRegistry aRegistry) {
        if (this.registry == aRegistry) {
            return;
        }
        if (this.registry != null) {
            this.removeRegistryListeners();
            this.releaseControllers();
        }
        this.registry = aRegistry;
        if (this.registry != null) {
            this.setUseLargeIcons(this.registry.getUseLargeIcons());
            this.addRegistryListeners();
        }
        this.firePropertyChange(PROPERTY_GUI_REGISTRY, null, null);
    }

    public final synchronized GUIRegistry getGUIRegistry() {
        if (this.registry == null) {
            this.setGUIRegistry(this.config.getActiveRegistry());
        }
        return this.registry;
    }

    public final synchronized ShortcutManager getShortcutManager() {
        if (this.shortcutManager == null) {
            this.shortcutManager = this.config.createShortcutManager();
        }
        return this.shortcutManager;
    }

    public synchronized void bindComponent(JComponent component) {
        this.checkManager();
        this.shortcutBinding.bindComponent(component);
    }

    public synchronized void unbindComponent(JComponent component) {
        this.shortcutBinding.unbindComponent(component);
    }

    public synchronized void registerAction(String id, Action action) {
        this.getActions().register(id, action);
    }

    public synchronized void registerAction(String id, String category, Action action) {
        this.getActions().register(id, category, action);
    }

    public synchronized boolean isShowIcons() {
        return this.showIcons;
    }

    public synchronized void setShowIcons(boolean showIcons) {
        boolean oldValue = this.isShowIcons();
        this.showIcons = showIcons;
        if (this.menuBarController != null) {
            this.menuBarController.setShowMenuIcons(showIcons);
        }
        for (StyledController<JToolBar> controller : this.toolBars.values()) {
            controller.setShowMenuIcons(showIcons);
        }
        this.firePropertyChange(PROPERTY_SHOW_ICONS, oldValue, this.isShowIcons());
    }

    public synchronized boolean isShowMnemonic() {
        return this.showMnemonic;
    }

    public synchronized void setShowMnemonic(boolean showMnemonic) {
        boolean oldValue = this.isShowMnemonic();
        this.showMnemonic = showMnemonic;
        if (this.menuBarController != null) {
            this.menuBarController.setShowMnemonic(showMnemonic);
        }
        this.firePropertyChange(PROPERTY_SHOW_MNEMONICS, oldValue, this.isShowMnemonic());
    }

    public synchronized void setToolbarFloatable(boolean floatable) {
        boolean oldValue = this.isToolbarFloatable();
        this.toolbarFloatable = floatable;
        this.firePropertyChange("toolbarFloatable", oldValue, floatable);
    }

    public boolean isToolbarFloatable() {
        return this.toolbarFloatable;
    }

    public synchronized void setUseLargeIcons(boolean useLargeIcons) {
        if (this.useLargeIcons == useLargeIcons) {
            return;
        }
        boolean oldValue = this.useLargeIcons;
        this.useLargeIcons = useLargeIcons;
        if (this.registry != null) {
            this.registry.setUseLargeIcons(useLargeIcons);
            for (StyledController<JToolBar> controller : this.toolBars.values()) {
                controller.setUseLargeIcons(useLargeIcons);
            }
        }
        this.firePropertyChange(PROPERTY_USE_LARGE_ICONS, oldValue, useLargeIcons);
    }

    public synchronized boolean getUseLargeIcons() {
        return this.useLargeIcons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadConfiguration(InputStream is) throws IOException {
        try {
            this.config.loadConfiguration(is);
        }
        finally {
            this.configurationLoaded = true;
        }
    }

    public synchronized void saveConfiguration(OutputStream os) throws IOException {
        this.config.saveConfiguration(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadShortcutConfiguration(InputStream is) throws IOException {
        try {
            this.config.loadShortcutConfiguration(this.getShortcutManager(), is);
        }
        finally {
            this.configurationLoaded = true;
        }
    }

    public synchronized void saveShortcutConfiguration(OutputStream os) throws IOException {
        this.config.saveShortcutConfiguration(this.getShortcutManager(), os);
    }

    public synchronized void dispose() {
        this.releaseControllers();
        if (this.shortcutBinding != null) {
            this.shortcutBinding.release();
        }
        if (this.configurationListener != null) {
            this.config.removePropertyChangeListener(this.configurationListener);
            this.configurationListener = null;
        }
        this.setGUIRegistry(null);
    }

    public synchronized void updateUI() {
        if (this.menuBarController != null && this.menuBarController.hasComponent()) {
            this.menuBarController.getComponent().updateUI();
        }
        for (StyledController<JToolBar> controller : this.toolBars.values()) {
            if (!controller.hasComponent()) continue;
            ((JToolBar)controller.getComponent()).updateUI();
        }
    }

    public synchronized boolean isConfigurationLoaded() {
        return this.configurationLoaded;
    }

    public synchronized void clearConfigurationLoaded() {
        this.configurationLoaded = false;
    }

    public synchronized ModuleConfiguration getModuleConfiguration() {
        return this.config;
    }

    public boolean isResetConfigurationAllowed() {
        return this.getActive() != null && this.config.getRegistryDefaults(this.getActive()) != null;
    }

    public synchronized void resetCurrentConfiguration() {
        if (this.getActive() != null) {
            this.resetConfiguration(this.getActive());
        }
    }

    public synchronized void resetConfiguration(String id) {
        this.config.resetRegistry(id);
    }

    public synchronized ButtonFactory getButtonFactory() {
        return this.buttonFactory;
    }

    public synchronized void setButtonFactory(ButtonFactory buttonFactory) {
        this.buttonFactory = buttonFactory;
    }

    public synchronized MenuFactory getMenuFactory() {
        return this.menuFactory;
    }

    public synchronized void setMenuFactory(MenuFactory menuFactory) {
        this.menuFactory = menuFactory;
    }

    private void addRegistryListeners() {
        if (this.getGUIRegistry() != null) {
            this.registryListener = new RegistryHandler(this, this.getGUIRegistry());
            this.iconHandler = new IconHandler(this, this.getGUIRegistry());
            this.getGUIRegistry().addRegistryListener(this.registryListener);
            this.getGUIRegistry().addPropertyChangeListener(this.iconHandler);
        }
    }

    private void removeRegistryListeners() {
        if (this.getGUIRegistry() != null && this.registryListener != null) {
            this.registry.removeRegistryListener(this.registryListener);
            this.registry.removePropertyChangeListener(this.iconHandler);
            this.registryListener = null;
            this.iconHandler = null;
        }
    }

    private void releaseControllers() {
        this.releaseMenuBar();
        String[] toolBarIDs = this.toolBars.keySet().toArray(new String[this.toolBars.keySet().size()]);
        for (int i = 0; i < toolBarIDs.length; ++i) {
            this.releaseToolBar(toolBarIDs[i]);
        }
        this.toolBars.clear();
    }

    private synchronized void releaseToolBar(String id) {
        StyledController<JToolBar> controller = this.toolBars.remove(id);
        if (controller != null) {
            controller.dispose();
        }
    }

    private synchronized void releaseMenuBar() {
        if (this.menuBarController != null) {
            this.menuBarController.dispose();
            this.menuBarController = null;
        }
    }

    private synchronized void activeConfigurationChanged() {
        this.setGUIRegistry(this.config.getActiveRegistry());
    }

    public void setActionMap(ActionMap map) {
        this.adapter.setActionMap(map);
    }

    private static class IconHandler
    extends WeakPropertyChangeListener {
        public IconHandler(GUIModule target, GUIRegistry source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            if (GUIModule.PROPERTY_USE_LARGE_ICONS.equals(evt.getPropertyName())) {
                ((GUIModule)target).setUseLargeIcons(((GUIRegistry)source).getUseLargeIcons());
            }
        }
    }

    private static class RegistryHandler
    extends AbstractWeakListener
    implements RegistryListener {
        public RegistryHandler(GUIModule target, GUIRegistry source) {
            super(target, source, RegistryListener.class);
        }

        @Override
        public void popupAdded(RegistryEvent e) {
        }

        @Override
        public void popupRemoved(RegistryEvent e) {
        }

        @Override
        public void toolBarAdded(RegistryEvent e) {
        }

        @Override
        public void toolBarRemoved(RegistryEvent e) {
            GUIModule target = (GUIModule)this.getTarget();
            if (target != null) {
                target.releaseToolBar(e.getGroup().getID());
            }
        }

        @Override
        public void menuBarAdded(RegistryEvent e) {
        }

        @Override
        public void menuBarRemoved(RegistryEvent e) {
            GUIModule target = (GUIModule)this.getTarget();
            if (target != null) {
                target.releaseMenuBar();
            }
        }
    }

    private static class ConfigurationHandler
    extends WeakPropertyChangeListener {
        public ConfigurationHandler(GUIModule target, ModuleConfiguration source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || evt.getPropertyName().equals("activeRegistry")) {
                ((GUIModule)target).activeConfigurationChanged();
            }
        }
    }
}

