/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.module.support;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.RegistryEvent;
import chemaxon.marvin.uif.action.RegistryListener;
import chemaxon.marvin.uif.action.manager.ActionManager;
import chemaxon.marvin.uif.action.support.WeakRegistryListener;
import chemaxon.marvin.uif.shortcut.KeyboardShortcut;
import chemaxon.marvin.uif.shortcut.Shortcut;
import chemaxon.marvin.uif.shortcut.ShortcutEvent;
import chemaxon.marvin.uif.shortcut.ShortcutListener;
import chemaxon.marvin.uif.shortcut.ShortcutManager;
import chemaxon.marvin.uif.shortcut.ShortcutScheme;
import chemaxon.marvin.uif.util.listener.AbstractWeakListener;
import chemaxon.marvin.uif.util.listener.WeakPropertyChangeListener;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.InputMapUIResource;

public class ShortcutBinding
implements RegistryListener {
    private ShortcutManager manager;
    private ShortcutScheme currentScheme;
    private ActionRegistry registry;
    private RegistryListener registryHandler;
    private ShortcutListener schemeHandler;
    private PropertyChangeListener managerHandler;
    private Map<JComponent, Object> managedComponents = new WeakHashMap<JComponent, Object>();

    public ShortcutBinding(ShortcutManager manager, ActionRegistry registry) {
        this.manager = manager;
        this.registry = registry;
        this.initListeners();
        this.initEventHandling();
        if (manager.getActiveShortcutScheme() != null) {
            this.schemeChanged();
        }
    }

    private void initListeners() {
        this.managerHandler = new ManagerHandler(this, this.manager);
        this.registryHandler = new WeakRegistryListener(this, this.registry);
    }

    private void initEventHandling() {
        this.manager.addPropertyChangeListener(this.managerHandler);
        this.registry.addRegistryListener(this.registryHandler);
    }

    private void removeListeners() {
        this.manager.removePropertyChangeListener(this.managerHandler);
        this.registry.removeRegistryListener(this.registryHandler);
    }

    private void schemeChanged() {
        this.setActiveScheme(this.manager.getActiveShortcutScheme());
    }

    private void setActiveScheme(ShortcutScheme scheme) {
        ShortcutScheme oldScheme = this.currentScheme;
        if (this.currentScheme != null) {
            this.currentScheme.removeShortcutListener(this.schemeHandler);
            this.schemeHandler = null;
            this.currentScheme = null;
        }
        this.currentScheme = scheme;
        if (this.currentScheme != null) {
            this.schemeHandler = new SchemeHandler(this, this.currentScheme);
            this.currentScheme.addShortcutListener(this.schemeHandler);
        }
        this.updateComponentBindings();
        this.updateRegistryBindings(oldScheme, this.currentScheme);
    }

    private void updateComponentBindings() {
        int i;
        JComponent[] components = this.managedComponents.keySet().toArray(new JComponent[this.managedComponents.keySet().size()]);
        for (i = 0; i < components.length; ++i) {
            this.unbindComponent(components[i]);
        }
        for (i = 0; i < components.length; ++i) {
            this.bindComponent(components[i]);
        }
    }

    private void updateRegistryBindings(ShortcutScheme oldScheme, ShortcutScheme newScheme) {
        HashSet<String> ids = new HashSet<String>();
        if (oldScheme != null) {
            ids.addAll(Arrays.asList(oldScheme.getCommandIDs()));
        }
        if (newScheme != null) {
            ids.addAll(Arrays.asList(newScheme.getCommandIDs()));
        }
        for (String id : ids) {
            this.updateActionShortcut(id);
        }
    }

    private void updateActionShortcut(String id) {
        KeyStroke key;
        KeyboardShortcut shortcut = this.getDefaultShortcut(id);
        KeyStroke keyStroke = key = shortcut != null ? shortcut.getKeyStroke() : null;
        if (this.registry.hasAction(id)) {
            Action action = this.registry instanceof ActionManager ? ((ActionManager)this.registry).getActionOrStub(id) : this.registry.getAction(id);
            action.putValue("AcceleratorKey", key);
        }
    }

    private KeyboardShortcut getDefaultShortcut(String actionID) {
        Shortcut[] shortcuts = this.getShortcuts(actionID);
        for (int i = 0; i < shortcuts.length; ++i) {
            if (!(shortcuts[i] instanceof KeyboardShortcut)) continue;
            return (KeyboardShortcut)shortcuts[i];
        }
        return null;
    }

    private Shortcut[] getShortcuts(String actionID) {
        return this.currentScheme != null ? this.currentScheme.getShortcuts(actionID) : new Shortcut[]{};
    }

    public void bindComponent(JComponent component) {
        if (this.managedComponents.containsKey(component)) {
            return;
        }
        this.managedComponents.put(component, Boolean.TRUE);
        if (this.currentScheme == null) {
            return;
        }
        this.bindComponent(component, 1);
    }

    private void bindComponent(JComponent component, int type) {
        InputMap inputMap = type == 2 ? new ComponentInputMapExt(component) : new InputMapExt();
        ActionMap actionMap = component.getActionMap();
        ShortcutBinding.addShortcutInputMap(component, type, inputMap);
        Shortcut[] shortcuts = this.currentScheme.getShortcuts();
        for (int i = 0; i < shortcuts.length; ++i) {
            if (!(shortcuts[i] instanceof KeyboardShortcut)) continue;
            this.bindShortcut(inputMap, actionMap, (KeyboardShortcut)shortcuts[i]);
        }
    }

    private void bindShortcut(InputMap inputMap, ActionMap actionMap, KeyboardShortcut shortcut) {
        if (inputMap == null || actionMap == null || shortcut == null) {
            return;
        }
        String commandID = this.currentScheme.getCommandID(shortcut);
        if (commandID == null) {
            return;
        }
        Key key = new Key(commandID);
        inputMap.put(shortcut.getKeyStroke(), key);
        this.addToActionMap(actionMap, commandID);
        actionMap.put(key, new DelegatingAction(this.registry, commandID));
    }

    public void unbindComponent(JComponent component) {
        if (!this.managedComponents.containsKey(component)) {
            return;
        }
        this.unbindComponent(component, 1);
        this.removeFromActionMap(component);
        this.managedComponents.remove(component);
    }

    public void release() {
        this.removeListeners();
        this.setActiveScheme(null);
        JComponent[] components = this.managedComponents.keySet().toArray(new JComponent[this.managedComponents.size()]);
        for (int i = 0; i < components.length; ++i) {
            this.unbindComponent(components[i]);
        }
    }

    private boolean unbindComponent(JComponent component, int type) {
        InputMap inputMap = ShortcutBinding.getShortcutInputMap(component, type);
        if (inputMap == null) {
            return false;
        }
        KeyStroke[] keys = inputMap.keys();
        if (keys != null) {
            ShortcutBinding.removeShortcutInputMap(component, type);
        }
        return true;
    }

    private void removeFromActionMap(JComponent component) {
        String[] ids = this.registry.getActionIDs();
        for (int i = 0; i < ids.length; ++i) {
            this.removeFromActionMap(component, ids[i]);
        }
    }

    private void shortcutChanged(ShortcutEvent event) {
        if (event.getType() == 1) {
            this.updateActionShortcut(event.getCommandID());
            this.addShortcut(event.getShortcut());
        } else if (event.getType() == 2) {
            this.updateActionShortcut(event.getCommandID());
            this.removeShortcut(event.getShortcut());
        }
    }

    @Override
    public void actionRegistered(RegistryEvent e) {
        if (this.currentScheme != null) {
            this.updateActionShortcut(e.getActionID());
        }
    }

    @Override
    public void actionRemoved(RegistryEvent e) {
        if (this.currentScheme != null) {
            Iterator<JComponent> it = this.managedComponents.keySet().iterator();
            while (it.hasNext()) {
                this.removeFromActionMap(it.next(), e.getActionID());
            }
        }
    }

    private void addShortcut(Shortcut shortcut) {
        if (!(shortcut instanceof KeyboardShortcut)) {
            return;
        }
        KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
        for (JComponent component : this.managedComponents.keySet()) {
            this.addToInputMap(component, 1, keyboardShortcut);
            this.addToActionMap(component, keyboardShortcut);
        }
    }

    private void addToInputMap(JComponent component, int type, KeyboardShortcut shortcut) {
        InputMap inputMap = ShortcutBinding.getShortcutInputMap(component, type);
        String commandID = this.currentScheme.getCommandID(shortcut);
        if (commandID != null) {
            inputMap.put(shortcut.getKeyStroke(), new Key(commandID));
        } else {
            inputMap.put(shortcut.getKeyStroke(), null);
        }
    }

    private void addToActionMap(JComponent component, KeyboardShortcut shortcut) {
        String commandID = this.currentScheme.getCommandID(shortcut);
        if (commandID != null) {
            this.addToActionMap(component.getActionMap(), commandID);
        }
    }

    private void addToActionMap(ActionMap actionMap, String commandID) {
        actionMap.put(new Key(commandID), new DelegatingAction(this.registry, commandID));
    }

    private void removeShortcut(Shortcut shortcut) {
        if (!(shortcut instanceof KeyboardShortcut)) {
            return;
        }
        KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
        for (JComponent component : this.managedComponents.keySet()) {
            this.removeFromInputMap(component, 1, keyboardShortcut);
            this.removeFromActionMap(component, keyboardShortcut);
        }
    }

    private void removeFromInputMap(JComponent component, int type, KeyboardShortcut shortcut) {
        InputMap inputMap = ShortcutBinding.getShortcutInputMap(component, type);
        inputMap.put(shortcut.getKeyStroke(), null);
    }

    private void removeFromActionMap(JComponent component, KeyboardShortcut shortcut) {
        String commandID = this.currentScheme.getCommandID(shortcut);
        this.removeFromActionMap(component, commandID);
    }

    private void removeFromActionMap(JComponent component, String commandID) {
        if (this.currentScheme != null && !this.currentScheme.isCommandBound(commandID)) {
            return;
        }
        component.getActionMap().remove(new Key(commandID));
    }

    private void handlePropertyChange(PropertyChangeEvent ignored) {
        this.schemeChanged();
    }

    public static void removeShortcutInputMap(JComponent component, int type) {
        InputMap map = component.getInputMap(type);
        while (map != null) {
            InputMap parent = map.getParent();
            if (parent instanceof ShortcutInputMap) {
                parent.clear();
                map.setParent(parent.getParent());
                return;
            }
            map = parent;
        }
    }

    public static InputMap getShortcutInputMap(JComponent component, int type) {
        for (InputMap map = component.getInputMap(type); map != null; map = map.getParent()) {
            if (map.getParent() == null || !(map.getParent() instanceof ShortcutInputMap)) continue;
            return map.getParent();
        }
        return null;
    }

    public static void addShortcutInputMap(JComponent component, int type, InputMap inputMap) {
        InputMap map = component.getInputMap(type);
        while (map != null) {
            InputMap parent = map.getParent();
            if (parent == null || parent instanceof InputMapUIResource) {
                inputMap.setParent(parent);
                map.setParent(inputMap);
                return;
            }
            map = parent;
        }
    }

    private static class DelegatingAction
    extends AbstractAction {
        private ActionRegistry registry;

        private DelegatingAction(ActionRegistry registry, String id) {
            this.registry = registry;
            this.putValue("ActionCommandKey", id);
        }

        private String getID() {
            return (String)this.getValue("ActionCommandKey");
        }

        @Override
        public boolean isEnabled() {
            return this.registry.hasAction(this.getID()) && this.registry.getAction(this.getID()).isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.registry.hasAction(this.getID())) {
                this.registry.getAction(this.getID()).actionPerformed(arg0);
            }
        }
    }

    private static class InputMapExt
    extends InputMap
    implements ShortcutInputMap {
    }

    private static class ComponentInputMapExt
    extends ComponentInputMap
    implements ShortcutInputMap {
        public ComponentInputMapExt(JComponent component) {
            super(component);
        }
    }

    private static interface ShortcutInputMap {
    }

    private static class SchemeHandler
    extends AbstractWeakListener
    implements ShortcutListener {
        public SchemeHandler(Object target, Object source) {
            super(target, source, ShortcutListener.class);
        }

        @Override
        public void shortcutChanged(ShortcutEvent event) {
            ShortcutBinding target = (ShortcutBinding)this.getTarget();
            if (target != null) {
                target.shortcutChanged(event);
            }
        }
    }

    private static class ManagerHandler
    extends WeakPropertyChangeListener {
        public ManagerHandler(ShortcutBinding target, ShortcutManager source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || "activeShortcutSet".equals(evt.getPropertyName())) {
                ShortcutBinding binding = (ShortcutBinding)target;
                binding.handlePropertyChange(evt);
            }
        }
    }

    private static class Key {
        private String id;

        public Key(String id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key o = (Key)obj;
            return this.id.equals(o.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

