/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.resource;

import chemaxon.marvin.uif.resource.ClassLoaderIconFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public final class IconRepository {
    private static final IconRepository INSTANCE = new IconRepository();
    private Map<String, Factory> repositories = new HashMap<String, Factory>();
    private Map<String, Icon> iconCache = new HashMap<String, Icon>();
    private Factory defaultRepository;

    private IconRepository() {
    }

    public static void addRepository(String scheme, Factory repository) {
        if (scheme == null || scheme.length() == 0) {
            throw new NullPointerException("Scheme must not be null");
        }
        if (repository == null) {
            throw new NullPointerException("Repository must not be null");
        }
        IconRepository.INSTANCE.repositories.put(scheme, repository);
    }

    public static synchronized void setDefaultFactory(Factory repository) {
        IconRepository.INSTANCE.defaultRepository = repository;
    }

    public static synchronized Icon getIcon(String path) {
        URI uri;
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        if (IconRepository.INSTANCE.iconCache.containsKey(path)) {
            return IconRepository.INSTANCE.iconCache.get(path);
        }
        try {
            uri = new URI(path);
        }
        catch (URISyntaxException e) {
            Logger.getLogger(IconRepository.class.getName()).log(Level.WARNING, "Invalid icon uri: " + path);
            return null;
        }
        Factory repository = IconRepository.INSTANCE.repositories.get(uri.getScheme());
        if (repository == null) {
            repository = IconRepository.INSTANCE.defaultRepository;
        }
        Icon result = repository.getIcon(path);
        IconRepository.INSTANCE.iconCache.put(path, result);
        return result;
    }

    static {
        IconRepository.setDefaultFactory(new ClassLoaderIconFactory());
    }

    public static interface Factory {
        public Icon getIcon(String var1);
    }
}

