/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util;

import chemaxon.marvin.uif.util.MappedResourceBundle;
import chemaxon.marvin.uif.util.PublicCloneable;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.UIManager;

public final class Utils {
    private static final short MY_MAGIC_NUMBER = 26658;
    private static final String OS_NAME = System.getProperty("os.name");
    public static final boolean IS_MAC = OS_NAME.toLowerCase().startsWith("mac os");

    private Utils() {
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <E> List<E> newList() {
        return new ArrayList();
    }

    public static <E> List<E> newList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <K, V> Map<K, V> newMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    public static <K, V> LinkedHashMap<K, V> clone(LinkedHashMap<K, V> map) {
        return Utils.cloneMap(map, new LinkedHashMap());
    }

    private static <K, V, T extends Map<K, V>> T cloneMap(Map<K, V> original, T clone) {
        for (K key : original.keySet()) {
            Object o = original.get(key);
            if (o instanceof PublicCloneable) {
                o = ((PublicCloneable)o).clone();
            }
            clone.put(key, o);
        }
        return clone;
    }

    public static String createUniqueID(String prefix, Collection<String> currentIDs) {
        int i = 0;
        String id;
        while (currentIDs.contains(id = prefix + i)) {
            ++i;
        }
        return id;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static int hash(Object ... fields) {
        return Arrays.hashCode(fields);
    }

    public static String getString(ResourceBundle bundle, String prefix, String propertyName, String suffix, String defaultValue) {
        String key = prefix + "." + propertyName;
        if (suffix != null && suffix.length() != 0) {
            key = key + "[" + suffix + "]";
        }
        return Utils.getString(bundle, key, defaultValue);
    }

    public static String getString(ResourceBundle bundle, String bundleKey, String defaultValue) {
        if (bundle instanceof MappedResourceBundle) {
            return Utils.getStringImpl((MappedResourceBundle)bundle, bundleKey, defaultValue);
        }
        return Utils.getStringImpl(bundle, bundleKey, defaultValue);
    }

    private static String getStringImpl(MappedResourceBundle bundle, String bundleKey, String defaultValue) {
        String key;
        if (IS_MAC && bundle.contains(key = bundleKey + ".mac")) {
            return bundle.getString(key);
        }
        if (!bundle.contains(bundleKey)) {
            return defaultValue;
        }
        return bundle.getString(bundleKey);
    }

    private static String getStringImpl(ResourceBundle bundle, String bundleKey, String defaultValue) {
        try {
            return bundle.getString(bundleKey);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public static boolean isLafAqua() {
        return UIManager.getLookAndFeel().getID().equals("Aqua");
    }

    public static InputStream getInputStream(String id) {
        try {
            URL url = new URL(id);
            return url.openStream();
        }
        catch (Exception ignored) {
            try {
                return new FileInputStream(id);
            }
            catch (FileNotFoundException ignored2) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return Utils.class.getClassLoader().getResourceAsStream(id);
        }
    }

    public static void close(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static short readShort(InputStream is) throws IOException {
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public static void writeShort(OutputStream os, short value) throws IOException {
        os.write(value >>> 8 & 0xFF);
        os.write(value >>> 0 & 0xFF);
    }

    public static class VersionedOutputStream
    extends FilterOutputStream {
        public VersionedOutputStream(OutputStream out, short version) throws IOException {
            super(out);
            this.writeHeader(version);
        }

        private void writeHeader(short version) throws IOException {
            Utils.writeShort(this.out, (short)26658);
            Utils.writeShort(this.out, version);
        }
    }

    public static class VersionedInputStream
    extends FilterInputStream {
        private short version = (short)-1;

        public VersionedInputStream(InputStream in) throws IOException {
            super(new BufferedInputStream(in));
            this.readHeader();
        }

        private void readHeader() throws IOException {
            this.in.mark(1);
            if (Utils.readShort(this.in) == 26658) {
                this.version = Utils.readShort(this.in);
            } else {
                this.in.reset();
            }
        }

        public short getVersion() {
            return this.version;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }
    }
}

