/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util.listener;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractWeakListener
implements Serializable {
    private transient OwnedWeakReference target;
    private transient OwnedWeakReference source;
    private static ListenerQueue queue;
    private Class listenerType;

    public AbstractWeakListener(Object target, Object source, Class listenerType) {
        if (!listenerType.isInterface()) {
            throw new IllegalArgumentException();
        }
        this.setTarget(target);
        this.setSource(source);
        this.listenerType = listenerType;
    }

    protected String getRemoveMethodName() {
        return "remove" + this.listenerType.getSimpleName();
    }

    private void cleanUp() {
        this.source = null;
        this.target = null;
    }

    public synchronized void removeListener() {
        try {
            Object sourceObject = this.getSource();
            if (sourceObject == null) {
                this.cleanUp();
                return;
            }
            Method removeListener = sourceObject.getClass().getMethod(this.getRemoveMethodName(), this.listenerType);
            removeListener.invoke(sourceObject, this);
            this.cleanUp();
        }
        catch (NoSuchMethodException ignored) {
            ignored.printStackTrace();
        }
        catch (IllegalAccessException ignored) {
            ignored.printStackTrace();
        }
        catch (InvocationTargetException ignored) {
            ignored.printStackTrace();
        }
    }

    private void setTarget(Object c) {
        this.target = new OwnedWeakReference(c, this, AbstractWeakListener.getQueue());
    }

    private void setSource(Object c) {
        this.source = new OwnedWeakReference(c, this, null);
    }

    WeakReference getTargetRef() {
        return this.target;
    }

    WeakReference getSourceRef() {
        return this.source;
    }

    public Object getTarget() {
        if (this.target == null) {
            return null;
        }
        Object result = this.target.get();
        if (result == null) {
            this.removeListener();
        }
        return result;
    }

    public Object getSource() {
        if (this.source == null) {
            return null;
        }
        Object result = this.source.get();
        return result;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getTarget());
        s.writeObject(this.getSource());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object source;
        s.defaultReadObject();
        Object target = s.readObject();
        if (target != null) {
            this.setTarget(target);
        }
        if ((source = s.readObject()) != null) {
            this.setSource(source);
        }
    }

    private static synchronized ReferenceQueue getQueue() {
        if (queue == null) {
            queue = new ListenerQueue();
            AbstractWeakListener.queue.startCleanUpThread();
        }
        return queue;
    }

    private static class ListenerQueue
    extends ReferenceQueue
    implements Runnable {
        private ListenerQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        ref = (OwnedWeakReference)this.remove(0L);
                        try {
                            ref.getOwner().removeListener();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        finally {
                            ref = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException var1_2) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }

        private synchronized void startCleanUpThread() {
            Thread cleanUpThread = new Thread((Runnable)this, "Reference cleanup thread");
            cleanUpThread.setDaemon(true);
            cleanUpThread.setPriority(1);
            cleanUpThread.start();
        }
    }

    private static class OwnedWeakReference
    extends WeakReference {
        private AbstractWeakListener owner;

        OwnedWeakReference(Object target, AbstractWeakListener owner, ReferenceQueue queue) {
            super(target, queue);
            this.owner = owner;
        }

        public AbstractWeakListener getOwner() {
            return this.owner;
        }
    }
}

