/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

class CompoundIcon
implements Icon {
    private static final int DEFAULT_GAP = 5;
    private final int gap;
    private final Icon leftIcon;
    private final Icon rightIcon;

    public CompoundIcon(Icon leftIcon, Icon rightIcon) {
        this(leftIcon, rightIcon, 5);
    }

    public CompoundIcon(Icon leftIcon, Icon rightIcon, int gap) {
        this.leftIcon = leftIcon;
        this.rightIcon = rightIcon;
        this.gap = gap;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.leftIcon.paintIcon(c, g, x, y + this.getOffset(this.leftIcon));
        this.rightIcon.paintIcon(c, g, x + this.gap + this.leftIcon.getIconWidth(), y + this.getOffset(this.rightIcon));
    }

    private int getOffset(Icon icon) {
        return (this.getIconHeight() - icon.getIconHeight()) / 2;
    }

    @Override
    public int getIconWidth() {
        return this.leftIcon.getIconWidth() + this.gap + this.rightIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.leftIcon.getIconHeight(), this.rightIcon.getIconHeight());
    }
}

