/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util.swing;

import chemaxon.marvin.uif.util.swing.ArrowIcon;
import chemaxon.marvin.uif.util.swing.CompoundIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private JPopupMenu popup;

    public PopupButton(String text, Icon icon) {
        super(text);
        this.setIcon(icon);
        this.setHorizontalTextPosition(2);
        this.popup = new JPopupMenu();
        this.addActionListener(new TriggerHandler());
    }

    public PopupButton(Icon icon) {
        this(null, icon);
    }

    public PopupButton(String text) {
        this(text, null);
    }

    public PopupButton() {
        this(null, null);
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon != null ? new CompoundIcon(defaultIcon, new ArrowIcon()) : new ArrowIcon());
    }

    public void addPopupItem(JMenuItem item) {
        this.getPopupMenu().add(item);
    }

    public void addPopupSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    private class TriggerHandler
    implements ActionListener {
        private TriggerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupButton.this.popup.show(PopupButton.this, 0, PopupButton.this.getHeight());
        }
    }
}

