/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SizeRequirements;

class ToolBarBoxLayout
implements LayoutManager2 {
    private int axis;
    private JToolBar toolbar;
    private JComponent moreButton;
    private boolean moreAlwaysVisible;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;

    public ToolBarBoxLayout(JToolBar component, int axis) {
        if (axis != 0 && axis != 1) {
            throw new AWTError("Invalid axis");
        }
        this.toolbar = component;
        this.axis = axis;
        this.moreAlwaysVisible = false;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.invalidateLayout(comp.getParent());
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.invalidateLayout(comp.getParent());
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        this.checkRequests();
        return this.xTotal.alignment;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        this.checkRequests();
        return this.yTotal.alignment;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        int nChildren = this.toolbar.getComponentCount();
        int[] xOffsets = new int[nChildren];
        int[] xSpans = new int[nChildren];
        int[] yOffsets = new int[nChildren];
        int[] ySpans = new int[nChildren];
        Dimension alloc = this.toolbar.getSize();
        Insets in = this.toolbar.getInsets();
        alloc.width -= in.left + in.right;
        alloc.height -= in.top + in.bottom;
        int absoluteAxis = this.axis;
        boolean ltr = true;
        ToolBarBoxLayout toolBarBoxLayout = this;
        synchronized (toolBarBoxLayout) {
            this.checkRequests();
            if (absoluteAxis == 0) {
                SizeRequirements.calculateTiledPositions(alloc.width, this.xTotal, this.xChildren, xOffsets, xSpans, ltr);
                SizeRequirements.calculateAlignedPositions(alloc.height, this.yTotal, this.yChildren, yOffsets, ySpans);
            } else {
                SizeRequirements.calculateAlignedPositions(alloc.width, this.xTotal, this.xChildren, xOffsets, xSpans, ltr);
                SizeRequirements.calculateTiledPositions(alloc.height, this.yTotal, this.yChildren, yOffsets, ySpans);
            }
        }
        Rectangle bounds = new Rectangle(this.toolbar.getSize());
        boolean hasInvisible = false;
        for (int i = 0; i < nChildren; ++i) {
            Component c = this.toolbar.getComponent(i);
            if (c == this.getMoreButton()) continue;
            c.setBounds((int)Math.min((long)in.left + (long)xOffsets[i], Integer.MAX_VALUE), (int)Math.min((long)in.top + (long)yOffsets[i], Integer.MAX_VALUE), xSpans[i], ySpans[i]);
            if (!c.isVisible() || bounds.contains(c.getBounds())) continue;
            c.setSize(0, 0);
            hasInvisible = true;
        }
        if (this.getMoreButton() != null) {
            Dimension d = this.getMoreButton().getPreferredSize();
            if (hasInvisible || this.isMoreAlwaysVisible()) {
                if (absoluteAxis == 0) {
                    this.getMoreButton().setBounds(Math.max(in.left, in.left + alloc.width - d.width), in.top, d.width, alloc.height);
                } else {
                    this.getMoreButton().setBounds(in.left, Math.max(in.top, in.top + alloc.height - d.height), alloc.width, d.height);
                }
                Rectangle rect = this.getMoreButton().getBounds();
                Rectangle compRect = new Rectangle();
                for (int i = 0; i < nChildren; ++i) {
                    Component c = this.toolbar.getComponent(i);
                    if (c == this.getMoreButton() || !rect.intersects(c.getBounds(compRect)) || !c.isVisible()) continue;
                    c.setSize(0, 0);
                }
            } else {
                this.getMoreButton().setSize(0, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container target) {
        Dimension size;
        ToolBarBoxLayout toolBarBoxLayout = this;
        synchronized (toolBarBoxLayout) {
            this.checkRequests();
            size = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension size;
        ToolBarBoxLayout toolBarBoxLayout = this;
        synchronized (toolBarBoxLayout) {
            this.checkRequests();
            size = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        }
        Insets insets = this.toolbar.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension size;
        ToolBarBoxLayout toolBarBoxLayout = this;
        synchronized (toolBarBoxLayout) {
            this.checkRequests();
            size = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        }
        Insets insets = this.toolbar.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.invalidateLayout(comp.getParent());
    }

    private void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            int n = this.toolbar.getComponentCount();
            this.xChildren = new SizeRequirements[n];
            this.yChildren = new SizeRequirements[n];
            for (int i = 0; i < n; ++i) {
                Component c = this.toolbar.getComponent(i);
                if (!c.isVisible() || c == this.getMoreButton() && !this.isMoreAlwaysVisible()) {
                    this.xChildren[i] = new SizeRequirements(0, 0, 0, c.getAlignmentX());
                    this.yChildren[i] = new SizeRequirements(0, 0, 0, c.getAlignmentY());
                    continue;
                }
                Dimension min = c.getMinimumSize();
                Dimension typ = c.getPreferredSize();
                Dimension max = c.getMaximumSize();
                this.xChildren[i] = new SizeRequirements(min.width, typ.width, max.width, c.getAlignmentX());
                this.yChildren[i] = new SizeRequirements(min.height, typ.height, max.height, c.getAlignmentY());
            }
            int absoluteAxis = this.axis;
            if (absoluteAxis == 0) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(this.yChildren);
            }
        }
    }

    public void setMoreButton(JComponent moreButton) {
        this.moreButton = moreButton;
    }

    public JComponent getMoreButton() {
        return this.moreButton;
    }

    public boolean isMoreAlwaysVisible() {
        return this.moreAlwaysVisible;
    }

    public void setMoreAlwaysVisible(boolean moreAlwaysVisible) {
        this.moreAlwaysVisible = moreAlwaysVisible;
        this.invalidateLayout(this.toolbar);
    }
}

