/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.HashMap;

public class AttachmentConverter {
    private ArrayList<MolAtom> atomListForMultipleAttachment = new ArrayList();
    private ArrayList<MolAtom> atomListForSimpleAttachment = new ArrayList();
    private HashMap<MolAtom, Integer> attachmentValues = new HashMap();
    private HashMap<MolAtom, ArrayList<Integer>> attachmentOrderList;

    public AttachmentConverter(Molecule mol) {
        this.convertAPOInformation(mol, this.atomListForSimpleAttachment, this.attachmentValues);
        this.attachmentOrderList = new HashMap();
        ArrayList<MolAtom> attachmentPoints = this.calculateAPOInformation(mol, this.atomListForMultipleAttachment, this.attachmentOrderList);
        this.removeMultipleAttachmentPoints(mol, attachmentPoints);
    }

    public ArrayList<MolAtom> getAtomListForMultipleAttachment() {
        return this.atomListForMultipleAttachment;
    }

    public ArrayList<MolAtom> getAtomListForSimpleAttachment() {
        return this.atomListForSimpleAttachment;
    }

    public int getOrderValue(MolAtom atom) {
        return this.attachmentValues.get(atom);
    }

    public ArrayList<Integer> getOrderValues(MolAtom atom) {
        return this.attachmentOrderList.get(atom);
    }

    private ArrayList<MolAtom> convertAPOInformation(Molecule mol, ArrayList<MolAtom> atomList, HashMap<MolAtom, Integer> attachmentValues) {
        MolAtom[] atoms;
        ArrayList<MolAtom> attachmentPoints = new ArrayList<MolAtom>();
        for (MolAtom atom : atoms = mol.getAtomArray()) {
            ArrayList<MolAtom> ligands = new ArrayList<MolAtom>();
            int value = AttachmentConverter.getRgroupAttachmentPoint(atom, ligands);
            if (value > 0) {
                attachmentValues.put(atom, value);
                atomList.add(atom);
            }
            attachmentPoints.addAll(ligands);
        }
        return attachmentPoints;
    }

    private void removeMultipleAttachmentPoints(Molecule mol, ArrayList<MolAtom> atoms) {
        for (MolAtom atom : atoms) {
            mol.removeAtom(atom);
        }
    }

    private ArrayList<MolAtom> calculateAPOInformation(Molecule mol, ArrayList<MolAtom> atomList, HashMap<MolAtom, ArrayList<Integer>> attachmentValues) {
        MolAtom[] atoms;
        ArrayList<MolAtom> attachmentPoints = new ArrayList<MolAtom>();
        for (MolAtom atom : atoms = mol.getAtomArray()) {
            ArrayList<MolAtom> ligands = new ArrayList<MolAtom>();
            ArrayList<Object> orders = new ArrayList();
            orders = this.calculateRgroupAttachmentPoint(atom, ligands);
            if (orders.size() <= 0) continue;
            attachmentValues.put(atom, orders);
            atomList.add(atom);
            attachmentPoints.addAll(ligands);
        }
        return attachmentPoints;
    }

    public static int getRgroupAttachmentPoint(MolAtom atom, ArrayList<MolAtom> apos) {
        boolean firstAPO = false;
        boolean secondAPO = false;
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getLigand(i).getAtno() == 138 && apos != null) {
                apos.add(atom.getLigand(i));
            }
            if (atom.getLigand(i).getRgroupAttachmentPointOrder() == 1) {
                firstAPO = true;
            }
            if (atom.getLigand(i).getRgroupAttachmentPointOrder() != 2) continue;
            secondAPO = true;
        }
        if (firstAPO && secondAPO) {
            return 3;
        }
        if (firstAPO) {
            return 1;
        }
        if (secondAPO) {
            return 2;
        }
        return 0;
    }

    private ArrayList<Integer> calculateRgroupAttachmentPoint(MolAtom atom, ArrayList<MolAtom> apos) {
        ArrayList<Integer> orders = new ArrayList<Integer>();
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getLigand(i).getAtno() != 138 || apos == null) continue;
            apos.add(atom.getLigand(i));
            orders.add(atom.getLigand(i).getRgroupAttachmentPointOrder());
        }
        return orders;
    }
}

