/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.core.util.BondTable;
import chemaxon.core.util.GeomUtil;
import chemaxon.marvin.paint.internal.util.DrawingUtil;
import chemaxon.marvin.sketch.GroupUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.HybridizationStateConsts;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.util.BitSet;

public class CleanUtil
implements HybridizationStateConsts {
    private static final int CISTRANS = 192;
    private static final int CTUMASK = 448;
    private static final int PARITY_EITHER = 3;
    private static final int STEREO1_MASK = 48;

    public static boolean arrangeComponents(MoleculeGraph mol) {
        return GeomUtil.arrangeComponents(mol);
    }

    public static boolean arrangeComponents(MoleculeGraph mol, boolean obj) {
        return GeomUtil.arrangeComponents(mol, obj);
    }

    public static boolean arrangeComponents(MoleculeGraph mol, boolean obj, boolean frags) {
        return GeomUtil.arrangeComponents(mol, obj, frags);
    }

    public static void arrangeReaction(RxnMolecule m) {
        GeomUtil.arrangeReaction(m);
    }

    public static void arrangeMolecules(MoleculeGraph[] mo, int dist, int col) {
        GeomUtil.arrangeMolecules(mo, dist, col);
    }

    public static void arrangeDataSgroupData(MoleculeGraph m) {
        GeomUtil.arrangeDataSgroupData(m);
    }

    public static void arrangeSgBrackets(MoleculeGraph m) {
        GeomUtil.arrangeSgBrackets(m);
    }

    public static double sumDistanceSquare(MoleculeGraph mol, DPoint3 p) {
        MoleculeGraph umol = mol.getGraphUnion();
        double sum = 0.0;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom a = mol.getAtom(i);
            double dx = a.getX() - p.x;
            double dy = a.getY() - p.y;
            double dz = a.getZ() - p.z;
            sum += dx * dx + dy * dy + dz * dz;
        }
        return sum;
    }

    public static double calcBadness(MoleculeGraph mol1, MoleculeGraph mol2, MolAtom sa, MolBond[] xbonds) {
        return GeomUtil.calcBadness(mol1, mol2, sa, xbonds);
    }

    public static double[] createSavedCoordsArray(MoleculeGraph g) {
        return GeomUtil.createSavedCoordsArray(g);
    }

    public static void saveCoords(MoleculeGraph g, double[] coords) {
        GeomUtil.saveCoords(g, coords);
    }

    public static void restoreCoords(MoleculeGraph g, double[] coords) {
        GeomUtil.restoreCoords(g, coords);
    }

    public static CTransform3D createRotationAboutBond(MolBond b, double phi) {
        DPoint3 p1 = b.getAtom1().getLocation();
        DPoint3 p2 = b.getAtom2().getLocation();
        DPoint3 p0 = new DPoint3((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0, (p1.z + p2.z) / 2.0);
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double dz = p2.z - p1.z;
        double r12 = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double ex = dx / r12;
        double ey = dy / r12;
        double ez = dz / r12;
        CTransform3D t = new CTransform3D();
        t.setRotation(ex, ey, ez, phi);
        t.setRotationCenter(p0);
        CleanUtil.setSmallToZero(t, 1.0E-12);
        return t;
    }

    private static void setSmallToZero(CTransform3D t, double epsilon) {
        t.m00 = CleanUtil.setSmallToZero(t.m00, epsilon);
        t.m01 = CleanUtil.setSmallToZero(t.m01, epsilon);
        t.m02 = CleanUtil.setSmallToZero(t.m02, epsilon);
        t.m03 = CleanUtil.setSmallToZero(t.m03, epsilon);
        t.m10 = CleanUtil.setSmallToZero(t.m10, epsilon);
        t.m11 = CleanUtil.setSmallToZero(t.m11, epsilon);
        t.m12 = CleanUtil.setSmallToZero(t.m12, epsilon);
        t.m13 = CleanUtil.setSmallToZero(t.m13, epsilon);
        t.m20 = CleanUtil.setSmallToZero(t.m20, epsilon);
        t.m21 = CleanUtil.setSmallToZero(t.m21, epsilon);
        t.m22 = CleanUtil.setSmallToZero(t.m22, epsilon);
        t.m23 = CleanUtil.setSmallToZero(t.m23, epsilon);
        t.m30 = CleanUtil.setSmallToZero(t.m30, epsilon);
        t.m31 = CleanUtil.setSmallToZero(t.m31, epsilon);
        t.m32 = CleanUtil.setSmallToZero(t.m32, epsilon);
        t.m33 = CleanUtil.setSmallToZero(t.m33, epsilon);
    }

    private static double setSmallToZero(double x, double epsilon) {
        return Math.abs(x) > epsilon ? x : 0.0;
    }

    public static boolean setCTWigglyBond(MoleculeGraph m) {
        boolean success = true;
        int bc = m.getBondCount();
        int[][] ctab = m.getCtab();
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            int stereo = b.getFlags() & 0x1C0;
            if (stereo != 192) continue;
            if (CleanUtil.setCTWigglyBond(m, m.indexOf(b.getAtom1()), m.indexOf(b.getAtom2()), ctab)) {
                b.setFlags(0, 448);
                continue;
            }
            success = false;
        }
        return success;
    }

    public static boolean setCTWigglyBond(MoleculeGraph m, int bond) {
        MolBond b = m.getBond(bond);
        if (b.getType() != 2) {
            return false;
        }
        boolean result = true;
        int stereo = b.getFlags() & 0x1C0;
        if (stereo == 192) {
            if (CleanUtil.setCTWigglyBond(m, m.indexOf(b.getAtom1()), m.indexOf(b.getAtom2()), m.getCtab())) {
                b.setFlags(0, 448);
            } else {
                result = false;
            }
        }
        return result;
    }

    static boolean setCTWigglyBond(MoleculeGraph m, int i1, int i2, int[][] ct) {
        MolBond b2;
        int p;
        MolBond b1;
        int i;
        int ll;
        MolAtom a1 = m.getAtom(i1);
        MolAtom a2 = m.getAtom(i2);
        int[] sssrSize = m.getSmallestRingSizeForIdx();
        if (CleanUtil.hasWiggly(a1) || CleanUtil.hasWiggly(a2)) {
            return true;
        }
        if (sssrSize[i1] > 0 && sssrSize[i2] > 0 && sssrSize[i1] < 8 && sssrSize[i2] < 8 && !CleanUtil.isSameSSSR(i1, i2, m)) {
            return true;
        }
        MolBond b = null;
        if (ct[i1].length == 2 && ct[i2].length != 2) {
            ll = ct[i1].length;
            for (i = 0; i < ll; ++i) {
                b1 = a1.getBond(i);
                p = m.getLocalParity(ct[i1][i]);
                if (b1.getType() != 1 || p != 0 && p != 3 || (b1.getFlags() & 0x30) == 48) continue;
                b = b1;
                break;
            }
        } else if (ct[i2].length == 2 && ct[i1].length != 2) {
            ll = ct[i2].length;
            for (i = 0; i < ll; ++i) {
                b1 = a2.getBond(i);
                p = m.getLocalParity(ct[i2][i]);
                if (b1.getType() != 1 || p != 0 && p != 3 || (b1.getFlags() & 0x30) == 48) continue;
                b = b1;
                break;
            }
        }
        if (b != null) {
            b.setFlags(48, 48);
            if (b.getAtom1() != a1 && b.getAtom1() != a2) {
                b.swap();
            }
            return true;
        }
        ll = ct[i1].length;
        for (i = 0; i < ll; ++i) {
            b1 = a1.getBond(i);
            if (b1.getType() != 1 || ct[ct[i1][i]].length != 1) continue;
            b = b1;
            break;
        }
        if (b != null) {
            b.setFlags(48, 48);
            if (b.getAtom1() != a1) {
                b.swap();
            }
            return true;
        }
        ll = ct[i2].length;
        for (i = 0; i < ll; ++i) {
            b2 = a2.getBond(i);
            if (b2.getType() != 1 || ct[ct[i2][i]].length != 1) continue;
            b = b2;
            break;
        }
        if (b != null) {
            b.setFlags(48, 48);
            if (b.getAtom1() != a2) {
                b.swap();
            }
            return true;
        }
        ll = ct[i1].length;
        for (i = 0; i < ll; ++i) {
            b1 = a1.getBond(i);
            p = m.getLocalParity(ct[i1][i]);
            if (b1.getType() != 1 || p != 0 && p != 3 || (b1.getFlags() & 0x30) == 48) continue;
            b = b1;
            break;
        }
        if (b != null) {
            b.setFlags(48, 48);
            if (b.getAtom1() != a1) {
                b.swap();
            }
            return true;
        }
        ll = ct[i2].length;
        for (i = 0; i < ll; ++i) {
            b2 = a2.getBond(i);
            p = m.getLocalParity(ct[i2][i]);
            if (b2.getType() != 1 || p != 0 && p != 3 || (b2.getFlags() & 0x30) == 48) continue;
            b = b2;
            break;
        }
        if (b != null) {
            b.setFlags(48, 48);
            if (b.getAtom1() != a2) {
                b.swap();
            }
            return true;
        }
        return false;
    }

    static boolean isSameSSSR(int i1, int i2, MoleculeGraph m) {
        int[][] atomInRing = m.getSSSRIdxesForAtoms();
        int l = m.getSSSR().length;
        BitSet s1 = new BitSet(l);
        int[] rs1 = atomInRing[i1];
        for (int i = rs1.length - 1; i >= 0; --i) {
            s1.set(rs1[i]);
        }
        BitSet s2 = new BitSet(l);
        int[] rs2 = atomInRing[i2];
        for (int i = rs2.length - 1; i >= 0; --i) {
            s2.set(rs2[i]);
        }
        s1.and(s2);
        return s1.cardinality() == 0;
    }

    public static boolean hasWiggly(MolAtom a) {
        int bondCount = a.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            MolBond b = a.getBond(i);
            MolAtom a1 = b.getAtom1();
            if (a1 != a || (b.getFlags() & 0x30) != 48) continue;
            return true;
        }
        return false;
    }

    public static void setCTCrossedBond(MoleculeGraph m) {
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            if (b.getType() != 2) continue;
            boolean removed = false;
            MolAtom a1 = b.getAtom1();
            int bondCount = a1.getBondCount();
            for (int j = 0; j < bondCount; ++j) {
                MolBond lb = a1.getBond(j);
                if (lb.getAtom1() != a1 || (lb.getFlags() & 0x30) != 48) continue;
                lb.setFlags(0, 48);
                removed = true;
            }
            MolAtom a2 = b.getAtom2();
            bondCount = a2.getBondCount();
            for (int j = 0; j < bondCount; ++j) {
                MolBond lb = a2.getBond(j);
                if (lb.getAtom1() != a2 || (lb.getFlags() & 0x30) != 48) continue;
                lb.setFlags(0, 48);
                removed = true;
            }
            if (!removed) continue;
            b.setFlags(192, 448);
        }
    }

    public static boolean[] isNonPreferredStereoAtom(MoleculeGraph m) {
        int ac = m.getAtomCount();
        boolean[] s = new boolean[ac];
        m.calcHybridization();
        for (int x = 0; x < ac; ++x) {
            int hs = m.getAtom(x).getHybridizationState();
            if (hs != 3 && hs != 2 && hs != 1) continue;
            MolAtom a = m.getAtom(x);
            for (int i = a.getBondCount() - 1; i >= 0; --i) {
                MolBond b = a.getBond(i);
                int flag = b.getFlags() & 0x30;
                if (flag == 0 || b.getAtom1() != a || flag == 48 && CleanUtil.hasDoubleNeighbour(a)) continue;
                s[x] = true;
            }
        }
        return s;
    }

    private static boolean hasDoubleNeighbour(MolAtom a) {
        for (int i = a.getBondCount() - 1; i >= 0; --i) {
            if (a.getBond(i).getType() != 2) continue;
            return true;
        }
        return false;
    }

    public static boolean removeCTflagFromSmallRings(MoleculeGraph m) {
        int[][] cssr = m.getCSSR();
        BondTable btab = m.getBondTable();
        boolean ret = true;
        for (int i = 0; i < cssr.length; ++i) {
            int[] r = cssr[i];
            int l = r.length;
            if (l >= 8) continue;
            for (int j = 0; j < l; ++j) {
                MolAtom a4;
                MolAtom a1;
                int st;
                int i1 = r[j];
                int i2 = r[(j + 1) % l];
                int i3 = r[(j + 2) % l];
                int i4 = r[(j + 3) % l];
                MolBond b = m.getBond(btab.getBondIndex(i2, i3));
                if (b.getType() != 2) continue;
                int s = b.getFlags() & 0x1C0;
                if (s == 192) {
                    b.setFlags(0, 192);
                    continue;
                }
                if (s != 128 && s != 64 || (st = b.transformCT(a1 = m.getAtom(i1), a4 = m.getAtom(i4), s)) != 64) continue;
                b.setFlags(s ^ 0xC0, 448);
                ret = false;
            }
        }
        return ret;
    }

    public static DPoint3 calcDividingPoint(DPoint3 p1, DPoint3 p2, double k) {
        DPoint3 p = new DPoint3();
        p.x = (p1.x + k * p2.x) / (1.0 + k);
        p.y = (p1.y + k * p2.y) / (1.0 + k);
        p.z = (p1.z + k * p2.z) / (1.0 + k);
        return p;
    }

    public static DPoint3[] calcSimplePolymerBracket(DPoint3 p1, DPoint3 p2, double ratio) {
        DPoint3[] q = new DPoint3[4];
        double r = p1.distance(p2);
        double c = 0.9239999999999999;
        double ex = (p1.x - p2.x) / r;
        double ey = (p1.y - p2.y) / r;
        DPoint3 pd = CleanUtil.calcDividingPoint(p1, p2, ratio);
        double fx = -ey;
        double fy = ex;
        double dx = fx * c;
        double dy = fy * c;
        double x1 = pd.x - dx;
        double y1 = pd.y - dy;
        double x2 = pd.x + dx;
        double y2 = pd.y + dy;
        q[0] = new DPoint3(x1, y1, pd.z);
        q[1] = new DPoint3(x2, y2, pd.z);
        DPoint3[] qs = CleanUtil.calcBracketEndPoints(q, p1, 0.385);
        q[2] = qs[0];
        q[3] = qs[1];
        return q;
    }

    public static DPoint3[] calcBracketEndPoints(DPoint3[] q, DPoint3 p1, double c) {
        DPoint3[] qs = new DPoint3[2];
        double d = q[0].distance(q[1]);
        double d1 = q[0].distance(p1);
        double d2 = q[1].distance(p1);
        double d3 = (d1 * d1 - d2 * d2 + d * d) / (2.0 * d);
        double k = d3 / (d - d3);
        DPoint3 pk = new DPoint3((q[0].x + k * q[1].x) / (1.0 + k), (q[0].y + k * q[1].y) / (1.0 + k), (q[0].z + k * q[1].z) / (1.0 + k));
        double r = p1.distance(pk);
        double ex = (p1.x - pk.x) / r;
        double ey = (p1.y - pk.y) / r;
        double ez = (p1.z - pk.z) / r;
        qs[0] = new DPoint3(q[0].x + ex * c, q[0].y + ey * c, q[0].z + ez * c);
        qs[1] = new DPoint3(q[1].x + ex * c, q[1].y + ey * c, q[1].z + ez * c);
        return qs;
    }

    public static void generateBracketCoords(Sgroup sg, int btype) {
        CleanUtil.generateBracketCoords(sg, btype, false);
    }

    public static void generateBracketCoords(Sgroup sg, int btype, boolean extraSpace) {
        if (sg instanceof RepeatingUnitSgroup && sg.findCrossingBonds().length != 0) {
            CleanUtil.generateSRUBracketCoords((RepeatingUnitSgroup)sg, btype, extraSpace);
        } else {
            CleanUtil.generateSimpleBracketCoords(sg, btype, extraSpace);
        }
    }

    private static void generateSRUBracketCoords(RepeatingUnitSgroup sg, int btype, boolean extraSpace) {
        MolBond[] crossingBonds = sg.findCrossingBonds();
        if (crossingBonds.length == 0 || crossingBonds.length == 1 || sg.getHeadCrossingBonds() != null && sg.getTailCrossingBonds() != null) {
            CleanUtil.generateSimpleBracketCoords(sg, btype, extraSpace);
        } else {
            sg.initBrackets();
            for (int j = crossingBonds.length - 1; j >= 0; --j) {
                MolBond b1 = crossingBonds[j];
                MolAtom a1 = sg.indexOf(b1.getAtom1()) >= 0 ? b1.getAtom1() : b1.getAtom2();
                MolAtom a2 = b1.getOtherAtom(a1);
                double ratio = 0.7;
                Sgroup parent = sg.getParentSgroup();
                if (sg.getType() == 2 && parent != null && parent.getType() == 5 && parent.findCrossingBonds().length > 0) {
                    ratio = 0.1;
                }
                if (sg.getType() == 5) {
                    ratio = 0.9;
                }
                DPoint3[] q = CleanUtil.calcSimplePolymerBracket(a1.getLocation(), a2.getLocation(), ratio);
                CleanUtil.createBracket(sg, q, btype);
            }
        }
    }

    public static void createBracket(Sgroup sg, DPoint3[] q, int btype) {
        MPoint[] points = new MPoint[]{new MPoint(q[0]), new MPoint(q[2]), new MPoint(q[3]), new MPoint(q[1])};
        MBracket bracket = new MBracket();
        bracket.setPoints(points);
        bracket.setBracketOrientation(4);
        bracket.setType(btype);
        sg.addBracket(bracket);
    }

    private static void generateSimpleBracketCoords(Sgroup sg, int btype, boolean extraSpace) {
        if (!sg.hasBrackets() || sg.getType() == 0 || sg.getType() == 10) {
            return;
        }
        double d = 0.77 * (double)GeomUtil.getDeepness(sg);
        if (extraSpace) {
            d += 0.25666666666666665;
        }
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        for (int i = 0; i < sg.getAtomCount(); ++i) {
            double y;
            double x = sg.getAtom(i).getX();
            if (x > xmax) {
                xmax = x;
            }
            if (x < xmin) {
                xmin = x;
            }
            if ((y = sg.getAtom(i).getY()) > ymax) {
                ymax = y;
            }
            if (!(y < ymin)) continue;
            ymin = y;
        }
        sg.initBrackets();
        MBracket bracket = new MBracket(new MPoint(xmin - d, ymax + d), new MPoint(xmax + d, ymin - d));
        bracket.setType(btype);
        sg.addBracket(bracket);
    }

    public static void setBestLigandPosition(MolAtom atom, MolAtom ligand) {
        CleanUtil.setBestLigandPosition(atom, ligand, -1.0);
    }

    public static void setBestLigandPosition(MolAtom atom, MolAtom ligand, double bondlength) {
        if (atom.getBondCount() == 2) {
            MolAtom atom1 = CleanUtil.getRotatableAtom(atom, ligand);
            double phi = atom.getBond(0).getType() == 3 ? Math.PI : 2.0943951023931953;
            DPoint3 p = CleanUtil.setBondLength(atom, ligand, bondlength, atom1);
            float[] f = GroupUtil.getNextDirection(atom.getLocation(), p, 1, -1, phi);
            ligand.setXYZ(f[0], f[1], 0.0);
        } else {
            int[][] bi = DrawingUtil.bondIndices1(atom);
            double[] angles = GeomUtil.bondAngles(atom, bi[1]);
            double[] diffs = GeomUtil.calcAngleDiffs(angles, bi[1], bi[0].length > 0 ? bi[0] : null);
            DrawingUtil.sortDiffs(diffs, angles, bi[1], bi[0].length > 0 ? bi[0] : null);
            int desBondIndex = bi[1].length - 1;
            double phi = CleanUtil.calcNextAngle(angles, diffs, desBondIndex);
            double l = bondlength == -1.0 ? MolBond.desiredLength(atom.getAtno(), ligand.getAtno(), 1, 2) : bondlength;
            ligand.setXYZ(atom.getX() + l * Math.cos(phi), atom.getY() + l * Math.sin(phi), atom.getZ());
        }
    }

    private static DPoint3 setBondLength(MolAtom atom, MolAtom ligand, double bondlength, MolAtom atom1) {
        double d = atom.getLocation().distance(atom1.getLocation());
        double l = bondlength == -1.0 ? MolBond.desiredLength(atom.getAtno(), ligand.getAtno(), 1, 2) : bondlength;
        DPoint3 l0 = atom.getLocation();
        DPoint3 l1 = atom1.getLocation();
        double ratio = l / d;
        DPoint3 p = new DPoint3(l0.x + ratio * (l1.x - l0.x), l0.y + ratio * (l1.y - l0.y), l0.z + ratio * (l1.z - l0.z));
        return p;
    }

    private static MolAtom getRotatableAtom(MolAtom atom, MolAtom ligand) {
        MolAtom other1 = atom.getBond(1).getOtherAtom(atom);
        MolAtom other0 = atom.getBond(0).getOtherAtom(atom);
        return ligand == other1 ? other0 : other1;
    }

    private static double calcNextAngle(double[] angles, double[] diffs, int desBondIndex) {
        double phi;
        switch (desBondIndex) {
            case -1: {
                phi = Math.PI;
                break;
            }
            case 0: {
                phi = 1.0471975511965976;
                break;
            }
            default: {
                phi = diffs[desBondIndex] / 2.0 + angles[desBondIndex];
            }
        }
        return phi;
    }
}

