/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.marvin.util.DistantColorCreator;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class ColorGenerator {
    public static final List<Color> generateColors(int count, Collection<Color> forbiddenColors) {
        DistantColorCreator generator = new DistantColorCreator();
        return generator.generateColors(count, forbiddenColors);
    }

    public static final List<Color> generateColors(int count) {
        return ColorGenerator.generateColors(count, null);
    }

    public static final Collection<Color> gatherBaseColors() {
        HashSet<Color> baseColors = new HashSet<Color>();
        baseColors.add(Color.BLACK);
        baseColors.add(Color.WHITE);
        baseColors.add(Color.RED);
        baseColors.add(Color.GREEN);
        baseColors.add(Color.BLUE);
        baseColors.add(Color.CYAN);
        baseColors.add(Color.MAGENTA);
        baseColors.add(Color.YELLOW);
        return baseColors;
    }

    public static final Collection<Color> gatherBaseMoleculeColors(boolean onLightBackground) {
        HashSet<Color> baseColors = new HashSet<Color>();
        if (onLightBackground) {
            baseColors.add(new Color(51, 51, 51));
            baseColors.add(new Color(51, 51, 153));
            baseColors.add(Color.RED);
            baseColors.add(new Color(153, 102, 0));
            baseColors.add(new Color(102, 102, 0));
            baseColors.add(new Color(0, 153, 0));
            baseColors.add(new Color(102, 51, 51));
            baseColors.add(new Color(102, 0, 153));
            baseColors.add(Color.WHITE);
            baseColors.add(Color.BLACK);
        } else {
            baseColors.add(Color.WHITE);
            baseColors.add(Color.BLACK);
            baseColors.add(new Color(204, 204, 204));
            baseColors.add(new Color(153, 153, 255));
            baseColors.add(Color.RED);
            baseColors.add(new Color(255, 153, 51));
            baseColors.add(new Color(255, 170, 0));
            baseColors.add(new Color(255, 204, 51));
            baseColors.add(Color.GREEN);
            baseColors.add(new Color(153, 51, 51));
            baseColors.add(new Color(204, 51, 255));
        }
        return baseColors;
    }

    public static final Collection<Color> gatherBaseColorsAndBaseMoleculeColors(boolean onLightBackground) {
        Collection<Color> colors = ColorGenerator.gatherBaseColors();
        colors.addAll(ColorGenerator.gatherBaseMoleculeColors(onLightBackground));
        return colors;
    }

    public static final Collection<Color> gatherBlackAndWhite() {
        HashSet<Color> colors = new HashSet<Color>();
        colors.add(Color.BLACK);
        colors.add(Color.WHITE);
        return colors;
    }
}

