/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

public class ColorPaletteUtil {
    public static final int COLOR_MAPPER_RED_TO_BLUE = 0;
    public static final int COLOR_MAPPER_BLUE_TO_RED = 1;
    public static final int COLOR_MAPPER_RAINBOW = 2;
    public static final int COLOR_MAPPER_REVERSE_RAINBOW = 3;
    public static final int COLOR_MAPPER_BLUE_TO_GREEN = 4;
    public static final int COLOR_MAPPER_GREEN_TO_BLUE = 5;
    public static final int COLOR_MAPPER_FIRE = 6;
    public static final int COLOR_MAPPER_BLUE = 7;
    public static final int COLOR_MAPPER_GREEN = 8;
    public static final int COLOR_MAPPER_YELLOW = 9;
    public static final byte[] white = new byte[]{127, 127, 127};
    public static final byte[] black = new byte[]{0, 0, 0};
    public static final byte[] blue = new byte[]{0, 0, 127};
    public static final byte[] green = new byte[]{0, 127, 0};
    public static final byte[] red = new byte[]{127, 0, 0};
    public static final byte[] yellow = new byte[]{127, 127, 0};
    public static final byte[] cyan = new byte[]{0, 109, 109};
    public static final byte[] lightgray = new byte[]{89, 89, 89};
    private static final byte[][] rainbow = new byte[][]{blue, cyan, green, yellow, red};
    private static final byte[][] reverserainbow = new byte[][]{red, yellow, green, cyan, blue};
    private static final byte[][] red2blue = new byte[][]{red, lightgray, blue};
    private static final byte[][] blue2red = new byte[][]{blue, lightgray, red};
    private static final byte[][] green2blue = new byte[][]{green, cyan, blue};
    private static final byte[][] blue2green = new byte[][]{blue, cyan, green};
    private static final byte[][] fire = new byte[][]{white, {127, 127, 63}, {127, 63, 0}, {63, 0, 0}, black};
    private static final byte[][] bluePal = new byte[][]{lightgray, blue};
    private static final byte[][] greenPal = new byte[][]{lightgray, green};
    private static final byte[][] yellowPal = new byte[][]{lightgray, yellow};
    protected static final String[] paletteStrings = new String[]{"Red to Blue", "Blue to Red", "Rainbow", "Reverse Rainbow", "Blue to Green", "Green to Blue", "Fire", "Blue", "Green", "Yellow"};
    private static final byte[][][] palettes = new byte[][][]{red2blue, blue2red, rainbow, reverserainbow, blue2green, green2blue, fire, bluePal, greenPal, yellowPal};

    public static String[] getBuiltInPalettes() {
        return paletteStrings;
    }

    public static byte[][] getBuiltInPalette(int paletteId) {
        return palettes[paletteId];
    }

    public static String getBuiltInPaletteString(int paletteId) {
        return paletteStrings[paletteId];
    }

    public static byte[][] getBuiltInPalette(Object paletteId) {
        int i = ColorPaletteUtil.getBuiltInPaletteId(paletteId);
        return i != -1 ? palettes[i] : (byte[][])null;
    }

    public static int getBuiltInPaletteId(Object paletteId) {
        for (int i = 0; i < paletteStrings.length; ++i) {
            if (!paletteStrings[i].equals(paletteId)) continue;
            return i;
        }
        return -1;
    }
}

