/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;

public class ColorSetUtil {
    public static void mergeSets(MDocument doc1, MDocument doc2) {
        ColorSetUtil.mergeAtomSets(doc1, doc2);
        ColorSetUtil.mergeBondSets(doc1, doc2);
    }

    private static void mergeBondSets(MDocument doc1, MDocument doc2) {
        int seq;
        int j;
        MoleculeGraph m = doc1.getMainMoleculeGraph();
        MoleculeGraph mg = doc2.getMainMoleculeGraph();
        int[] setRefs = new int[64];
        for (int i = 0; i < setRefs.length; ++i) {
            setRefs[i] = -1;
        }
        boolean[] usedSet = new boolean[64];
        int usedSetIndex = 0;
        for (j = 0; j < mg.getBondCount(); ++j) {
            seq = mg.getBond(j).getSetSeq();
            if (seq < 0) continue;
            usedSet[seq] = true;
        }
        usedSet[0] = true;
        for (j = 0; j < m.getBondCount(); ++j) {
            seq = m.getBond(j).getSetSeq();
            if (seq <= 0) continue;
            if (setRefs[seq] == -1) {
                for (int k = 0; k < doc2.getBondSetSize() && setRefs[seq] == -1; ++k) {
                    if (doc2.getBondSetRGB(k) != doc1.getBondSetRGB(seq) || doc2.getBondSetThickness(k) != doc1.getBondSetThickness(seq)) continue;
                    setRefs[seq] = k;
                    m.getBond(j).setSetSeq(k);
                }
                if (setRefs[seq] != -1) continue;
                int newIndex = -1;
                for (int l = usedSetIndex; l <= 63 && newIndex < 0; ++l) {
                    newIndex = usedSet[l] ? -1 : l;
                }
                if (newIndex <= 0 || newIndex > 63) continue;
                usedSet[newIndex] = true;
                if (doc1.getBondSetSize() == 0) {
                    doc2.setBondSetColorMode(newIndex, 2);
                } else {
                    doc2.setBondSetColorMode(newIndex, doc1.getBondSetColorMode(seq));
                }
                doc2.setBondSetColorMode(newIndex, doc1.getBondSetColorMode(seq));
                if (doc1.getBondSetColorMode(seq) == 1) {
                    doc2.setBondSetRGB(newIndex, doc1.getBondSetRGB(seq));
                }
                doc2.setBondSetThickness(newIndex, doc1.getBondSetThickness(seq));
                m.getBond(j).setSetSeq(newIndex);
                usedSetIndex = newIndex;
                setRefs[seq] = newIndex;
                continue;
            }
            m.getBond(j).setSetSeq(setRefs[seq]);
        }
    }

    private static boolean isSameAtomSet(MDocument doc1, MDocument doc2, int seq1, int seq2) {
        boolean fontEquals = false;
        if (doc1.getAtomSetFont(seq1) == null) {
            if (doc2.getAtomSetFont(seq2) == null) {
                fontEquals = true;
            }
        } else {
            fontEquals = doc1.getAtomSetFont(seq1).equals(doc2.getAtomSetFont(seq2));
        }
        return doc1.getAtomSetRGB(seq1) == doc2.getAtomSetRGB(seq2) && fontEquals;
    }

    private static void mergeAtomSets(MDocument doc1, MDocument doc2) {
        int seq;
        int j;
        MoleculeGraph m = doc1.getMainMoleculeGraph();
        MoleculeGraph mg = doc2.getMainMoleculeGraph();
        if (!doc2.isAtomSetColorModeSet()) {
            return;
        }
        int[] setRefs = new int[64];
        for (int i = 0; i < setRefs.length; ++i) {
            setRefs[i] = -1;
        }
        boolean[] usedSet = new boolean[64];
        int usedSetIndex = 0;
        for (j = 0; j < mg.getAtomCount(); ++j) {
            seq = mg.getAtom(j).getSetSeq();
            if (seq < 0) continue;
            usedSet[seq] = true;
        }
        usedSet[0] = true;
        for (j = 0; j < m.getAtomCount(); ++j) {
            seq = m.getAtom(j).getSetSeq();
            if (seq <= 0) continue;
            if (setRefs[seq] == -1) {
                for (int k = 0; k < doc2.getAtomSetSize() && setRefs[seq] == -1; ++k) {
                    if (!ColorSetUtil.isSameAtomSet(doc2, doc1, k, seq)) continue;
                    setRefs[seq] = k;
                    m.getAtom(j).setSetSeq(setRefs[seq]);
                }
                if (setRefs[seq] != -1) continue;
                int newIndex = -1;
                for (int l = usedSetIndex; l <= 63 && newIndex < 0; ++l) {
                    newIndex = usedSet[l] ? -1 : l;
                }
                if (newIndex <= 0 || newIndex > 63) continue;
                usedSet[newIndex] = true;
                if (doc1.getAtomSetSize() == 0) {
                    doc2.setAtomSetColorMode(newIndex, 2);
                } else {
                    doc2.setAtomSetColorMode(newIndex, doc1.getAtomSetColorMode(seq));
                }
                if (doc1.getAtomSetColorMode(seq) == 1) {
                    doc2.setAtomSetRGB(newIndex, doc1.getAtomSetRGB(seq));
                }
                doc2.setAtomSetFont(newIndex, doc1.getAtomSetFont(seq));
                m.getAtom(j).setSetSeq(newIndex);
                usedSetIndex = newIndex;
                setRefs[seq] = newIndex;
                continue;
            }
            m.getAtom(j).setSetSeq(setRefs[seq]);
        }
    }

    public static void copySets(MDocument doc, MDocument source) {
        if (source != null) {
            int seq;
            int j;
            MoleculeGraph m = source.getMainMoleculeGraph();
            for (j = 0; j < m.getAtomCount(); ++j) {
                seq = m.getAtom(j).getSetSeq();
                if (seq < 0) continue;
                doc.setAtomSetColorMode(seq, source.getAtomSetColorMode(seq));
                if (source.getAtomSetColorMode(seq) == 1) {
                    doc.setAtomSetRGB(seq, source.getAtomSetRGB(seq));
                }
                doc.setAtomSetFont(seq, source.getAtomSetFont(seq));
            }
            for (j = 0; j < m.getBondCount(); ++j) {
                seq = m.getBond(j).getSetSeq();
                if (seq < 0) continue;
                doc.setBondSetColorMode(seq, source.getBondSetColorMode(seq));
                if (source.getBondSetColorMode(seq) == 1) {
                    doc.setBondSetRGB(seq, source.getBondSetRGB(seq));
                }
                doc.setBondSetThickness(seq, source.getBondSetThickness(seq));
            }
        }
    }

    public static void copyDefaultSetColor(MDocument document, Molecule piece) {
        if (piece == null) {
            return;
        }
        MDocument to = piece.getDocument();
        if (to == null) {
            to = new MDocument(piece);
        }
        if (document != null && document.isAtomSetColorModeSet()) {
            to.setAtomSetColorMode(0, document.getAtomSetColorMode(0));
            if (document.getAtomSetColorMode(0) == 1) {
                to.setAtomSetRGB(0, document.getAtomSetRGB(0));
            }
            to.setAtomSetFont(0, document.getAtomSetFont(0));
            to.setBondSetColorMode(0, document.getBondSetColorMode(0));
            if (document.getBondSetColorMode(0) == 1) {
                to.setBondSetRGB(0, document.getBondSetRGB(0));
            }
            to.setBondSetThickness(0, document.getBondSetThickness(0));
        }
    }
}

