/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.marvin.util.Environment;
import chemaxon.util.FindCodeBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ExternalFileLoader {
    private String filename = null;
    private String fileOutJar = null;

    public ExternalFileLoader(String filename) {
        this.filename = filename.startsWith("/") ? filename.substring(1) : filename;
        this.fileOutJar = this.findOutJar();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFileOutJar() {
        return this.fileOutJar;
    }

    public InputStream openFileOutJar() {
        InputStream is = null;
        if (this.fileOutJar == null) {
            return null;
        }
        if (FindCodeBase.isURL(this.fileOutJar)) {
            try {
                URL url = new URL(this.fileOutJar);
                return url.openStream();
            }
            catch (MalformedURLException muex) {
            }
            catch (IOException ioex) {}
        } else {
            try {
                return new FileInputStream(this.fileOutJar);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return is;
    }

    private String findOutJar() {
        block12: {
            String cbdir = FindCodeBase.getCodeBaseDir();
            if (Environment.isMarvinInJar()) {
                try {
                    if (!FindCodeBase.isURL(cbdir)) {
                        File fdir = new File(cbdir);
                        File f = new File(fdir, this.filename);
                        if (f.exists()) {
                            return f.getCanonicalPath();
                        }
                        f = new File(fdir = fdir.getParentFile(), this.filename);
                        if (f.exists()) {
                            return f.getCanonicalPath();
                        }
                        break block12;
                    }
                    URL cbdirUrl = new URL(cbdir);
                    URL url = new URL(cbdirUrl, this.filename);
                    return url.toString();
                }
                catch (MalformedURLException muex) {
                }
                catch (IOException ioex) {}
            } else if (!Environment.UNTRUSTED) {
                try {
                    File f;
                    File fdir = new File(cbdir);
                    if (fdir.exists() && (f = new File(fdir, this.filename)).exists()) {
                        return f.getCanonicalPath();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

