/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.InstallFromJar;
import chemaxon.util.DotfileUtil;
import chemaxon.util.FindCodeBase;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstalledComponent {
    private String name;
    private String className = null;
    private File installedDir = null;
    private static final Logger logger = Logger.getLogger(InstalledComponent.class.getName());

    public static InstalledComponent get(String name) {
        return new InstalledComponent(name);
    }

    public synchronized File getInstalledDir() throws IOException {
        if (this.installedDir == null) {
            this.install();
        }
        return this.installedDir;
    }

    private InstalledComponent(String name) {
        this.name = name;
    }

    private void install() throws IOException {
        URL codebase;
        File tmpDir;
        if (Environment.UNTRUSTED) {
            throw new SecurityException("Non secure context: " + this.name + " component cannot be installed locally");
        }
        File futureInstalledDir = DotfileUtil.getDotFile("lib/" + this.name);
        if (futureInstalledDir.exists()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, this.name + " is already installed in " + futureInstalledDir);
            }
            this.installedDir = futureInstalledDir;
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Starting installation of " + this.name + " into " + futureInstalledDir);
        }
        int i = 0;
        while ((tmpDir = DotfileUtil.getDotFile("lib/" + this.name + ".tmp" + i)).exists()) {
            ++i;
        }
        if (!tmpDir.mkdirs()) {
            throw new IOException("Cannot create " + tmpDir.getAbsolutePath());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Installing " + this.name + " into " + tmpDir + " first");
        }
        if ((codebase = Environment.getCodeBase()) != null) {
            this.appletInstall(tmpDir, codebase);
        } else {
            this.nonAppletInstall(tmpDir);
        }
        if (!tmpDir.renameTo(futureInstalledDir)) {
            throw new IOException("Cannot rename " + tmpDir + " to " + this.installedDir);
        }
        this.installedDir = futureInstalledDir;
    }

    private String getCodeBaseDir() {
        String codeBaseDir = null;
        try {
            codeBaseDir = FindCodeBase.getCodeBaseDir(this.className);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (codeBaseDir == null) {
            codeBaseDir = FindCodeBase.getCodeBaseDir();
        }
        return codeBaseDir;
    }

    private void nonAppletInstall(File tmpDir) throws IOException {
        String codeBaseDir = this.getCodeBaseDir();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Non-applet install of " + this.name + " from codeBaseDir=" + codeBaseDir);
        }
        if (Environment.JAVAWEBSTART && FindCodeBase.isURL(codeBaseDir)) {
            URL codebase = new URL(codeBaseDir);
            this.appletInstall(tmpDir, codebase);
            return;
        }
        File localJar = this.findLocalJar(codeBaseDir);
        InstallFromJar.extractJar(localJar, tmpDir);
    }

    private File findLocalJar(String codeBaseDir) throws IOException {
        String localJarName = this.getJarName(Environment.JAVAWEBSTART ? "RM" : null);
        File localJar = new File(codeBaseDir + "/lib", localJarName);
        if (this.exists(localJar)) {
            return localJar;
        }
        localJar = new File(codeBaseDir, localJarName);
        if (this.exists(localJar)) {
            return localJar;
        }
        localJar = new File(codeBaseDir + File.separator + ".." + File.separator + "lib", localJarName);
        if (this.exists(localJar)) {
            return localJar;
        }
        throw new IOException("I'm sorry, I could not find " + localJarName);
    }

    private boolean exists(File file) {
        boolean res = file.exists();
        if (!res && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, file.getPath() + " does not exist");
        }
        return res;
    }

    private void appletInstall(File tmpDir, URL codebase) throws IOException {
        String jarName = this.getJarName(null);
        URL remotejar = new URL(codebase, jarName);
        File localjar = new File(tmpDir, jarName);
        Environment.downloadURL(remotejar, localjar);
        InstallFromJar.extractJar(localjar, tmpDir);
    }

    private String getJarName(String prefix) {
        String jarName = this.name + ".jar";
        if (prefix != null) {
            jarName = prefix + jarName;
        }
        return jarName;
    }
}

