/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.util.HourglassHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public abstract class MarvinModule
implements Serializable {
    private static final long serialVersionUID = 2763330874643316763L;
    private static ExecutorService service = null;
    private static Set<String> loadedClasses = null;
    private static List<Future<Class<?>>> futureTaskList = null;
    private static Object lock = null;
    private static boolean dialogVisible = false;
    private static JDialog dialog = null;
    private static JProgressBar progress = null;
    private static int moduleLoadingCounter;
    public static final Object moduleLoadingCounterLock;

    public abstract Object modfunc(Object var1);

    public static Object load(String arg) throws SecurityException {
        return MarvinModule.load(arg, null);
    }

    public static Object load(String arg, HourglassHandler hourglass) throws SecurityException {
        String name = MarvinModule.getName(arg);
        Object[] args = MarvinModule.getArgs(arg);
        Class<?>[] argcl = MarvinModule.getArgClasses((String[])args);
        try {
            return MarvinModule.load(name, argcl, args, hourglass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Throwable ex) {
            if (ex.getCause() instanceof SecurityException) {
                throw (SecurityException)ex.getCause();
            }
            if (ex instanceof SecurityException) {
                throw (SecurityException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public static Object load(String moduleName, Class<?>[] argcl, Object[] args, HourglassHandler hourglass) throws ClassNotFoundException, NoSuchMethodException, LinkageError, InstantiationException, IllegalAccessException, InvocationTargetException {
        String name = moduleName.trim();
        int i = name.lastIndexOf(46);
        if (i < 0) {
            name = "chemaxon.marvin.modules." + name;
        } else if (!name.startsWith("chemaxon.")) {
            name = "chemaxon.marvin." + name.substring(0, i) + ".modules." + name.substring(i + 1);
        }
        return MarvinModule.loadClass(name, argcl, args, hourglass);
    }

    public static Object loadClass(String arg, HourglassHandler hourglass) throws SecurityException {
        String name = MarvinModule.getName(arg);
        Object[] args = MarvinModule.getArgs(arg);
        Class<?>[] argcl = MarvinModule.getArgClasses((String[])args);
        try {
            return MarvinModule.loadClass(name, argcl, args, hourglass);
        }
        catch (Throwable ex) {
            if (ex.getCause() instanceof SecurityException) {
                throw (SecurityException)ex.getCause();
            }
            if (ex instanceof SecurityException) {
                throw (SecurityException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadClass(String name, Class<?>[] argcl, Object[] args, HourglassHandler hourglass) throws ClassNotFoundException, NoSuchMethodException, LinkageError, InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            MarvinModule.moduleLoadingStart();
            if (hourglass != null) {
                hourglass.beginHourglass();
            }
            Class<?> cl = MarvinModule.createClass(name, hourglass);
            Constructor<?> constr = cl.getConstructor(argcl);
            Object obj = constr.newInstance(args);
            return obj;
        }
        finally {
            MarvinModule.moduleLoadingStop();
            if (hourglass != null) {
                hourglass.endHourglass();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> createClass(final String name, HourglassHandler hourglass) throws ClassNotFoundException {
        if (!BasicEnvironment.APPLET || !(hourglass instanceof JPanel) || !((JPanel)((Object)hourglass)).isShowing() || BasicEnvironment.isSafariOnMac() || loadedClasses.contains(name)) {
            return Class.forName(name);
        }
        if (service == null || service.isTerminated()) {
            service = Executors.newCachedThreadPool();
        }
        Future f = service.submit(new Callable<Class<?>>(){

            @Override
            public Class<?> call() throws Exception {
                return Class.forName(name);
            }
        });
        futureTaskList.add(f);
        ExecutionException ex = null;
        try {
            Class cl = (Class)f.get(100L, TimeUnit.MILLISECONDS);
            loadedClasses.add(name);
            Class clazz = cl;
            return clazz;
        }
        catch (TimeoutException e) {
            boolean show = false;
            Object object = lock;
            synchronized (object) {
                if (!dialogVisible) {
                    show = true;
                    dialogVisible = true;
                    MarvinModule.createDialog((JPanel)((Object)hourglass));
                    MarvinModule.createAndStartTimer();
                }
            }
            if (show) {
                dialog.setVisible(true);
            }
            try {
                Class cl = (Class)f.get();
                loadedClasses.add(name);
                object = cl;
                return object;
            }
            catch (InterruptedException e1) {
            }
            catch (ExecutionException e1) {
                ex = e1;
            }
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            ex = e;
        }
        finally {
            futureTaskList.remove(f);
        }
        if (ex != null) {
            if (ex.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)ex.getCause();
            }
            ex.printStackTrace();
        }
        return null;
    }

    private static void createDialog(JPanel panel) {
        Window owner = SwingUtilities.getWindowAncestor(panel);
        dialog = owner instanceof Frame ? new JDialog((Frame)owner, true) : (owner instanceof Dialog ? new JDialog((Frame)owner, true) : new JDialog());
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Module is loading, please wait...");
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)new JLabel("Module is loading, please wait..."), "North");
        progress = new JProgressBar();
        dialog.add((Component)progress, "Center");
        dialog.setLocationRelativeTo(panel);
        dialog.pack();
    }

    private static void createAndStartTimer() {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean done = true;
                for (Future f : futureTaskList) {
                    if (f.isDone()) continue;
                    done = false;
                }
                if (!done) {
                    int value = progress != null ? progress.getValue() + Math.round((progress.getMaximum() - progress.getValue()) / 20) : 5;
                    if (value >= 99) {
                        value = 0;
                    }
                    final int valueToSet = value;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (progress != null) {
                                progress.setValue(valueToSet);
                            }
                        }
                    });
                } else {
                    timer.cancel();
                    timer.purge();
                    try {
                        Object value = lock;
                        synchronized (value) {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    MarvinModule.closeDialog();
                                }
                            });
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            }
        }, 200L, 500L);
    }

    private static void closeDialog() {
        if (dialogVisible) {
            dialogVisible = false;
            dialog.setVisible(false);
            dialog.dispose();
            dialog = null;
            progress = null;
        }
    }

    public static void shutdownLoader() {
        if (BasicEnvironment.APPLET && service != null) {
            service.shutdownNow();
            service = null;
        }
    }

    @Deprecated
    public Object getSomething(Object o) {
        return null;
    }

    private static String getName(String name) {
        StringTokenizer st = new StringTokenizer(name);
        return st.nextToken();
    }

    private static String[] getArgs(String name) {
        StringTokenizer st = new StringTokenizer(name);
        int n = st.countTokens() - 1;
        if (n > 0) {
            st.nextToken();
            String[] args = new String[n];
            for (int i = 0; i < n; ++i) {
                args[i] = st.nextToken();
            }
            return args;
        }
        return null;
    }

    private static Class<?>[] getArgClasses(String[] args) {
        if (args != null) {
            Class[] argcl = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argcl[i] = String.class;
            }
            return argcl;
        }
        return null;
    }

    public static boolean isModuleLoadingInProgress() {
        return moduleLoadingCounter > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moduleLoadingStart() {
        Object object = moduleLoadingCounterLock;
        synchronized (object) {
            ++moduleLoadingCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moduleLoadingStop() {
        Object object = moduleLoadingCounterLock;
        synchronized (object) {
            --moduleLoadingCounter;
        }
    }

    static {
        if (BasicEnvironment.APPLET && !BasicEnvironment.isSafariOnMac()) {
            service = Executors.newCachedThreadPool();
            loadedClasses = Collections.synchronizedSet(new HashSet());
            lock = new Object();
            futureTaskList = Collections.synchronizedList(new ArrayList());
        }
        moduleLoadingCounter = 0;
        moduleLoadingCounterLock = new Object();
    }
}

