/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;

public class MulticenterTransform {
    private MulticenterSgroupTransform[] mst;

    public void transformMulticenters(Molecule molecule) {
        int i;
        if (molecule == null) {
            return;
        }
        ArrayList<MulticenterSgroupTransform> list = new ArrayList<MulticenterSgroupTransform>();
        for (i = molecule.getSgroupCount() - 1; i >= 0; --i) {
            MulticenterSgroup sgroup;
            if (!(molecule.getSgroup(i) instanceof MulticenterSgroup) || (sgroup = (MulticenterSgroup)molecule.getSgroup(i)).getCentralAtom() == null) continue;
            MulticenterSgroupTransform transformation = new MulticenterSgroupTransform(i);
            list.add(transformation);
            transformation.replaceCentralAtom(molecule);
        }
        this.mst = new MulticenterSgroupTransform[list.size()];
        list.toArray(this.mst);
        for (i = this.mst.length - 1; i >= 0; --i) {
            this.mst[i].convertToIndices(molecule);
        }
    }

    public void restoreMulticenters(Molecule molecule) {
        int i;
        for (i = this.mst.length - 1; i >= 0; --i) {
            this.mst[i].convertToReferences(molecule);
        }
        for (i = this.mst.length - 1; i >= 0; --i) {
            this.mst[i].restoreCentralAtom(molecule);
        }
    }

    private class MulticenterSgroupTransform {
        private MolBond[] representedBonds = null;
        private MolAtom[] connectionAtoms = null;
        private MolBond[] connectionBonds = null;
        private MolAtom savedCenter = null;
        private int[] connectionAtomIndices;
        private int[] representedBondIndices;
        public int sgroupIndex = -1;

        public MulticenterSgroupTransform(int index) {
            this.sgroupIndex = index;
        }

        public void replaceCentralAtom(Molecule molecule) {
            MulticenterSgroup sgroup = null;
            if (!(molecule.getSgroup(this.sgroupIndex) instanceof MulticenterSgroup)) {
                return;
            }
            sgroup = (MulticenterSgroup)molecule.getSgroup(this.sgroupIndex);
            this.savedCenter = sgroup.getCentralAtom();
            if (this.savedCenter == null) {
                return;
            }
            ArrayList<MolBond> bondlist = new ArrayList<MolBond>();
            this.connectionAtoms = new MolAtom[this.savedCenter.getBondCount()];
            this.connectionBonds = new MolBond[this.savedCenter.getBondCount()];
            for (int i = 0; i < this.savedCenter.getBondCount(); ++i) {
                MolBond b = this.savedCenter.getBond(i);
                MolAtom other = b.getOtherAtom(this.savedCenter);
                for (int j = sgroup.getAtomCount() - 1; j >= 0; --j) {
                    if (other.getAtno() == 137) {
                        MulticenterSgroup msg = this.findContainingGroup(other, molecule);
                        if (msg == null) continue;
                        for (int k = msg.getAtomCount() - 1; k >= 0; --k) {
                            MolBond representedBond = new MolBond(sgroup.getAtom(j), msg.getAtom(k));
                            molecule.add(representedBond);
                            bondlist.add(representedBond);
                        }
                        continue;
                    }
                    MolBond representedBond = new MolBond(sgroup.getAtom(j), other);
                    representedBond.setType(b.getType());
                    molecule.add(representedBond);
                    bondlist.add(representedBond);
                }
                this.connectionAtoms[i] = b.getOtherAtom(this.savedCenter);
                this.connectionBonds[i] = b;
            }
            molecule.removeAtom(this.savedCenter, -49);
            sgroup.setCentralAtom(null);
            this.representedBonds = new MolBond[bondlist.size()];
            bondlist.toArray(this.representedBonds);
        }

        private MulticenterSgroup findContainingGroup(MolAtom other, Molecule mol) {
            if (mol == null) {
                return null;
            }
            for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
                MulticenterSgroup msg;
                if (!(mol.getSgroup(i) instanceof MulticenterSgroup) || (msg = (MulticenterSgroup)mol.getSgroup(i)).getCentralAtom() != other) continue;
                return msg;
            }
            return null;
        }

        public void restoreCentralAtom(Molecule molecule) {
            int i;
            if (molecule == null) {
                return;
            }
            MulticenterSgroup sgroup = null;
            if (!(molecule.getSgroup(this.sgroupIndex) instanceof MulticenterSgroup)) {
                return;
            }
            sgroup = (MulticenterSgroup)molecule.getSgroup(this.sgroupIndex);
            if (this.connectionBonds == null || this.connectionAtoms == null || this.savedCenter == null || this.representedBonds == null) {
                return;
            }
            for (i = this.representedBonds.length - 1; i >= 0; --i) {
                molecule.removeBond(this.representedBonds[i]);
            }
            for (i = this.connectionBonds.length - 1; i >= 0; --i) {
                MolBond bond = this.connectionBonds[i].cloneBond(this.savedCenter, this.connectionAtoms[i]);
                molecule.add(bond);
            }
            molecule.add(this.savedCenter);
            sgroup.setCentralAtom(this.savedCenter);
            sgroup.recalcCentralAtom();
            this.connectionBonds = null;
            this.connectionAtoms = null;
            this.representedBonds = null;
            this.savedCenter = null;
        }

        private void convertToIndices(Molecule molecule) {
            int i;
            MulticenterSgroup sgroup = null;
            if (!(molecule.getSgroup(this.sgroupIndex) instanceof MulticenterSgroup)) {
                return;
            }
            sgroup = (MulticenterSgroup)molecule.getSgroup(this.sgroupIndex);
            this.connectionAtomIndices = new int[this.connectionAtoms.length];
            for (i = this.connectionAtomIndices.length - 1; i >= 0; --i) {
                this.connectionAtomIndices[i] = molecule.indexOf(this.connectionAtoms[i]);
            }
            this.representedBondIndices = new int[this.representedBonds.length];
            for (i = this.representedBondIndices.length - 1; i >= 0; --i) {
                this.representedBondIndices[i] = molecule.indexOf(this.representedBonds[i]);
            }
            int expandableCount = 0;
            this.sgroupIndex = molecule.indexOf(sgroup);
            for (int i2 = 0; i2 < this.sgroupIndex; ++i2) {
                if (!(molecule.getSgroup(i2) instanceof Expandable)) continue;
                ++expandableCount;
            }
            this.sgroupIndex -= expandableCount;
        }

        private void convertToReferences(Molecule molecule) {
            int i;
            this.connectionAtoms = new MolAtom[this.connectionAtomIndices.length];
            for (i = this.connectionAtoms.length - 1; i >= 0; --i) {
                this.connectionAtoms[i] = molecule.getAtom(this.connectionAtomIndices[i]);
            }
            this.representedBonds = new MolBond[this.representedBondIndices.length];
            for (i = this.representedBonds.length - 1; i >= 0; --i) {
                this.representedBonds[i] = molecule.getBond(this.representedBondIndices[i]);
            }
        }
    }
}

