/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.enumeration.homology.HomologyPropertyTypes;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;

public class VMNAttributeUtil {
    public static final String ATTRIBUTE_PREFIX = "VMN_";
    public static final String AMN = "AMN";

    public static void convertAtomAttributes(Molecule mol) {
        MoleculeGraph union = mol.getGraphUnion();
        for (int i = union.getAtomCount() - 1; i >= 0; --i) {
            VMNAttributeUtil.convertAtomAttributes(union.getAtom(i));
        }
    }

    public static void convertAtomAttributes(MolAtom ma) {
        String amn;
        int cr;
        int dt;
        int multiplier = ma.getQPropAsInt("VMN_MU");
        if (multiplier != -1) {
            VMNAttributeUtil.setMultiplier(ma, multiplier);
            ma.setQProp("VMN_MU", null);
        }
        if ((dt = ma.getQPropAsInt("VMN_DT")) != -1) {
            VMNAttributeUtil.setDeuteriumTritium(ma, dt);
            ma.setQProp("VMN_DT", null);
        }
        if ((cr = ma.getQPropAsInt("VMN_CR")) != -1) {
            VMNAttributeUtil.setCarbonRing(ma, cr);
            ma.setQProp("VMN_CR", null);
        }
        if ((amn = (String)ma.getQProp("VMN_AMN")) != null) {
            VMNAttributeUtil.setTextNotes(ma, amn);
            ma.setQProp("VMN_AMN", null);
        }
    }

    public static void setMultiplier(MolAtom ma, int multiplier) {
        int min = VMNAttributeUtil.getAttributeValue(multiplier, 65520);
        int max = VMNAttributeUtil.getAttributeValue(multiplier, 15);
        Molecule mol = (Molecule)ma.getParent();
        RepeatingUnitSgroup sg = new RepeatingUnitSgroup(mol, 2);
        mol.setSgroupParent(ma, sg, true);
        if (ma instanceof SgroupAtom) {
            VMNAttributeUtil.setParentSgroup(((SgroupAtom)ma).getSgroup(), sg);
        }
        CleanUtil.generateBracketCoords(sg, 1);
        sg.setSubscript("" + min + "-" + max);
    }

    public static void setDeuteriumTritium(MolAtom ma, int value) {
        int deuterium = VMNAttributeUtil.getAttributeValue(value, 65280);
        int tritium = VMNAttributeUtil.getAttributeValue(value, 255);
        ma.putProperty("DTCOUNT", HomologyPropertyTypes.DeuteriumTritium.getPropertyString("" + deuterium, "" + tritium));
    }

    public static void setCarbonRing(MolAtom ma, int value) {
        int high;
        int middle;
        int low;
        String size;
        int bra = VMNAttributeUtil.getAttributeValue(value, 2);
        int str = VMNAttributeUtil.getAttributeValue(value, 1);
        if (bra == 0 || str == 0) {
            if (bra != 0) {
                ma.putProperty("BRANCHING", "BRA");
            } else if (str != 0) {
                ma.putProperty("BRANCHING", "STR");
            }
        }
        if ((size = HomologyPropertyTypes.Size.getPropertyString((low = VMNAttributeUtil.getAttributeValue(value, 1024)) != 0, (middle = VMNAttributeUtil.getAttributeValue(value, 512)) != 0, (high = VMNAttributeUtil.getAttributeValue(value, 256)) != 0)) != null) {
            ma.putProperty("SIZE", size);
        }
        int sat = VMNAttributeUtil.getAttributeValue(value, 16);
        int uns = VMNAttributeUtil.getAttributeValue(value, 32);
        if (sat == 0 || uns == 0) {
            if (sat != 0) {
                ma.putProperty("SATURATION", "SAT");
            } else if (uns != 0) {
                ma.putProperty("SATURATION", "UNS");
            }
        }
        int mon = VMNAttributeUtil.getAttributeValue(value, 8192);
        int fu = VMNAttributeUtil.getAttributeValue(value, 4096);
        if (mon == 0 || fu == 0) {
            if (mon != 0) {
                ma.putProperty("RINGTYPE", "MON");
            } else if (fu != 0) {
                ma.putProperty("RINGTYPE", "FU");
            }
        }
    }

    public static void setTextNotes(MolAtom ma, String value) {
        ma.putProperty("TEXTNOTES", value);
    }

    public static int getAttributeValue(int value, int subtype) {
        return value == -1 ? -1 : (value & subtype) >> VMNAttributeUtil.getOffset(subtype);
    }

    private static int getOffset(int mask) {
        int offset = 0;
        while ((mask & 1) == 0) {
            mask >>= 1;
            ++offset;
        }
        return offset;
    }

    private static void setParentSgroup(Sgroup child, Sgroup parent) {
        Sgroup oldParent = child.getParentSgroup();
        if (oldParent != null) {
            oldParent.removeChildSgroup(child);
        }
        parent.addChildSgroup(child);
    }
}

