/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.jep.context.ReactionContext;
import chemaxon.marvin.util.codeassist.CodeAssistDataProvider;
import chemaxon.marvin.util.codeassist.Completable;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ChemTermDocument
extends DefaultStyledDocument
implements CaretListener {
    private static final long serialVersionUID = -5894946790409031807L;
    public static final String DEFAULT_FONT_FAMILY = "Courier New";
    public static final int DEFAULT_FONT_SIZE = 11;
    public static final int ATTRIBUTE_NORMAL = 0;
    public static final int ATTRIBUTE_COMMENT = 1;
    public static final int ATTRIBUTE_QUOTE = 2;
    public static final SimpleAttributeSet DEFAULT_NORMAL = new SimpleAttributeSet();
    public static final SimpleAttributeSet DEFAULT_COMMENT;
    public static final SimpleAttributeSet DEFAULT_STRING;
    public static final SimpleAttributeSet DEFAULT_KEYWORD;
    public static final SimpleAttributeSet DEFAULT_FUNCTION;
    public static final SimpleAttributeSet DEFAULT_PARENTHESIS;
    public static final SimpleAttributeSet DEFAULT_CONSTANT;
    private DefaultStyledDocument doc;
    private Element rootElement;
    private boolean multiLineComment;
    private MutableAttributeSet normal = DEFAULT_NORMAL;
    private MutableAttributeSet comment = DEFAULT_COMMENT;
    private MutableAttributeSet quote = DEFAULT_STRING;
    private MutableAttributeSet keyword = DEFAULT_KEYWORD;
    private MutableAttributeSet function = DEFAULT_FUNCTION;
    private MutableAttributeSet parenthesis = DEFAULT_PARENTHESIS;
    private MutableAttributeSet constant = DEFAULT_CONSTANT;
    private Map<String, AttributeSet> keywords;
    private Map<String, AttributeSet> functions;
    private Map<String, AttributeSet> constants;
    private int fontSize = 11;
    private String fontName = "Courier New";
    private static int DELAY;
    private int parenOffset = 0;
    private int parenLength = 0;
    int currentElementIndex = 0;
    private String prefix = null;
    private boolean lastPrefixState;
    private Timer HIGHLIGHT_TIMER = new Timer(DELAY, new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (ChemTermDocument.this.lastPrefixState != ChemTermDocument.this.isPrefixOk()) {
                    ChemTermDocument.this.lastPrefixState = !ChemTermDocument.this.lastPrefixState;
                    try {
                        ChemTermDocument.this.processChangedLines(0, ChemTermDocument.this.doc.getLength());
                    }
                    catch (BadLocationException e1) {
                        // empty catch block
                    }
                }
                String currentElement = ChemTermDocument.this.getText(ChemTermDocument.this.currentElementIndex, 1);
                ChemTermDocument.this.processChangedLines(ChemTermDocument.this.parenOffset, ChemTermDocument.this.parenLength);
                if (currentElement.equals("(") || currentElement.equals("[") || currentElement.equals("{") || currentElement.equals(")") || currentElement.equals("]") || currentElement.equals("}")) {
                    int index;
                    boolean reverse = false;
                    String open = "(";
                    String close = ")";
                    if (currentElement.equals("[") || currentElement.equals("]")) {
                        open = "[";
                        close = "]";
                    }
                    if (currentElement.equals("{") || currentElement.equals("}")) {
                        open = "{";
                        close = "}";
                    }
                    reverse = currentElement.equals(")") || currentElement.equals("]") || currentElement.equals("}");
                    int count = 1;
                    int startPos = index = ChemTermDocument.this.currentElementIndex;
                    while (count > 0 && index < ChemTermDocument.this.getLength() && index > 0) {
                        index = reverse ? index - 1 : index + 1;
                        String ch = ChemTermDocument.this.getText(index, 1);
                        if (ch.equals(open)) {
                            count = reverse ? count - 1 : count + 1;
                            continue;
                        }
                        if (!ch.equals(close)) continue;
                        count = reverse ? count + 1 : count - 1;
                    }
                    int endPos = index;
                    int from = Math.min(startPos, endPos);
                    int to = Math.max(startPos, endPos);
                    if (ChemTermDocument.this.getText(from, 1).equals(open)) {
                        ChemTermDocument.this.doc.setCharacterAttributes(from, 1, ChemTermDocument.this.isPrefixOk() ? ChemTermDocument.this.parenthesis : ChemTermDocument.this.normal, true);
                    }
                    if (ChemTermDocument.this.getText(to, 1).equals(close)) {
                        ChemTermDocument.this.doc.setCharacterAttributes(to, 1, ChemTermDocument.this.isPrefixOk() ? ChemTermDocument.this.parenthesis : ChemTermDocument.this.normal, true);
                    }
                    ChemTermDocument.this.parenOffset = from;
                    ChemTermDocument.this.parenLength = to - from;
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                ChemTermDocument.this.HIGHLIGHT_TIMER.stop();
            }
        }
    });

    public ChemTermDocument(CodeAssistDataProvider dataProvider) {
        this(dataProvider, null);
    }

    public ChemTermDocument(CodeAssistDataProvider dataProvider, String prefix) {
        this.doc = this;
        this.prefix = prefix;
        this.lastPrefixState = this.isPrefixOk();
        this.rootElement = this.doc.getDefaultRootElement();
        this.putProperty("__EndOfLine__", "\n");
        this.keywords = new HashMap<String, AttributeSet>();
        Iterator<String> it = dataProvider.getKeywordIterator();
        while (it.hasNext()) {
            this.keywords.put(it.next(), this.keyword);
        }
        this.constants = new HashMap<String, AttributeSet>();
        String[] keywordArray = ReactionContext.CFNS;
        for (int i = 0; i < keywordArray.length; ++i) {
            this.constants.put(keywordArray[i], this.constant);
        }
        this.functions = new HashMap<String, AttributeSet>();
        Iterator<Completable> it2 = dataProvider.getItemIterator();
        while (it2.hasNext()) {
            Completable item = it2.next();
            if (item.getType() == Completable.CompletableType.CONSTANT) {
                this.constants.put(item.getName(), this.constant);
                continue;
            }
            if (item.getType() == Completable.CompletableType.USER_DEFINED) continue;
            this.functions.put(item.getName(), this.function);
        }
    }

    public void setAttributeFont(int attribute, int style) {
        Font font = new Font(this.fontName, style, this.fontSize);
        if (attribute == 1) {
            ChemTermDocument.setAttributeFont(this.comment, font);
        } else if (attribute == 2) {
            ChemTermDocument.setAttributeFont(this.quote, font);
        } else {
            ChemTermDocument.setAttributeFont(this.normal, font);
        }
    }

    public static void setAttributeFont(MutableAttributeSet attributeSet, Font font) {
        StyleConstants.setBold(attributeSet, font.isBold());
        StyleConstants.setItalic(attributeSet, font.isItalic());
        StyleConstants.setFontFamily(attributeSet, font.getFamily());
        StyleConstants.setFontSize(attributeSet, font.getSize());
    }

    public void setAttributeColor(int attribute, Color color) {
        if (attribute == 1) {
            ChemTermDocument.setAttributeColor(this.comment, color);
        } else if (attribute == 2) {
            ChemTermDocument.setAttributeColor(this.quote, color);
        } else {
            ChemTermDocument.setAttributeColor(this.normal, color);
        }
    }

    public static void setAttributeColor(MutableAttributeSet attributeSet, Color color) {
        StyleConstants.setForeground(attributeSet, color);
    }

    public void addKeyword(String keyword, MutableAttributeSet attributeSet) {
        this.keywords.put(keyword, attributeSet);
    }

    public MutableAttributeSet getKeywordFormatting(String keyword) {
        return (MutableAttributeSet)this.keywords.get(keyword);
    }

    public void removeKeyword(String keyword) {
        this.keywords.remove(keyword);
    }

    public void addFunction(String function, MutableAttributeSet attributeSet) {
        this.functions.put(function, attributeSet);
    }

    public MutableAttributeSet getFunctionFormatting(String function) {
        return (MutableAttributeSet)this.functions.get(function);
    }

    public void removeFunction(String function) {
        this.functions.remove(function);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attributeSet) throws BadLocationException {
        super.insertString(offset, str, attributeSet);
        this.processChangedLines(offset, str.length());
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        this.setMultiLineComment(this.commentLinesBefore(content, startLine));
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    private boolean commentLinesBefore(String content, int line) {
        int offset = this.rootElement.getElement(line).getStartOffset();
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), offset - 2);
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), startDelimiter);
        if (endDelimiter < offset & endDelimiter != -1) {
            return false;
        }
        this.doc.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, this.isPrefixOk() ? this.comment : this.normal, true);
        return true;
    }

    private void commentLinesAfter(String content, int line) {
        int offset = this.rootElement.getElement(line).getEndOffset();
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.doc.setCharacterAttributes(offset, endDelimiter - offset + 1, this.isPrefixOk() ? this.comment : this.normal, true);
        }
    }

    private void highlightLinesAfter(String content, int line) throws BadLocationException {
        int delimiter;
        int offset = this.rootElement.getElement(line).getEndOffset();
        int startDelimiter = this.indexOf(content, this.getStartDelimiter(), offset);
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this.rootElement.getElementIndex(delimiter);
        for (int i = line + 1; i < endLine; ++i) {
            Element branch = this.rootElement.getElement(i);
            Element leaf = this.doc.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes();
            if (!as.isEqual(this.comment)) continue;
            this.applyHighlighting(content, i);
        }
    }

    private void applyHighlighting(String content, int line) throws BadLocationException {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset)) {
            this.doc.setCharacterAttributes(startOffset, endOffset - startOffset + 1, this.isPrefixOk() ? this.comment : this.normal, true);
            return;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, this.normal, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.doc.setCharacterAttributes(index, endOffset - index + 1, this.isPrefixOk() ? this.comment : this.normal, true);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private boolean startingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getStartDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    private boolean endingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getEndDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private void setMultiLineComment(boolean value) {
        this.multiLineComment = value;
    }

    private void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this.isPrefixOk() ? this.quote : this.normal, false);
        return endOfQuote + 1;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        MutableAttributeSet attr = (MutableAttributeSet)this.keywords.get(token);
        if (attr == null) {
            attr = (MutableAttributeSet)this.functions.get(token);
        }
        if (attr == null) {
            attr = (MutableAttributeSet)this.constants.get(token);
        }
        if (attr != null) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.isPrefixOk() ? attr : this.normal, true);
        }
        return endOfToken + 1;
    }

    private int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private String getLine(String content, int offset) {
        int line = this.rootElement.getElementIndex(offset);
        Element lineElement = this.rootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    protected boolean isDelimiter(String character) {
        String operands = ",;:{}()[]+-/%<=>!&|^~*";
        return Character.isWhitespace(character.charAt(0)) || operands.indexOf(character) != -1;
    }

    protected boolean isQuoteDelimiter(String character) {
        String quoteDelimiters = "\"'";
        return quoteDelimiters.indexOf(character) >= 0;
    }

    protected String getStartDelimiter() {
        return "/*";
    }

    protected String getEndDelimiter() {
        return "*/";
    }

    protected String getSingleLineDelimiter() {
        return "//";
    }

    protected String getEscapeString(String quoteDelimiter) {
        return "\\" + quoteDelimiter;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        StyleConstants.setFontSize(this.normal, fontSize);
        StyleConstants.setFontSize(this.quote, fontSize);
        StyleConstants.setFontSize(this.comment, fontSize);
        StyleConstants.setFontSize(this.keyword, fontSize);
        StyleConstants.setFontSize(this.function, fontSize);
        StyleConstants.setFontSize(this.parenthesis, fontSize);
        StyleConstants.setFontSize(this.constant, fontSize);
        try {
            this.processChangedLines(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
        StyleConstants.setFontFamily(this.normal, fontName);
        StyleConstants.setFontFamily(this.quote, fontName);
        StyleConstants.setFontFamily(this.comment, fontName);
        StyleConstants.setFontFamily(this.keyword, fontName);
        StyleConstants.setFontFamily(this.function, fontName);
        StyleConstants.setFontFamily(this.parenthesis, fontName);
        StyleConstants.setFontFamily(this.constant, fontName);
        try {
            this.processChangedLines(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isPrefixOk() {
        try {
            return this.prefix == null || this.prefix != null && this.doc.getText(0, this.prefix.length()).equals(this.prefix);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.HIGHLIGHT_TIMER.restart();
        this.currentElementIndex = e.getDot();
    }

    static {
        StyleConstants.setForeground(DEFAULT_NORMAL, Color.BLACK);
        StyleConstants.setFontFamily(DEFAULT_NORMAL, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_NORMAL, 11);
        DEFAULT_COMMENT = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_COMMENT, new Color(51, 102, 0));
        StyleConstants.setFontFamily(DEFAULT_COMMENT, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_COMMENT, 11);
        DEFAULT_STRING = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_STRING, new Color(153, 0, 107));
        StyleConstants.setFontFamily(DEFAULT_STRING, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_STRING, 11);
        DEFAULT_KEYWORD = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_KEYWORD, Color.BLACK);
        StyleConstants.setBold(DEFAULT_KEYWORD, true);
        StyleConstants.setFontFamily(DEFAULT_KEYWORD, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_KEYWORD, 11);
        DEFAULT_FUNCTION = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_FUNCTION, new Color(0, 0, 253));
        StyleConstants.setBold(DEFAULT_FUNCTION, true);
        StyleConstants.setFontFamily(DEFAULT_FUNCTION, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_FUNCTION, 11);
        DEFAULT_PARENTHESIS = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_PARENTHESIS, Color.BLACK);
        StyleConstants.setBackground(DEFAULT_PARENTHESIS, new Color(100, 200, 255));
        StyleConstants.setBold(DEFAULT_PARENTHESIS, true);
        StyleConstants.setFontFamily(DEFAULT_PARENTHESIS, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_PARENTHESIS, 11);
        DEFAULT_CONSTANT = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_CONSTANT, new Color(200, 100, 0));
        StyleConstants.setBold(DEFAULT_CONSTANT, true);
        StyleConstants.setFontFamily(DEFAULT_CONSTANT, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_CONSTANT, 11);
        DELAY = 100;
    }
}

