/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.marvin.util.codeassist.ChemTermDocument;
import chemaxon.marvin.util.codeassist.CodeAssistDataProvider;
import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.CompletableDisplayHelper;
import chemaxon.marvin.util.codeassist.DefaultCompletable;
import chemaxon.marvin.util.codeassist.ParamSetWalker;
import chemaxon.marvin.util.codeassist.UserDefinedCompletable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;

public class CodeAssist {
    static final String DEFAULT_HELPTEXT = "Type your Chemical Terms here.\nPress <ctrl> and <space> to get a list of available commands.";
    private static final int DEFAULT_WIDTH = 320;
    private static final int DEFAULT_HEIGHT = 150;
    static final ImageIcon fuctionIcon = new ImageIcon(CodeAssist.class.getResource("images/builtin.gif"));
    static final ImageIcon pluginIcon = new ImageIcon(CodeAssist.class.getResource("images/plugin.gif"));
    static final ImageIcon userdefinedIcon = new ImageIcon(CodeAssist.class.getResource("images/userdefined.gif"));
    private final WeakReference<JTextPane> textPaneReference;
    private JPanel popupContent;
    private Window popupWindow = null;
    private JEditorPane helpPane = null;
    private JList popupList = null;
    private KeyListener globalKeyListener = null;
    private MouseListener globalMouseListener = null;
    private String prefix = null;
    private JScrollPane listScrollPane = null;
    private JScrollPane helpScrollPane = null;
    private final CodeAssistDataProvider dataProvider;
    private boolean autoPopup = false;
    private boolean expertMode = false;

    CodeAssist(CodeAssistDataProvider dataProvider, String prefix, final String helpText, boolean expertMode) {
        this.prefix = prefix;
        this.expertMode = expertMode;
        JTextPane textPane = new JTextPane(){
            private static final long serialVersionUID = -4935696358622718118L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (helpText != null && this.getText().length() == 0) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setColor(Color.GRAY);
                    String[] text = helpText.split("\n");
                    float height = this.getFontMetrics(this.getFont()).getLineMetrics(helpText, g2).getHeight() + 5.0f;
                    float top = ((float)this.getHeight() - (float)text.length * height) / 2.0f;
                    for (int i = 0; i < text.length; ++i) {
                        float left = (this.getWidth() - this.getFontMetrics(this.getFont()).stringWidth(text[i])) / 2;
                        g2.drawString(text[i], left, top + (float)i * height);
                    }
                    g2.dispose();
                }
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                int charIndex = this.viewToModel(event.getPoint());
                String word = CodeAssist.this.getWordContainsPosition(charIndex);
                String help = null;
                if (word.length() > 0) {
                    Iterator<Completable> iterator = CodeAssist.this.dataProvider.getItemIterator();
                    while (iterator.hasNext() && help == null) {
                        String img;
                        Completable item = iterator.next();
                        if (!item.getName().equalsIgnoreCase(word)) continue;
                        help = item.getDescription();
                        if (!(item instanceof DefaultCompletable) || (img = ((DefaultCompletable)item).getImageTag()).length() <= 0) continue;
                        help = "<html><body><center><b>" + item.getName() + "</b></center><br>" + img + "<br><center>" + help + "</center></body></html>";
                    }
                }
                return help;
            }
        };
        this.textPaneReference = new WeakReference<1>(textPane);
        this.dataProvider = dataProvider;
        StyledEditorKit editorKit = new StyledEditorKit(){
            private static final long serialVersionUID = -5603397288488848353L;

            @Override
            public Document createDefaultDocument() {
                ChemTermDocument doc = new ChemTermDocument(CodeAssist.this.dataProvider, CodeAssist.this.prefix);
                JTextPane textPane = CodeAssist.this.getTextPane();
                if (textPane != null) {
                    textPane.addCaretListener(doc);
                }
                return doc;
            }
        };
        textPane.setEditorKit(editorKit);
        textPane.addKeyListener(this.getGlobalKeyListener());
        textPane.addMouseListener(this.getGlobalMouseListener());
        ToolTipManager.sharedInstance().registerComponent(textPane);
    }

    private JPanel getPopupContent() {
        if (this.popupContent == null) {
            this.popupContent = new JPanel();
            this.popupContent.setLayout(new BorderLayout());
            this.popupContent.add((Component)this.getListScrollPane(), "North");
            this.popupContent.add((Component)this.getHelpScrollPane(), "South");
        }
        return this.popupContent;
    }

    private JList getPopupList() {
        if (this.popupList == null) {
            this.popupList = new JList();
            this.popupList.setFocusable(true);
            this.popupList.addMouseListener(this.getGlobalMouseListener());
            this.popupList.addKeyListener(this.getGlobalKeyListener());
            this.popupList.setCellRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 8921012746315349556L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                    if (value instanceof Completable) {
                        if (!CodeAssist.this.expertMode && value instanceof DefaultCompletable) {
                            label.setText(((DefaultCompletable)value).toSimpleString());
                        }
                        Completable.CompletableType type = ((Completable)value).getType();
                        ImageIcon newIcon = null;
                        if (type == Completable.CompletableType.FUNCTION) {
                            newIcon = fuctionIcon;
                        } else if (type == Completable.CompletableType.PLUG_IN) {
                            newIcon = pluginIcon;
                        } else if (type == Completable.CompletableType.USER_DEFINED) {
                            newIcon = userdefinedIcon;
                        }
                        label.setIcon(newIcon);
                    }
                    return label;
                }
            });
            this.popupList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (CodeAssist.this.popupList.getSelectedIndex() != -1) {
                        CodeAssist.this.refreshHelp();
                    }
                }
            });
            this.popupList.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    CodeAssist.this.hideWindow();
                }
            });
        }
        return this.popupList;
    }

    private JScrollPane getListScrollPane() {
        if (this.listScrollPane == null) {
            this.listScrollPane = new JScrollPane();
            this.listScrollPane.setViewportView(this.getPopupList());
            this.listScrollPane.setPreferredSize(new Dimension(320, 150));
        }
        return this.listScrollPane;
    }

    private JScrollPane getHelpScrollPane() {
        if (this.helpScrollPane == null) {
            this.helpScrollPane = new JScrollPane();
            this.helpScrollPane.setFocusable(false);
            this.helpScrollPane.setHorizontalScrollBarPolicy(31);
            this.helpScrollPane.setVerticalScrollBarPolicy(20);
            this.helpScrollPane.setViewportView(this.getHelpPane());
            this.listScrollPane.setPreferredSize(new Dimension(320, 150));
        }
        return this.helpScrollPane;
    }

    private JEditorPane getHelpPane() {
        if (this.helpPane == null) {
            this.helpPane = CompletableDisplayHelper.createDescriptionField();
        }
        return this.helpPane;
    }

    private KeyListener getGlobalKeyListener() {
        if (this.globalKeyListener == null) {
            this.globalKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    JTextPane textPane = CodeAssist.this.getTextPane();
                    if (e.getComponent() == textPane && CodeAssist.this.popupWindow == null) {
                        String key;
                        if (e.isControlDown() && e.getKeyCode() == 32) {
                            e.consume();
                            CodeAssist.this.showList();
                        } else if (CodeAssist.this.autoPopup && e.getKeyChar() != '\uffff' && (key = String.valueOf(e.getKeyChar())).matches("[a-zA-Z]")) {
                            CodeAssist.this.showList();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CodeAssist.this.setList();
                                }
                            });
                        }
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    JTextPane textPane = CodeAssist.this.getTextPane();
                    if (e.getComponent() != textPane) {
                        try {
                            if (e.getKeyChar() == '\n') {
                                CodeAssist.this.acceptSelection();
                            } else if (e.getKeyChar() == '\u001b') {
                                CodeAssist.this.hideWindow();
                            } else {
                                if (e.getKeyChar() == '\b') {
                                    textPane.getDocument().remove(textPane.getCaretPosition() - 1, 1);
                                } else if (e.getKeyChar() == '\u007f') {
                                    textPane.getDocument().remove(textPane.getCaretPosition(), 1);
                                } else {
                                    textPane.getDocument().insertString(textPane.getCaretPosition(), String.valueOf(e.getKeyChar()), null);
                                }
                                if (CodeAssist.this.popupWindow != null) {
                                    CodeAssist.this.setList();
                                }
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            };
        }
        return this.globalKeyListener;
    }

    private MouseListener getGlobalMouseListener() {
        if (this.globalMouseListener == null) {
            this.globalMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getSource() == CodeAssist.this.getPopupList()) {
                        if (e.getButton() == 1 && e.getClickCount() == 2) {
                            CodeAssist.this.acceptSelection();
                        }
                    } else if (e.getSource() == CodeAssist.this.getTextPane() && CodeAssist.this.popupWindow == null && e.getButton() == 3) {
                        CodeAssist.this.showList();
                    }
                }
            };
        }
        return this.globalMouseListener;
    }

    private boolean setList() {
        Iterator<Completable> iterator;
        String word = this.getCurrentWord();
        LinkedList<Completable> tmpItems = new LinkedList<Completable>();
        String currentFuctionName = this.getCurrentFunctionName();
        if (currentFuctionName.equalsIgnoreCase("match") || currentFuctionName.equalsIgnoreCase("matchCount")) {
            iterator = this.dataProvider.getItemIterator();
            while (iterator.hasNext()) {
                Completable item = iterator.next();
                String name = item.getName();
                if (item.getType() != Completable.CompletableType.CONSTANT || word != "" && !name.substring(0, word.length() > name.length() ? name.length() : word.length()).equalsIgnoreCase(word)) continue;
                tmpItems.add(item);
            }
        } else {
            iterator = this.dataProvider.getItemIterator();
            while (iterator.hasNext()) {
                Completable item = iterator.next();
                String name = item.getName();
                if (item.getType() == Completable.CompletableType.CONSTANT || word != "" && !name.substring(0, word.length() > name.length() ? name.length() : word.length()).equalsIgnoreCase(word)) continue;
                if (this.expertMode && item instanceof DefaultCompletable) {
                    ParamSetWalker walker = new ParamSetWalker(((DefaultCompletable)item).getParameters());
                    while (walker.hasNext()) {
                        DefaultCompletable clone = ((DefaultCompletable)item).cloneCompletable();
                        clone.setParameters(walker.next());
                        tmpItems.add(clone);
                    }
                    continue;
                }
                tmpItems.add(item);
            }
        }
        if (tmpItems.size() > 0) {
            this.getPopupList().removeAll();
            Completable[] items = tmpItems.toArray(new Completable[0]);
            Arrays.sort(items, new Comparator<Completable>(){

                @Override
                public int compare(Completable o1, Completable o2) {
                    return o1.toString().compareToIgnoreCase(o2.toString());
                }
            });
            this.getPopupList().setListData(items);
            this.getPopupList().setSelectedIndex(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodeAssist.this.getPopupList().scrollRectToVisible(new Rectangle(0, 0));
                }
            });
            return true;
        }
        return false;
    }

    private void showList() {
        JTextPane textPane = this.getTextPane();
        if (textPane != null) {
            if (this.prefix != null && !textPane.getText().startsWith(this.prefix)) {
                return;
            }
            if (!this.setList()) {
                return;
            }
            if (this.getPopupList().getModel().getSize() == 1) {
                this.acceptSelection();
                return;
            }
            Point position = textPane.getCaret().getMagicCaretPosition() != null ? (Point)textPane.getCaret().getMagicCaretPosition().clone() : new Point(0, 0);
            SwingUtilities.convertPointToScreen(position, textPane);
            int xpos = position.x;
            FontRenderContext context = ((Graphics2D)textPane.getGraphics()).getFontRenderContext();
            LineMetrics metrics2 = textPane.getFont().getLineMetrics("g", context);
            int ypos = position.y + (int)metrics2.getHeight() + 5;
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            if (xpos < 0) {
                xpos = 0;
            }
            if (ypos < 0) {
                ypos = 0;
            }
            if (xpos + 320 > screen.width) {
                xpos = screen.width - 320;
            }
            if (ypos + 300 > screen.height) {
                ypos = screen.height - 300;
            }
            this.popupWindow = new Window(SwingUtilities.getWindowAncestor(textPane));
            this.popupWindow.setLayout(new BorderLayout());
            this.popupWindow.add((Component)this.getPopupContent(), "Center");
            this.popupWindow.setBounds(xpos, ypos, 0, 0);
            this.popupWindow.pack();
            this.popupWindow.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CodeAssist.this.getPopupList().getModel().getSize() != 0) {
                        CodeAssist.this.getPopupList().setSelectedIndex(0);
                    }
                    CodeAssist.this.getPopupList().requestFocus();
                }
            });
        }
    }

    private void acceptSelection() {
        JTextPane textPane = this.getTextPane();
        if (textPane != null) {
            try {
                Completable item;
                String word = this.getCurrentWord();
                textPane.getDocument().remove(textPane.getCaretPosition() - word.length(), word.length());
                boolean bracketNeeded = true;
                if (textPane.getText().length() > textPane.getCaretPosition()) {
                    boolean bl = bracketNeeded = textPane.getText().charAt(textPane.getCaretPosition()) != '(';
                }
                if ((item = (Completable)this.getPopupList().getSelectedValue()).getType() == Completable.CompletableType.CONSTANT || item.getType() == Completable.CompletableType.USER_DEFINED) {
                    bracketNeeded = false;
                }
                if (item instanceof UserDefinedCompletable) {
                    textPane.getDocument().insertString(textPane.getCaretPosition(), ((UserDefinedCompletable)item).getMacro() + (bracketNeeded ? "()" : ""), null);
                } else {
                    textPane.getDocument().insertString(textPane.getCaretPosition(), item.getName() + (bracketNeeded ? "()" : ""), null);
                }
                textPane.setCaretPosition(bracketNeeded ? textPane.getCaretPosition() - 1 : textPane.getCaretPosition());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.hideWindow();
    }

    private void hideWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTextPane textPane;
                if (CodeAssist.this.popupWindow != null) {
                    CodeAssist.this.popupWindow.dispose();
                    CodeAssist.this.popupWindow = null;
                }
                if ((textPane = CodeAssist.this.getTextPane()) != null) {
                    textPane.requestFocus();
                }
            }
        });
    }

    private String getCurrentWord() {
        String word = "";
        JTextPane textPane = this.getTextPane();
        if (textPane != null) {
            word = this.getCurrentWord(textPane.getCaretPosition());
        }
        return word;
    }

    private String getCurrentWord(int position) {
        String word = "";
        JTextPane textPane = this.getTextPane();
        if (textPane != null) {
            try {
                int startpos;
                int endpos = startpos = position;
                while (startpos > 0 && !textPane.getText(startpos - 1, 1).equalsIgnoreCase("\n")) {
                    --startpos;
                }
                word = textPane.getText(startpos, endpos - startpos);
                if (this.prefix != null && startpos == 0 && word.startsWith(this.prefix)) {
                    word = word.substring(this.prefix.length());
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        while (!Pattern.matches("\\w*", word)) {
            word = word.substring(1);
        }
        return word;
    }

    private String getCurrentFunctionName() {
        String word = "";
        JTextPane textPane = this.getTextPane();
        if (textPane != null) {
            try {
                int startpos;
                int counter = 1;
                for (startpos = textPane.getCaretPosition(); startpos > 0 && counter != 0; --startpos) {
                    if (textPane.getText(startpos - 1, 1).equalsIgnoreCase(")")) {
                        ++counter;
                    }
                    if (!textPane.getText(startpos - 1, 1).equalsIgnoreCase("(")) continue;
                    --counter;
                }
                word = this.getCurrentWord(startpos);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return word;
    }

    private void refreshHelp() {
        Completable term = (Completable)this.getPopupList().getSelectedValue();
        this.getHelpPane().setText(CompletableDisplayHelper.getFullDescription(term, this.expertMode));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeAssist.this.getHelpPane().scrollRectToVisible(new Rectangle(0, 0));
            }
        });
    }

    private String getWordContainsPosition(int index) {
        String word = "";
        int leftEnd = index;
        int rightEnd = 1;
        JTextPane textPane = this.getTextPane();
        if (textPane != null) {
            int length = textPane.getText().length();
            try {
                word = textPane.getText(index, 1);
                if (Pattern.matches("\\w*", word)) {
                    while (Pattern.matches("\\w*", textPane.getText(leftEnd--, index - leftEnd)) && leftEnd >= 0) {
                        word = textPane.getText(leftEnd, index - leftEnd + 1);
                    }
                    while (!Pattern.matches("\\w*", word)) {
                        word = textPane.getText(++leftEnd, index - leftEnd + 1);
                    }
                    if (leftEnd < 0) {
                        leftEnd = 0;
                    }
                    while (Pattern.matches("\\w*", word) && index + rightEnd + 1 <= length) {
                        word = textPane.getText(leftEnd, index - leftEnd + 1 + rightEnd);
                        ++rightEnd;
                    }
                    while (!Pattern.matches("\\w*", word)) {
                        word = textPane.getText(leftEnd, index - leftEnd + 1 + --rightEnd);
                    }
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        if (this.prefix != null && leftEnd == 0 && word.startsWith(this.prefix)) {
            word = word.substring(this.prefix.length());
        }
        return word;
    }

    public JTextPane getTextPane() {
        return (JTextPane)this.textPaneReference.get();
    }

    public CodeAssistDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public boolean isAutoPopup() {
        return this.autoPopup;
    }

    public void setAutoPopup(boolean autoPopup) {
        this.autoPopup = autoPopup;
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void setExpertMode(boolean expertMode) {
        this.expertMode = expertMode;
    }

    public void setFontSize(int size) {
        JTextPane pane;
        if (this.textPaneReference != null && (pane = (JTextPane)this.textPaneReference.get()) != null && pane.getStyledDocument() instanceof ChemTermDocument) {
            ((ChemTermDocument)pane.getStyledDocument()).setFontSize(size);
        }
    }

    public int getFontSize() {
        JTextPane pane;
        if (this.textPaneReference != null && (pane = (JTextPane)this.textPaneReference.get()) != null && pane.getStyledDocument() instanceof ChemTermDocument) {
            return ((ChemTermDocument)pane.getStyledDocument()).getFontSize();
        }
        return 0;
    }
}

