/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.jep.ChemContext;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.ReactionContext;
import chemaxon.marvin.uif.builder.DefaultModuleConfiguration;
import chemaxon.marvin.uif.module.ConfigurationException;
import chemaxon.marvin.uif.module.Configurer;
import chemaxon.marvin.uif.module.GUIModule;
import chemaxon.marvin.util.codeassist.CodeAssist;
import chemaxon.marvin.util.codeassist.CodeAssistDataProvider;
import chemaxon.marvin.util.codeassist.CodeAssistMacrosHelper;
import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.CompletionItemCellRenderer;
import chemaxon.marvin.util.codeassist.EvaluatorCodeAssistDataProvider;
import chemaxon.marvin.util.codeassist.MacroManagerPanel;
import chemaxon.marvin.util.codeassist.UserDefinedCompletable;
import chemaxon.marvin.util.codeassist.toolbar.CodeAssistFavoritesHelper;
import chemaxon.marvin.util.codeassist.toolbar.FavoritesManagerPanel;
import chemaxon.marvin.util.codeassist.toolbar.FunctionSelectorPanel;
import chemaxon.marvin.util.codeassist.toolbar.actions.CodeAssistAction;
import chemaxon.nfunk.jep.ParseException;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class CodeAssistFactory {
    public static final String PROPERTY_KEY_FACTORY_INSTANCE = "AlchemistCodeAssistFactory_Instance";
    private static final String DEFAULT_TOOLBAR_CONFIG = "chemaxon/marvin/util/codeassist/toolbar/DefaultToolbarConfiguration.xml";
    private static final String ERROR = "error";
    private static final String ERROR_MESSAGE = "The Chemical Terms you entered is invalid";
    private static final String MACROS_DIALOG_TITLE = "Manage Macros";
    private static final String FAVORITES_DIALOG_TITLE = "Manage Favorites";
    private static final String FUNCTIONS_DIALOG_TITLE = "Insert Function";
    private static final Map<JTextPane, CodeAssistFactory> factoryMap = new WeakHashMap<JTextPane, CodeAssistFactory>();
    private static final Map<String, Icon> iconMap = new HashMap<String, Icon>();
    private static final CodeAssistFavoritesHelper favoritesHelper = new CodeAssistFavoritesHelper();
    private static final CodeAssistMacrosHelper macrosHelper = new CodeAssistMacrosHelper();
    private CodeAssist codeAssist = null;
    private JComboBox favoritesComboBox = null;
    private FavoritesManagerPanel favoritesPanel = null;
    private MacroManagerPanel macrosPanel = null;
    private FunctionSelectorPanel functionsPanel = null;
    private JLabel validationResultLabel = null;
    private JDialog macrosDialog = null;
    private JDialog favoritesDialog = null;
    private JDialog functionsDialog = null;
    private GUIModule guiModule = null;
    private final Action ACCEPT_FUNCTION_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 6968705971254140706L;

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = CodeAssistFactory.this.getFunctionsPanel().getFunctionText();
            if (CodeAssistFactory.this.functionsDialog != null) {
                CodeAssistFactory.this.functionsDialog.dispose();
            }
            CodeAssistFactory.this.functionsDialog = null;
            try {
                CodeAssistFactory.this.codeAssist.getTextPane().getDocument().insertString(CodeAssistFactory.this.codeAssist.getTextPane().getCaretPosition(), text, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    };
    private final Action CANCEL_FUNCTION_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 6493661092625267013L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CodeAssistFactory.this.functionsDialog != null) {
                CodeAssistFactory.this.functionsDialog.dispose();
            }
            CodeAssistFactory.this.functionsDialog = null;
        }
    };
    private final Action ACCEPT_FAVORITES_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 6493661092625267013L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CodeAssistFactory.this.favoritesDialog != null) {
                CodeAssistFactory.this.favoritesDialog.dispose();
            }
            CodeAssistFactory.this.favoritesDialog = null;
            favoritesHelper.writeFavorites();
            CodeAssistFactory.updateAllFavoritesComboBoxes();
        }
    };
    private final Action CANCEL_FAVORITES_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 8588342046522269230L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CodeAssistFactory.this.favoritesDialog != null) {
                CodeAssistFactory.this.favoritesDialog.dispose();
            }
            CodeAssistFactory.this.favoritesDialog = null;
            favoritesHelper.readFavorites();
        }
    };
    private final Action ACCEPT_MACROS_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 8588342046522269230L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CodeAssistFactory.this.macrosDialog != null) {
                CodeAssistFactory.this.macrosDialog.dispose();
            }
            CodeAssistFactory.this.macrosDialog = null;
            macrosHelper.writeMacros();
            CodeAssistFactory.updateAllMacros();
        }
    };
    private final Action CANCEL_MACROS_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 6226861784531376856L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CodeAssistFactory.this.macrosDialog != null) {
                CodeAssistFactory.this.macrosDialog.dispose();
            }
            CodeAssistFactory.this.macrosDialog = null;
            macrosHelper.readMacros();
        }
    };

    public static JTextPane createChemicalTermsTextPane() {
        return CodeAssistFactory.createChemicalTermsTextPane(true);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(CodeAssistDataProvider.Context context) {
        return CodeAssistFactory.createChemicalTermsTextPane(true, context);
    }

    public static JTextPane createChemicalTermsTextPane(boolean helpText) {
        CodeAssistConfiguration config = new CodeAssistConfiguration();
        if (!helpText) {
            config.setHelpText(null);
        }
        return CodeAssistFactory.createChemicalTermsTextPane(config);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(boolean helpText, CodeAssistDataProvider.Context context) {
        return CodeAssistFactory.createChemicalTermsTextPane(null, helpText, context);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(boolean helpText, boolean autoPopup) {
        return CodeAssistFactory.createChemicalTermsTextPane(null, helpText, autoPopup);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(boolean helpText, boolean autoPopup, boolean expertMode) {
        return CodeAssistFactory.createChemicalTermsTextPane(null, helpText, autoPopup, expertMode);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(boolean helpText, boolean autoPopup, CodeAssistDataProvider.Context context) {
        return CodeAssistFactory.createChemicalTermsTextPane(null, helpText, autoPopup, context);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, true);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, CodeAssistDataProvider.Context context) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, true);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, boolean helpText) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, false);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, boolean helpText, CodeAssistDataProvider.Context context) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, false, context);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, boolean helpText, boolean autoPopup) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText ? "Type your Chemical Terms here.\nPress <ctrl> and <space> to get a list of available commands." : null, autoPopup);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, boolean helpText, boolean autoPopup, boolean expertMode) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText ? "Type your Chemical Terms here.\nPress <ctrl> and <space> to get a list of available commands." : null, autoPopup, expertMode);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, boolean helpText, boolean autoPopup, CodeAssistDataProvider.Context context) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText ? "Type your Chemical Terms here.\nPress <ctrl> and <space> to get a list of available commands." : null, autoPopup, context);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, String helpText) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, false);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, String helpText, boolean autoPopup) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, autoPopup, DEFAULT_TOOLBAR_CONFIG);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, String helpText, boolean autoPopup, boolean expertMode) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, autoPopup, DEFAULT_TOOLBAR_CONFIG, expertMode);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, String helpText, boolean autoPopup, CodeAssistDataProvider.Context context) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, autoPopup, DEFAULT_TOOLBAR_CONFIG, context);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, String helpText, boolean autoPopup, String toolbarConfigPath) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, autoPopup, toolbarConfigPath, false, CodeAssistDataProvider.Context.MOLECULE);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, String helpText, boolean autoPopup, String toolbarConfigPath, boolean expertMode) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, autoPopup, toolbarConfigPath, expertMode, CodeAssistDataProvider.Context.MOLECULE);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, String helpText, boolean autoPopup, String toolbarConfigPath, CodeAssistDataProvider.Context context) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, autoPopup, toolbarConfigPath, false, context);
    }

    @Deprecated
    public static JTextPane createChemicalTermsTextPane(String prefix, String helpText, boolean autoPopup, String toolbarConfigPath, boolean expertMode, CodeAssistDataProvider.Context context) {
        return CodeAssistFactory.createChemicalTermsTextPane(prefix, helpText, autoPopup, toolbarConfigPath, expertMode, context, true);
    }

    public static JTextPane createChemicalTermsTextPane(CodeAssistConfiguration config) {
        return CodeAssistFactory.createChemicalTermsTextPane(config.getPrefix(), config.getHelpText(), config.isAutoPopup(), config.getToolbarConfigPath(), config.isExpertMode(), config.getContext(), config.isAddServices());
    }

    protected static JTextPane createChemicalTermsTextPane(String prefix, String helpText, boolean autoPopup, String toolbarConfigPath, boolean expertMode, CodeAssistDataProvider.Context context, boolean addServices) {
        JTextPane pane = null;
        try {
            CodeAssistFactory factory = new CodeAssistFactory(new EvaluatorCodeAssistDataProvider(context, addServices), prefix, helpText, autoPopup, toolbarConfigPath, expertMode);
            pane = factory.getTextPane();
            factoryMap.put(pane, factory);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can not create factory: parse error", e);
        }
        return pane;
    }

    public static JToolBar getToolBar(JTextPane textPane) {
        CodeAssistFactory.getFactory(textPane).updateFavoritesCombo();
        return CodeAssistFactory.getFactory((JTextPane)textPane).guiModule.getToolBar("defaultToolbar");
    }

    public static JToolBar getOperatorToolBar(JTextPane textPane) {
        return CodeAssistFactory.getFactory((JTextPane)textPane).guiModule.getToolBar("operatorToolbar");
    }

    public static JToolBar getCusromToolBar(JTextPane textPane, String toolbarID) {
        return CodeAssistFactory.getFactory((JTextPane)textPane).guiModule.getToolBar(toolbarID);
    }

    public static JLabel getValidationResultLabel(JTextPane textPane) {
        return CodeAssistFactory.getValidationResultLabel(textPane, CodeAssistDataProvider.Context.MOLECULE);
    }

    public static JLabel getValidationResultLabelForReactionContext(JTextPane textPane) {
        return CodeAssistFactory.getValidationResultLabel(textPane, CodeAssistDataProvider.Context.REACTION);
    }

    public static JLabel getValidationResultLabel(JTextPane textPane, CodeAssistDataProvider.Context context) {
        switch (context) {
            case REACTION: {
                return CodeAssistFactory.getFactory(textPane).getValidationResultLabel(ReactionContext.class);
            }
        }
        return CodeAssistFactory.getFactory(textPane).getValidationResultLabel(ReactionContext.class);
    }

    private static CodeAssistFactory getFactory(JTextPane textPane) {
        CodeAssistFactory factory = factoryMap.get(textPane);
        if (factory == null) {
            throw new IllegalArgumentException("textPane not created with this factory.");
        }
        return factory;
    }

    private static void updateAllFavoritesComboBoxes() {
        Iterator<Map.Entry<JTextPane, CodeAssistFactory>> it = factoryMap.entrySet().iterator();
        while (it.hasNext()) {
            CodeAssistFactory factoryInstance = it.next().getValue();
            factoryInstance.updateFavoritesCombo();
        }
    }

    private static void updateAllMacros() {
        macrosHelper.readMacros();
        Iterator<Map.Entry<JTextPane, CodeAssistFactory>> it = factoryMap.entrySet().iterator();
        while (it.hasNext()) {
            CodeAssistFactory factoryInstance = it.next().getValue();
            factoryInstance.updateMacrosCompletion();
        }
    }

    private CodeAssistFactory(CodeAssistDataProvider dataProvider, String prefix, String helpText, boolean autoPopup, String toolbarConfigPath, boolean expertMode) {
        try {
            InputStream inputStream = CodeAssistFactory.class.getClassLoader().getResourceAsStream(toolbarConfigPath);
            this.guiModule = new GUIModule(new DefaultModuleConfiguration(inputStream));
            this.guiModule.addConfigurer(new ToolBarActionConfigurer(this));
        }
        catch (ConfigurationException e) {
            System.err.println("Can not initialize toolbar.");
            e.printStackTrace();
        }
        this.codeAssist = new CodeAssist(dataProvider, prefix, helpText, expertMode);
        this.codeAssist.setAutoPopup(autoPopup);
        this.getTextPane().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    CodeAssistFactory.this.codeAssist.setFontSize(Math.max(CodeAssistFactory.this.codeAssist.getFontSize() + e.getWheelRotation(), 5));
                }
            }
        });
        this.getTextPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown()) {
                    if (e.getKeyCode() == 107 || e.getKeyCode() == 521 || e.getKeyCode() == 61) {
                        CodeAssistFactory.this.codeAssist.setFontSize(Math.max(CodeAssistFactory.this.codeAssist.getFontSize() + 2, 5));
                    } else if (e.getKeyCode() == 109 || e.getKeyCode() == 45) {
                        CodeAssistFactory.this.codeAssist.setFontSize(Math.max(CodeAssistFactory.this.codeAssist.getFontSize() - 2, 5));
                    }
                }
            }
        });
    }

    private JTextPane getTextPane() {
        return this.codeAssist.getTextPane();
    }

    public JComboBox getFavoritesComboBox() {
        if (this.favoritesComboBox == null) {
            this.favoritesComboBox = new JComboBox();
            this.favoritesComboBox.setRenderer(new CompletionItemCellRenderer());
            this.favoritesComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && CodeAssistFactory.this.favoritesComboBox.getSelectedIndex() != 0) {
                        CodeAssistFactory.this.getFunctionsPanel().updateFunctions(CodeAssistFactory.this.codeAssist.getDataProvider());
                        CodeAssistFactory.this.getFunctionsPanel().set((Completable)CodeAssistFactory.this.favoritesComboBox.getSelectedItem());
                        CodeAssistFactory.this.getFunctionsDialog().pack();
                        CodeAssistFactory.this.getFunctionsDialog().setLocationRelativeTo(null);
                        CodeAssistFactory.this.getFunctionsDialog().setVisible(true);
                        CodeAssistFactory.this.favoritesComboBox.setSelectedIndex(0);
                    }
                }
            });
        }
        return this.favoritesComboBox;
    }

    private JLabel getValidationResultLabel(final Class<? extends ChemContext> contextClass) {
        if (this.validationResultLabel == null) {
            this.validationResultLabel = new JLabel(){
                private static final long serialVersionUID = -604645898511661544L;

                @Override
                protected void paintComponent(Graphics g) {
                    if (this.getClientProperty("decorated") == null || this.getClientProperty("decorated").equals("true")) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2.setColor(this.getBackground());
                        g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 15, 15);
                        g2.setColor(Color.GRAY);
                        g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 15, 15);
                        g2.dispose();
                    }
                    super.paintComponent(g);
                }
            };
            this.validationResultLabel.setIcon(iconMap.get(ERROR));
            this.validationResultLabel.setText(ERROR_MESSAGE);
            final Timer timer = new Timer(500, new ActionListener(){

                @Override
                public synchronized void actionPerformed(ActionEvent e) {
                    final Timer tmr = (Timer)e.getSource();
                    Thread thread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean valid = true;
                            try {
                                Evaluator evaluator = new Evaluator();
                                evaluator.compile(CodeAssistFactory.this.codeAssist.getTextPane().getText(), contextClass);
                            }
                            catch (Throwable e) {
                                try {
                                    valid = false;
                                }
                                catch (Throwable throwable) {
                                    CodeAssistFactory.this.validationResultLabel.setVisible(!valid);
                                    tmr.stop();
                                    throw throwable;
                                }
                                CodeAssistFactory.this.validationResultLabel.setVisible(!valid);
                                tmr.stop();
                            }
                            CodeAssistFactory.this.validationResultLabel.setVisible(!valid);
                            tmr.stop();
                        }
                    });
                    thread.run();
                }
            });
            this.getTextPane().getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    timer.restart();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
            timer.start();
        }
        return this.validationResultLabel;
    }

    private FavoritesManagerPanel getFavoritesPanel() {
        if (this.favoritesPanel == null) {
            this.favoritesPanel = new FavoritesManagerPanel(favoritesHelper, this.ACCEPT_FAVORITES_ACTION, this.CANCEL_FAVORITES_ACTION);
        }
        return this.favoritesPanel;
    }

    private FunctionSelectorPanel getFunctionsPanel() {
        if (this.functionsPanel == null) {
            this.functionsPanel = new FunctionSelectorPanel(favoritesHelper, this.ACCEPT_FUNCTION_ACTION, this.CANCEL_FUNCTION_ACTION);
        }
        return this.functionsPanel;
    }

    private MacroManagerPanel getMacrosPanel() {
        if (this.macrosPanel == null) {
            this.macrosPanel = new MacroManagerPanel(macrosHelper, this.ACCEPT_MACROS_ACTION, this.CANCEL_MACROS_ACTION);
        }
        return this.macrosPanel;
    }

    private JDialog getMacrosDialog() {
        if (this.macrosDialog == null) {
            Window ancestor = SwingUtilities.getWindowAncestor(this.codeAssist.getTextPane());
            this.macrosDialog = ancestor instanceof Frame ? new JDialog((Frame)ancestor, true) : (ancestor instanceof Dialog ? new JDialog((Dialog)ancestor, true) : new JDialog());
            this.macrosDialog.setTitle(MACROS_DIALOG_TITLE);
            this.macrosDialog.setContentPane(this.getMacrosPanel());
        }
        return this.macrosDialog;
    }

    private JDialog getFavoritesDialog() {
        if (this.favoritesDialog == null) {
            Window ancestor = SwingUtilities.getWindowAncestor(this.codeAssist.getTextPane());
            this.favoritesDialog = ancestor instanceof Frame ? new JDialog((Frame)ancestor, true) : (ancestor instanceof Dialog ? new JDialog((Dialog)ancestor, true) : new JDialog());
            this.favoritesDialog.setTitle(FAVORITES_DIALOG_TITLE);
            this.favoritesDialog.setContentPane(this.getFavoritesPanel());
        }
        return this.favoritesDialog;
    }

    private JDialog getFunctionsDialog() {
        if (this.functionsDialog == null) {
            Window ancestor = SwingUtilities.getWindowAncestor(this.codeAssist.getTextPane());
            this.functionsDialog = ancestor instanceof Frame ? new JDialog((Frame)ancestor, true) : (ancestor instanceof Dialog ? new JDialog((Dialog)ancestor, true) : new JDialog());
            this.functionsDialog.setTitle(FUNCTIONS_DIALOG_TITLE);
            this.functionsDialog.setContentPane(this.getFunctionsPanel());
        }
        return this.functionsDialog;
    }

    private void updateMacrosCompletion() {
        ArrayList<Completable> macroList = new ArrayList<Completable>();
        Iterator<Completable> it = this.codeAssist.getDataProvider().getItemIterator();
        while (it.hasNext()) {
            Completable item = it.next();
            if (item.getType() != Completable.CompletableType.USER_DEFINED || !(item instanceof UserDefinedCompletable)) continue;
            macroList.add(item);
        }
        for (Completable completable : macroList) {
            this.codeAssist.getDataProvider().removeItem(completable);
        }
        it = macrosHelper.getMacros().iterator();
        while (it.hasNext()) {
            this.codeAssist.getDataProvider().addItem(it.next());
        }
    }

    private void updateFavoritesCombo() {
        List<Completable> list = favoritesHelper.getFavorites();
        ((DefaultComboBoxModel)this.getFavoritesComboBox().getModel()).removeAllElements();
        if (list.size() == 0) {
            this.getFavoritesComboBox().addItem("Manage favorites...");
        } else {
            this.getFavoritesComboBox().addItem("Pick a favorite...");
            Iterator<Completable> it = list.iterator();
            while (it.hasNext()) {
                this.getFavoritesComboBox().addItem(it.next());
            }
        }
    }

    public void showManageFavoritesDialog() {
        this.getFavoritesPanel().updateFunctions(this.codeAssist.getDataProvider());
        this.getFavoritesPanel().updateFavorites();
        this.getFavoritesDialog().setSize(600, 500);
        this.getFavoritesDialog().setLocationRelativeTo(null);
        this.getFavoritesDialog().setVisible(true);
    }

    public void showManageMacrosDialog() {
        this.getMacrosPanel().updateMacros();
        this.getMacrosDialog().pack();
        this.getMacrosDialog().setLocationRelativeTo(null);
        this.getMacrosDialog().setVisible(true);
    }

    public void showInsertFunctionDialog() {
        this.getFunctionsPanel().updateFunctions(this.codeAssist.getDataProvider());
        this.getFunctionsPanel().reset();
        this.getFunctionsDialog().pack();
        this.getFunctionsDialog().setLocationRelativeTo(null);
        this.getFunctionsDialog().setVisible(true);
    }

    public void saveAsMacro() {
        this.getMacrosPanel().updateMacros();
        this.getMacrosPanel().saveAsMacro(this.codeAssist.getTextPane().getSelectedText());
        this.getMacrosDialog().pack();
        this.getMacrosDialog().setLocationRelativeTo(null);
        this.getMacrosDialog().setVisible(true);
    }

    public void insertText(String text) {
        JTextPane textPane = this.codeAssist.getTextPane();
        if (textPane.getSelectionEnd() - textPane.getSelectionStart() > 0) {
            try {
                textPane.getDocument().remove(textPane.getSelectionStart(), textPane.getSelectionEnd() - textPane.getSelectionStart());
            }
            catch (BadLocationException e1) {
                // empty catch block
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (textPane.getCaretPosition() > 0 && !Character.isWhitespace(textPane.getText().charAt(textPane.getCaretPosition() - 1))) {
            buffer.append(" ");
        }
        buffer.append(text);
        if (textPane.getCaretPosition() < textPane.getText().length() - 1 && !Character.isWhitespace(textPane.getText().charAt(textPane.getCaretPosition()))) {
            buffer.append(" ");
        }
        try {
            textPane.getDocument().insertString(textPane.getCaretPosition(), buffer.toString(), null);
        }
        catch (BadLocationException e1) {
            // empty catch block
        }
    }

    static {
        iconMap.put(ERROR, new ImageIcon(CodeAssist.class.getResource("images/error16.gif")));
    }

    private static class ToolBarActionConfigurer
    implements Configurer {
        private CodeAssistFactory instance = null;

        public ToolBarActionConfigurer(CodeAssistFactory instance) {
            this.instance = instance;
        }

        @Override
        public void configure(Object action) {
            if (action instanceof CodeAssistAction) {
                ((Action)action).putValue(CodeAssistFactory.PROPERTY_KEY_FACTORY_INSTANCE, this.instance);
            }
        }
    }

    public static class CodeAssistConfiguration {
        private String prefix = null;
        private String helpText = "Type your Chemical Terms here.\nPress <ctrl> and <space> to get a list of available commands.";
        private boolean autoPopup = false;
        private String toolbarConfigPath = "chemaxon/marvin/util/codeassist/toolbar/DefaultToolbarConfiguration.xml";
        private boolean expertMode = false;
        private CodeAssistDataProvider.Context context = CodeAssistDataProvider.Context.MOLECULE;
        private boolean addServices = true;

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setHelpText(String helpText) {
            this.helpText = helpText;
        }

        public String getHelpText() {
            return this.helpText;
        }

        public void setAutoPopup(boolean autoPopup) {
            this.autoPopup = autoPopup;
        }

        public boolean isAutoPopup() {
            return this.autoPopup;
        }

        public void setToolbarConfigPath(String toolbarConfigPath) {
            this.toolbarConfigPath = toolbarConfigPath;
        }

        public String getToolbarConfigPath() {
            return this.toolbarConfigPath;
        }

        public void setExpertMode(boolean expertMode) {
            this.expertMode = expertMode;
        }

        public boolean isExpertMode() {
            return this.expertMode;
        }

        public void setContext(CodeAssistDataProvider.Context context) {
            this.context = context;
        }

        public CodeAssistDataProvider.Context getContext() {
            return this.context;
        }

        public void setAddServices(boolean addServices) {
            this.addServices = addServices;
        }

        public boolean isAddServices() {
            return this.addServices;
        }
    }
}

