/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.CompletableFactory;
import chemaxon.marvin.util.codeassist.UserDefinedCompletable;
import chemaxon.util.DotfileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class CodeAssistMacrosHelper {
    private static final String MACROS_PATH = DotfileUtil.getDotFile("/alchemist/.chemterm_macros").getAbsolutePath();
    private List<Completable> macros = new LinkedList<Completable>();

    CodeAssistMacrosHelper() {
        this.readMacros();
    }

    public List<Completable> getMacros() {
        ArrayList<Completable> list = new ArrayList<Completable>();
        Iterator<Completable> it = this.macros.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return Collections.unmodifiableList(list);
    }

    public void addToMacros(Completable item) {
        this.macros.add(item);
    }

    public void removeFromMacros(Completable item) {
        this.macros.remove(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMacros() {
        Writer writer = null;
        try {
            File file = new File(MACROS_PATH);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            writer = new FileWriter(file);
            for (Completable item : this.macros) {
                if (!(item instanceof UserDefinedCompletable)) continue;
                String name = item.getName();
                name = name.replaceAll("(\r\n|\r|\n|\n\r)", "\\\\n");
                name = name.replaceAll("\t", "\\\\t");
                StringBuffer buffer = new StringBuffer(name);
                buffer.append("\t");
                String macro = ((UserDefinedCompletable)item).getMacro();
                macro = macro.replaceAll("(\r\n|\r|\n|\n\r)", "\\\\n");
                macro = macro.replaceAll("\t", "\\\\t");
                buffer.append(macro);
                buffer.append("\t");
                String desc = item.getDescription();
                desc = desc.replaceAll("(\r\n|\r|\n|\n\r)", "\\\\n");
                desc = desc.replaceAll("\t", "\\\\t");
                buffer.append(desc);
                buffer.append("\n");
                writer.write(buffer.toString());
            }
        }
        catch (IOException e) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMacros() {
        this.macros.clear();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(MACROS_PATH));
            String line = reader.readLine();
            while (line != null) {
                Completable item = CompletableFactory.parseAsMacro(line);
                if (item != null) {
                    this.macros.add(item);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

