/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.marvin.util.codeassist.CodeAssistFactory;
import chemaxon.marvin.util.codeassist.CodeAssistMacrosHelper;
import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.CompletableDisplayHelper;
import chemaxon.marvin.util.codeassist.CompletionItemCellRenderer;
import chemaxon.marvin.util.codeassist.UserDefinedCompletable;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MacroManagerPanel
extends JPanel {
    private static final long serialVersionUID = -4703035835623320688L;
    private static final String EMPTY_MACROS = "You have no macros saved yet.\nTo create a macro, click\nthe Add button in the right.";
    private static final String EMPTY_DESCRIPTION = "Type the description of your macro here.\nYou may use simple html tags such as <b>bold</b> for formatting,\nas this description will appear on tooltip.";
    private static final String EMPTY_MACRONAME = "Type the name of the macro. This should be a single word.";
    private static final String LIST_PANEL = "listPanel";
    private static final String EDIT_PANEL = "editPanel";
    private JScrollPane macroListScroll;
    private JList macroList;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JPanel listPanel;
    private JPanel editPanel;
    private CardLayout layout = new CardLayout();
    private JButton acceptButton;
    private JButton cancelButton;
    private JTextField nameField;
    private JScrollPane descScrollPane;
    private JScrollPane macroScrollPane;
    private JTextPane macroPane;
    private JTextPane descPane;
    private JButton acceptEditButton;
    private JButton cancelEditButton;
    private int editedItem = -1;
    private final CodeAssistMacrosHelper helper;
    private Action ACCEPT_ACTION;
    private Action CANCEL_ACTION;

    public MacroManagerPanel(CodeAssistMacrosHelper helper, Action acceptAction, Action cancelAction) {
        this.helper = helper;
        this.ACCEPT_ACTION = acceptAction;
        this.CANCEL_ACTION = cancelAction;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(this.layout);
        this.add((Component)this.getListPanel(), LIST_PANEL);
        this.add((Component)this.getEditPanel(), EDIT_PANEL);
        this.layout.show(this, LIST_PANEL);
        this.setPreferredSize(new Dimension(400, 400));
        this.updateActionStates();
    }

    private void updateActionStates() {
        this.getEditButton().setEnabled(this.macroList.getSelectedIndex() != -1);
        this.getDeleteButton().setEnabled(this.macroList.getSelectedIndex() != -1);
    }

    private JPanel getListPanel() {
        if (this.listPanel == null) {
            this.listPanel = new JPanel();
            FormLayout layout = new FormLayout("4dlu, fill:pref:grow, pref, 2dlu, pref, 4dlu", "4dlu, pref, 2dlu, pref, 2dlu, pref, fill:pref:grow, 2dlu, pref, 4dlu");
            CellConstraints cc = new CellConstraints();
            layout.setColumnGroups((int[][])new int[][]{{3, 5}});
            layout.setRowGroups((int[][])new int[][]{{2, 4, 6, 9}});
            this.listPanel.setLayout((LayoutManager)layout);
            this.listPanel.add((Component)this.getMacroListScroll(), cc.xywh(2, 2, 2, 6));
            this.listPanel.add((Component)this.getAddButton(), cc.xy(5, 2));
            this.listPanel.add((Component)this.getEditButton(), cc.xy(5, 4));
            this.listPanel.add((Component)this.getDeleteButton(), cc.xy(5, 6));
            this.listPanel.add((Component)this.getAcceptButton(), cc.xy(3, 9));
            this.listPanel.add((Component)this.getCancelButton(), cc.xy(5, 9));
        }
        return this.listPanel;
    }

    private JScrollPane getMacroListScroll() {
        if (this.macroListScroll == null) {
            this.macroListScroll = new JScrollPane();
            this.macroListScroll.setHorizontalScrollBarPolicy(31);
            this.macroListScroll.setVerticalScrollBarPolicy(22);
            this.macroListScroll.setViewportView(this.getMacroList());
        }
        return this.macroListScroll;
    }

    private JList getMacroList() {
        if (this.macroList == null) {
            this.macroList = new JList(new DefaultListModel()){
                private static final long serialVersionUID = -8825589735519311997L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (MacroManagerPanel.this.macroList.getModel().getSize() == 0) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.GRAY);
                        String[] text = MacroManagerPanel.EMPTY_MACROS.split("\n");
                        float height = this.getFontMetrics(this.getFont()).getLineMetrics(MacroManagerPanel.EMPTY_MACROS, g2).getHeight() + 5.0f;
                        float top = ((float)this.getHeight() - (float)text.length * height) / 2.0f;
                        for (int i = 0; i < text.length; ++i) {
                            float left = (this.getWidth() - this.getFontMetrics(this.getFont()).stringWidth(text[i])) / 2;
                            g2.drawString(text[i], left, top + (float)i * height);
                        }
                        g2.dispose();
                    }
                }

                @Override
                public String getToolTipText(MouseEvent event) {
                    int index = this.locationToIndex(event.getPoint());
                    if (index > -1) {
                        return "<html>" + ((Completable)this.getModel().getElementAt(index)).getDescription() + "</html>";
                    }
                    return null;
                }
            };
            this.macroList.setCellRenderer(new CompletionItemCellRenderer());
            this.macroList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    MacroManagerPanel.this.updateActionStates();
                }
            });
        }
        return this.macroList;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = 175247414705527463L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacroManagerPanel.this.editedItem = -1;
                    MacroManagerPanel.this.getNameField().setText("");
                    MacroManagerPanel.this.getDescPane().setText("");
                    MacroManagerPanel.this.getMacroPane().setText("");
                    MacroManagerPanel.this.layout.show(MacroManagerPanel.this, MacroManagerPanel.EDIT_PANEL);
                }
            });
            this.addButton.setText("Add");
        }
        return this.addButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = 3914369514939054878L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacroManagerPanel.this.editedItem = MacroManagerPanel.this.getMacroList().getSelectedIndex();
                    UserDefinedCompletable item = (UserDefinedCompletable)MacroManagerPanel.this.getMacroList().getSelectedValue();
                    MacroManagerPanel.this.getNameField().setText(item.getName());
                    MacroManagerPanel.this.getDescPane().setText(item.getDescription());
                    MacroManagerPanel.this.getMacroPane().setText(item.getMacro());
                    MacroManagerPanel.this.layout.show(MacroManagerPanel.this, MacroManagerPanel.EDIT_PANEL);
                }
            });
            this.editButton.setText("Edit");
        }
        return this.editButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = 175247414705527463L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JOptionPane.showConfirmDialog(MacroManagerPanel.this, "Delete selected macro?", "Delete macro", 0) == 0) {
                        MacroManagerPanel.this.helper.removeFromMacros((Completable)MacroManagerPanel.this.getMacroList().getSelectedValue());
                        ((DefaultListModel)MacroManagerPanel.this.getMacroList().getModel()).removeElement(MacroManagerPanel.this.getMacroList().getSelectedValue());
                    }
                }
            });
            this.deleteButton.setText("Delete");
        }
        return this.deleteButton;
    }

    private JButton getAcceptButton() {
        if (this.acceptButton == null) {
            this.acceptButton = new JButton(this.ACCEPT_ACTION);
            this.acceptButton.setText("Ok");
        }
        return this.acceptButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(this.CANCEL_ACTION);
            this.cancelButton.setText("Cancel");
        }
        return this.cancelButton;
    }

    private JPanel getEditPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel();
            FormLayout layout = new FormLayout("4dlu, fill:pref:grow, pref, 2dlu, pref, 4dlu", "4dlu, pref, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 2dlu, pref, 4dlu");
            CellConstraints cc = new CellConstraints();
            this.editPanel.setLayout((LayoutManager)layout);
            this.editPanel.add((Component)this.getNameField(), cc.xywh(2, 2, 4, 1));
            this.editPanel.add((Component)this.getDescScrollPane(), cc.xywh(2, 4, 4, 1));
            this.editPanel.add((Component)this.getMacroScrollPane(), cc.xywh(2, 6, 4, 1));
            this.editPanel.add((Component)this.getAcceptEditButton(), cc.xy(3, 8));
            this.editPanel.add((Component)this.getCancelEditButton(), cc.xy(5, 8));
        }
        return this.editPanel;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = CompletableDisplayHelper.createTipOnEmptyTextField(EMPTY_MACRONAME);
        }
        return this.nameField;
    }

    private JScrollPane getDescScrollPane() {
        if (this.descScrollPane == null) {
            this.descScrollPane = new JScrollPane();
            this.descScrollPane.setViewportView(this.getDescPane());
        }
        return this.descScrollPane;
    }

    private JTextPane getDescPane() {
        if (this.descPane == null) {
            this.descPane = new JTextPane(){
                private static final long serialVersionUID = -8411646873912006402L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (MacroManagerPanel.this.descPane.getText().length() == 0) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.GRAY);
                        String[] text = MacroManagerPanel.EMPTY_DESCRIPTION.split("\n");
                        float height = this.getFontMetrics(this.getFont()).getLineMetrics(MacroManagerPanel.EMPTY_DESCRIPTION, g2).getHeight() + 5.0f;
                        float top = ((float)this.getHeight() - (float)text.length * height) / 2.0f;
                        for (int i = 0; i < text.length; ++i) {
                            float left = (this.getWidth() - this.getFontMetrics(this.getFont()).stringWidth(text[i])) / 2;
                            g2.drawString(text[i], left, top + (float)i * height);
                        }
                        g2.dispose();
                    }
                }
            };
            this.descPane.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    MacroManagerPanel.this.descPane.repaint();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    MacroManagerPanel.this.descPane.repaint();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    MacroManagerPanel.this.descPane.repaint();
                }
            });
        }
        return this.descPane;
    }

    private JScrollPane getMacroScrollPane() {
        if (this.macroScrollPane == null) {
            this.macroScrollPane = new JScrollPane();
            this.macroScrollPane.setViewportView(this.getMacroPane());
        }
        return this.macroScrollPane;
    }

    private JTextPane getMacroPane() {
        if (this.macroPane == null) {
            this.macroPane = CodeAssistFactory.createChemicalTermsTextPane();
        }
        return this.macroPane;
    }

    private JButton getAcceptEditButton() {
        if (this.acceptEditButton == null) {
            this.acceptEditButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = -7322462692910181268L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDefinedCompletable newCompletable = new UserDefinedCompletable(MacroManagerPanel.this.getNameField().getText(), MacroManagerPanel.this.getMacroPane().getText(), MacroManagerPanel.this.getDescPane().getText());
                    if (MacroManagerPanel.this.editedItem == -1) {
                        MacroManagerPanel.this.helper.addToMacros(newCompletable);
                        ((DefaultListModel)MacroManagerPanel.this.getMacroList().getModel()).addElement(newCompletable);
                    } else {
                        MacroManagerPanel.this.helper.removeFromMacros((Completable)MacroManagerPanel.this.getMacroList().getSelectedValue());
                        MacroManagerPanel.this.helper.addToMacros(newCompletable);
                        ((DefaultListModel)MacroManagerPanel.this.getMacroList().getModel()).set(MacroManagerPanel.this.editedItem, newCompletable);
                    }
                    MacroManagerPanel.this.layout.show(MacroManagerPanel.this, MacroManagerPanel.LIST_PANEL);
                    MacroManagerPanel.this.sortList();
                }
            });
            this.acceptEditButton.setText("Save");
        }
        return this.acceptEditButton;
    }

    private JButton getCancelEditButton() {
        if (this.cancelEditButton == null) {
            this.cancelEditButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = -7322462692910181268L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacroManagerPanel.this.layout.show(MacroManagerPanel.this, MacroManagerPanel.LIST_PANEL);
                }
            });
            this.cancelEditButton.setText("Cancel");
        }
        return this.cancelEditButton;
    }

    private void sortList() {
        int i;
        Object selected = this.getMacroList().getSelectedValue();
        Object[] items = new Object[this.getMacroList().getModel().getSize()];
        for (i = 0; i < items.length; ++i) {
            items[i] = this.getMacroList().getModel().getElementAt(i);
        }
        Arrays.sort(items);
        ((DefaultListModel)this.getMacroList().getModel()).removeAllElements();
        for (i = 0; i < items.length; ++i) {
            ((DefaultListModel)this.getMacroList().getModel()).addElement(items[i]);
        }
        this.getMacroList().setSelectedValue(selected, true);
    }

    public void updateMacros() {
        ((DefaultListModel)this.getMacroList().getModel()).clear();
        List<Completable> list = this.helper.getMacros();
        Iterator<Completable> it = list.iterator();
        while (it.hasNext()) {
            ((DefaultListModel)this.getMacroList().getModel()).addElement(it.next());
        }
    }

    public void saveAsMacro(String macro) {
        this.editedItem = -1;
        this.getNameField().setText("");
        this.getDescPane().setText("");
        this.getMacroPane().setText(macro);
        this.layout.show(this, EDIT_PANEL);
    }
}

