/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.jep.UserParam;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class ParamSetWalker
implements Iterator<UserParam[]> {
    private final List<List<String>> params;
    private final UserParam[] userParams;
    private int[] indexes;
    private boolean endReached;

    public ParamSetWalker(UserParam[] userParams) {
        this.userParams = userParams;
        this.params = new ArrayList<List<String>>();
        this.indexes = new int[userParams.length];
        for (int i = 0; i < userParams.length; ++i) {
            String[] p = userParams[i].getType().split("/");
            this.params.add(new ArrayList());
            for (int j = 0; j < p.length; ++j) {
                this.params.get(i).add(p[j]);
            }
            this.indexes[i] = 0;
        }
        this.endReached = false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return !this.endReached;
    }

    private void inc(int index) {
        if (index < this.indexes.length) {
            if (this.indexes[index] + 1 < this.params.get(index).size()) {
                int n = index;
                this.indexes[n] = this.indexes[n] + 1;
            } else {
                this.indexes[index] = 0;
                this.inc(index + 1);
            }
        } else {
            this.endReached = true;
        }
    }

    @Override
    public UserParam[] next() {
        if (this.endReached) {
            throw new NoSuchElementException();
        }
        UserParam[] paramSet = new UserParam[this.params.size()];
        for (int i = 0; i < paramSet.length; ++i) {
            paramSet[i] = new UserParam(this.userParams[i].getName(), this.params.get(i).get(this.indexes[i]), this.userParams[i].isMandatory(), this.userParams[i].isMultiple(), this.userParams[i].getDefaultValue());
        }
        this.inc(0);
        return paramSet;
    }
}

