/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist.toolbar;

import java.util.Vector;
import javax.swing.AbstractListModel;

public abstract class AbstractFilterListModel
extends AbstractListModel {
    private static final long serialVersionUID = -6551880309445711529L;
    protected Vector<Object> vector = new Vector();
    protected Vector<Object> filteredVector = new Vector();

    public void addElement(Object element) {
        this.vector.add(element);
        if (this.filter(element)) {
            int index = this.filteredVector.size();
            this.filteredVector.add(element);
            this.fireIntervalAdded(this, index, index);
        }
    }

    @Override
    public Object getElementAt(int index) {
        if (index < this.filteredVector.size() && index >= 0) {
            return this.filteredVector.get(index);
        }
        return null;
    }

    public Object getUnfilteredElementAt(int index) {
        if (index < this.vector.size() && index >= 0) {
            return this.vector.get(index);
        }
        return null;
    }

    public boolean removeElement(Object element) {
        int index = this.filteredVector.indexOf(element);
        this.filteredVector.remove(element);
        this.fireIntervalRemoved(this, index, index);
        return this.vector.remove(element);
    }

    public Object removeElement(int index) {
        if (index < this.filteredVector.size() && index >= 0) {
            Object obj = this.filteredVector.remove(index);
            this.fireIntervalRemoved(this, index, index);
            if (obj != null) {
                this.vector.remove(obj);
            }
            return obj;
        }
        return null;
    }

    public void removeAllElements() {
        int length = this.filteredVector.size();
        this.vector.removeAllElements();
        if (length > 0) {
            this.filteredVector.removeAllElements();
            this.fireIntervalRemoved(this, 0, length - 1);
        }
    }

    @Override
    public int getSize() {
        return this.filteredVector.size();
    }

    public void filter() {
        int index = this.filteredVector.size();
        this.filteredVector.clear();
        this.fireIntervalRemoved(this, 0, index);
        for (Object element : this.vector) {
            if (!this.filter(element)) continue;
            this.filteredVector.add(element);
        }
        this.fireIntervalAdded(this, 0, this.filteredVector.size());
    }

    public void clear() {
        int index = this.filteredVector.size();
        this.vector.clear();
        this.filteredVector.clear();
        this.fireIntervalRemoved(this, 0, index);
    }

    public int getUnfilteredIndexOf(Object elem) {
        return this.vector.indexOf(elem);
    }

    public int getFilteredIndexOf(Object elem) {
        return this.filteredVector.indexOf(elem);
    }

    protected abstract boolean filter(Object var1);
}

