/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist.toolbar;

import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.CompletableFactory;
import chemaxon.marvin.util.codeassist.UserDefinedCompletable;
import chemaxon.util.DotfileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CodeAssistFavoritesHelper {
    private static final String FAVORITES_PATH = DotfileUtil.getDotFile("/alchemist/.chemterm_favorites").getAbsolutePath();
    private List<Completable> favorites = new LinkedList<Completable>();

    public CodeAssistFavoritesHelper() {
        this.readFavorites();
    }

    public List<Completable> getFavorites() {
        ArrayList<Completable> list = new ArrayList<Completable>();
        Iterator<Completable> it = this.favorites.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return Collections.unmodifiableList(list);
    }

    public void addToFavorites(Completable item) {
        this.favorites.add(item);
    }

    public void removeFromFavorites(Completable item) {
        this.favorites.remove(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFavorites() {
        Writer writer = null;
        try {
            File file = new File(FAVORITES_PATH);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            writer = new FileWriter(file);
            for (Completable item : this.favorites) {
                String name = item.toString();
                name = name.replaceAll("(\r\n|\r|\n|\n\r)", "\\\\n");
                name = name.replaceAll("\t", "\\\\t");
                StringBuffer buffer = new StringBuffer(name);
                if (item.getType() == Completable.CompletableType.PLUG_IN) {
                    buffer.append("\tplugin");
                } else if (item.getType() == Completable.CompletableType.USER_DEFINED) {
                    buffer.append("\tuserdefined");
                    buffer.append("\t");
                    String desc = item instanceof UserDefinedCompletable ? ((UserDefinedCompletable)item).getMacro() : item.getDescription();
                    desc = desc.replaceAll("(\r\n|\r|\n|\n\r)", "\\\\n");
                    desc = desc.replaceAll("\t", "\\\\t");
                    buffer.append(desc);
                } else {
                    buffer.append("\tfunction");
                }
                buffer.append("\n");
                writer.write(buffer.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFavorites() {
        this.favorites.clear();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(FAVORITES_PATH));
            String line = reader.readLine();
            while (line != null) {
                Completable item = null;
                String[] data = line.split("\t");
                if (data.length > 1) {
                    if (data[1].equalsIgnoreCase("plugin")) {
                        item = CompletableFactory.parseAsPlugIn(data[0]);
                    } else if (data[1].equalsIgnoreCase("function")) {
                        item = CompletableFactory.parseAsFunction(data[0]);
                    } else if (data[1].equalsIgnoreCase("userdefined") && data.length > 2) {
                        String macro = data[0] + "\t" + data[2] + "\t ";
                        item = CompletableFactory.parseAsMacro(macro);
                    }
                } else {
                    item = CompletableFactory.parseAsPlugIn(data[0]);
                }
                if (item != null) {
                    this.favorites.add(item);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

