/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.text;

import chemaxon.marvin.io.Encoding;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.StringTokenizer;

public final class EncodingUtil {
    public static final int ESC_NL = 1;
    public static final int ESC_COMMA = 2;
    public static final int XML_NAME = 0;
    public static final int XML_TEXT = 1;
    public static final int XML_ATTR = 2;
    private static final String[] XML_NAME_CODES = new String[256];
    private static final String[] XML_ATTR_CODES;
    private static final String[] XML_TEXT_CODES;

    public static Encoding getEncoding(byte[] buf, int off, int len) {
        Encoding encoding = Encoding.recognize(buf, off, len);
        if (encoding != null) {
            return encoding;
        }
        try {
            String str = new String(buf, off, len, "US-ASCII");
            String enc = EncodingUtil.getEncoding(str);
            if (enc != null) {
                return Encoding.forName(enc);
            }
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        return null;
    }

    public static String getEncoding(String str) {
        StringTokenizer st;
        int i;
        if ((str = str.trim()).startsWith("<?xml ") && (i = str.indexOf("?>")) >= 0 && (i = (str = str.substring(0, i)).indexOf("encoding=")) >= 0 && (st = new StringTokenizer(str.substring(i + 9), "\"' \t\n\r")).hasMoreTokens()) {
            String name = st.nextToken();
            try {
                return Encoding.canonicalName(name);
            }
            catch (IllegalCharsetNameException ex) {
            }
            catch (UnsupportedCharsetException ex) {
                // empty catch block
            }
            return name;
        }
        return null;
    }

    public static byte[] getBytes(String str) throws UnsupportedEncodingException {
        String enc = EncodingUtil.getEncoding(str);
        return enc == null ? str.getBytes() : str.getBytes(enc);
    }

    public static String escape(String text, int opts) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if ((c == '\n' || c == '\r') && (opts & 1) != 0) {
                sb.append(c == '\n' ? "\\n" : "\\r");
                continue;
            }
            if (c == ',' && (opts & 2) != 0) {
                sb.append("\\,");
                continue;
            }
            if (c != (c & 0x7F)) {
                sb.append("\\u");
                String s = "000" + Integer.toString(c, 16);
                sb.append(s.substring(s.length() - 4));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescape(String text) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c0 = text.charAt(i);
            if (c0 == '\\' && i + 1 < text.length()) {
                char c1 = text.charAt(i + 1);
                if (c1 == '\\') {
                    sb.append('\\');
                    ++i;
                    continue;
                }
                if (c1 == 'n') {
                    sb.append('\n');
                    ++i;
                    continue;
                }
                if (c1 == 'r') {
                    sb.append('\r');
                    ++i;
                    continue;
                }
                if (c1 == 'u' && i + 2 <= text.length() - 4) {
                    String s = text.substring(i + 2, i + 6);
                    try {
                        int hex = Integer.parseInt(s, 16);
                        sb.append((char)hex);
                        i += 5;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                    }
                } else if (c1 == ',') {
                    sb.append(',');
                    ++i;
                    continue;
                }
            }
            sb.append(c0);
        }
        return sb.toString();
    }

    public static String decodeJs(String s) {
        if (s == null || !s.startsWith("@javascript")) {
            return s;
        }
        if (s.startsWith("@javascript-escape-encoded@")) {
            return EncodingUtil.unescapeJs(s);
        }
        if (s.startsWith("@javascript-URI-encoded@")) {
            try {
                String ss = s.substring(24);
                return URLDecoder.decode(ss, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return s;
            }
        }
        return s;
    }

    public static String unescapeJs(String s) {
        if (s == null || !s.startsWith("@javascript-escape-encoded@")) {
            return s;
        }
        s = s.substring(27);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                }
                catch (NumberFormatException e) {
                    return null;
                }
                i += 2;
                continue;
            }
            sb.append(c);
        }
        String result = sb.toString();
        return result;
    }

    public static String escapeXML(String s, int type) {
        StringBuffer sb = new StringBuffer();
        String[] codes = XML_TEXT_CODES;
        if (type == 0) {
            codes = XML_NAME_CODES;
        } else if (type == 2) {
            codes = XML_ATTR_CODES;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u0000' && c < codes.length) {
                sb.append(codes[c]);
                continue;
            }
            sb.append("&#" + Integer.toString(c) + ";");
        }
        return sb.toString();
    }

    public static String findLineSeparator(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char cc;
            char c = s.charAt(i);
            if (c != '\r' && c != '\n') continue;
            if (i < s.length() - 1 && ((cc = s.charAt(i + 1)) == '\r' || cc == '\n') && c != cc) {
                char[] eol = new char[]{c, cc};
                return new String(eol);
            }
            return Character.toString(c);
        }
        return "\n";
    }

    public static String eolToUnix(String s) {
        String eol = EncodingUtil.findLineSeparator(s);
        if (eol.length() == 1) {
            if (eol.equals("\n")) {
                return s;
            }
            return s.replace(eol.charAt(0), '\n');
        }
        char[] cc = eol.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length() - 1) {
            char c0 = s.charAt(i);
            char c1 = s.charAt(i + 1);
            if (cc[0] == c0 && cc[1] == c1) {
                sb.append('\n');
                i += 2;
                continue;
            }
            sb.append(c0);
            ++i;
        }
        if (i < s.length()) {
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    static {
        XML_TEXT_CODES = new String[256];
        XML_ATTR_CODES = new String[256];
        for (int c = 0; c < 256; ++c) {
            EncodingUtil.XML_ATTR_CODES[c] = c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || "!@#$%()[]{}.,:/\\?|-+*^_~= ".indexOf(c) >= 0 ? Character.toString((char)c) : "&#" + Integer.toString(c) + ";";
        }
        EncodingUtil.XML_TEXT_CODES[38] = "&amp;";
        EncodingUtil.XML_TEXT_CODES[60] = "&lt;";
        EncodingUtil.XML_TEXT_CODES[62] = "&gt;";
        EncodingUtil.XML_TEXT_CODES[34] = "&quot;";
        EncodingUtil.XML_TEXT_CODES[39] = "&apos;";
        System.arraycopy(XML_ATTR_CODES, 0, XML_NAME_CODES, 0, 256);
        System.arraycopy(XML_ATTR_CODES, 0, XML_TEXT_CODES, 0, 256);
        EncodingUtil.XML_TEXT_CODES[10] = "\n";
    }
}

