/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.text;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class MStringTokenizer {
    private String theString;
    private char separatorChar;
    private char escapeChar;
    private int positionInString;
    private int offset;
    private int tokenIndex;
    private List tokens;
    private boolean nocr;

    public MStringTokenizer(String s) {
        this(MStringTokenizer.getStringToTokenize(s), MStringTokenizer.getSeparatorChar(s), MStringTokenizer.getEscapeChar(s), MStringTokenizer.isEscapeSpecified(s) ? 3 : 1);
    }

    public MStringTokenizer(String str, char sep, char esc) {
        this(str, sep, esc, 0);
    }

    private MStringTokenizer(String str, char sep, char esc, int pos) {
        this.theString = str;
        this.separatorChar = sep;
        this.escapeChar = esc;
        this.positionInString = 0;
        this.offset = pos;
        this.tokenIndex = 0;
        this.tokens = new ArrayList();
        this.nocr = str.indexOf(13) == -1 && str.indexOf(10) == -1;
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char c) {
        this.escapeChar = c;
    }

    private static boolean isEscapeSpecified(String s) {
        return s.startsWith("E") && s.length() >= 3;
    }

    private static char getEscapeChar(String s) {
        return MStringTokenizer.isEscapeSpecified(s) ? s.charAt(1) : (char)'\u0000';
    }

    private static char getSeparatorChar(String s) {
        return s.length() == 0 ? (char)'\u0000' : s.charAt(MStringTokenizer.isEscapeSpecified(s) ? 2 : 0);
    }

    private static String getStringToTokenize(String s) {
        return s.length() == 0 ? "" : s.substring(MStringTokenizer.isEscapeSpecified(s) ? 3 : 1);
    }

    public static String[] convertToArray(String s) {
        return MStringTokenizer.convertToArray(MStringTokenizer.getStringToTokenize(s), MStringTokenizer.getSeparatorChar(s), MStringTokenizer.getEscapeChar(s));
    }

    public static String[] convertToArray(String s, char c, char esc) {
        MStringTokenizer st = new MStringTokenizer(s, c, esc);
        String[] arr = new String[st.countTokens()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = st.nextToken();
        }
        return arr;
    }

    public final boolean hasMoreTokens() {
        return this.positionInString < this.theString.length();
    }

    public final int countTokens() {
        String str = this.theString;
        int count = 1;
        for (int i = 0; i < str.length(); ++i) {
            char c1;
            char c0 = str.charAt(i);
            if (i < str.length() - 1 && this.escapeChar != '\u0000' && c0 == this.escapeChar && (c1 = str.charAt(i + 1)) == this.separatorChar) {
                ++i;
                continue;
            }
            if (c0 != this.separatorChar) continue;
            ++count;
        }
        return count;
    }

    public final int getPosition() {
        return this.offset + this.positionInString;
    }

    public final String nextToken() {
        return this.nextToken(0);
    }

    public final String nextToken(int n) {
        String token;
        int i;
        if (this.tokenIndex < this.tokens.size()) {
            return (String)this.tokens.get(this.tokenIndex++);
        }
        if (!this.hasMoreTokens()) {
            this.tokens.add(null);
            ++this.tokenIndex;
            return null;
        }
        String str = this.theString;
        int j = i = this.positionInString;
        for (int k = 0; k <= n; ++k) {
            j = i;
            if (this.escapeChar != '\u0000') {
                while (j < str.length()) {
                    char c0 = str.charAt(j);
                    if (c0 == this.escapeChar && j < str.length() - 1) {
                        char c1 = str.charAt(j + 1);
                        if (c1 == this.separatorChar) {
                            j += 2;
                            continue;
                        }
                        if (c1 == 'n') {
                            j += 2;
                            continue;
                        }
                    } else if (c0 == this.separatorChar) break;
                    ++j;
                }
            } else {
                j = str.indexOf(this.separatorChar, i);
                if (j == -1) {
                    j = str.length();
                }
            }
            i = j + 1;
        }
        int escapePos = str.indexOf(this.escapeChar, this.positionInString);
        if (this.escapeChar != '\u0000' && escapePos >= 0 && escapePos < j) {
            StringBuffer sb = new StringBuffer();
            for (i = this.positionInString; i < j; ++i) {
                char c = str.charAt(i);
                if (c == this.escapeChar && i < j - 1) {
                    char cc = str.charAt(i + 1);
                    if (cc == this.escapeChar || cc == this.separatorChar) {
                        sb.append(cc);
                        ++i;
                        continue;
                    }
                    if (cc == 'n') {
                        if (this.nocr) {
                            sb.append('\n');
                        }
                        ++i;
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                sb.append(c);
            }
            token = sb.toString();
        } else {
            token = str.substring(this.positionInString, j);
        }
        this.positionInString = j + 1;
        this.tokens.add(token);
        ++this.tokenIndex;
        return token;
    }

    public final void back() {
        if (this.tokenIndex > 0) {
            --this.tokenIndex;
        }
    }

    public final int nextInt() {
        String s = this.trimNextToken();
        return Integer.parseInt(s);
    }

    public final int nextIntDefault(int d) {
        String s = this.trimNextToken();
        return s != null && s.length() != 0 ? Integer.parseInt(s) : d;
    }

    public final String trimNextToken() {
        String s = this.nextToken();
        return s != null ? s.trim() : null;
    }

    public final String trimNextToken(String d) {
        String s = this.trimNextToken();
        return s != null && s.length() != 0 ? s : d;
    }

    public static String[] split(String str, char c) {
        MStringTokenizer mst = new MStringTokenizer(str, c, '\u0000');
        int n = mst.countTokens();
        String[] t = new String[n];
        for (int i = 0; i < n; ++i) {
            t[i] = mst.nextToken();
        }
        return t;
    }

    public static String[] getStringArrayRC(String key, ResourceBundle rc) {
        String s = rc.getString(key);
        MStringTokenizer st = new MStringTokenizer(s);
        String[] arr = new String[st.countTokens()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = st.nextToken();
        }
        return arr;
    }
}

