/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.version;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionInfo {
    public static String MARVIN_VERSION;
    public static String MARVIN_MAJOR_VERSION;
    public static String MARVIN_REVISION_NUMBER;
    private static final String build_date;
    private static final String buildTime;
    private static final String internalVersionId;
    private static final String versionFileName = "/chemaxon/marvin/version/version.properties";
    private static final String buildDateFileName = "/chemaxon/marvin/version/build_date.properties";
    public static final boolean IS_SUPPORTED_JAVA;

    public static String buildDate() {
        return build_date;
    }

    public static String getInternalVersionId() {
        return internalVersionId;
    }

    public static String buildDateTime() {
        return VersionInfo.buildDate() + " " + buildTime;
    }

    public static void main(String[] args) {
        if (args.length >= 1) {
            if (args[0].equals("-datetime")) {
                System.out.println(VersionInfo.buildDateTime());
                return;
            }
            if (args[0].equals("-rev")) {
                System.out.println(MARVIN_REVISION_NUMBER);
                return;
            }
            if (args[0].equals("-version")) {
                System.out.println(MARVIN_VERSION);
                return;
            }
            if (args[0].equals("-id")) {
                System.out.println(VersionInfo.getInternalVersionId());
                return;
            }
        }
        System.out.println("\nMarvin version: " + MARVIN_VERSION + " (build: " + VersionInfo.buildDate() + ", revision: " + MARVIN_REVISION_NUMBER + ", internal id: " + VersionInfo.getInternalVersionId() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        IS_SUPPORTED_JAVA = System.getProperty("java.version").compareTo("1.5") >= 0 && (System.getProperty("java.vendor").equals("Sun Microsystems Inc.") || System.getProperty("os.name").equals("Mac OS X") && System.getProperty("java.vendor").equals("Apple Computer, Inc."));
        String ver = null;
        String mver = null;
        String mveri = null;
        String revision = null;
        InputStream is = null;
        try {
            is = VersionInfo.class.getResourceAsStream(versionFileName);
            Properties p = new Properties();
            p.load(is);
            ver = p.getProperty("VERSION");
            mver = p.getProperty("MAJOR_VERSION");
            mveri = p.getProperty("VERSION_INTERNAL");
            revision = p.getProperty("revision");
        }
        catch (Throwable thw) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioex) {}
            }
        }
        if (ver == null) {
            ver = "unknown";
        }
        if (mver == null) {
            mver = "unknown";
        }
        if (mveri == null) {
            mveri = "unknown";
        }
        if (revision == null) {
            revision = "unknown";
        }
        MARVIN_VERSION = ver;
        MARVIN_MAJOR_VERSION = mver;
        internalVersionId = mveri;
        MARVIN_REVISION_NUMBER = revision;
        String bdate = null;
        String btime = null;
        is = null;
        try {
            is = VersionInfo.class.getResourceAsStream(buildDateFileName);
            Properties p = new Properties();
            p.load(is);
            bdate = p.getProperty("BUILD_DATE");
            btime = p.getProperty("BUILD_TIME");
        }
        catch (Throwable thw) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioex) {}
            }
        }
        if (bdate == null) {
            bdate = "unknown";
        }
        if (btime == null) {
            btime = "unknown";
        }
        build_date = bdate;
        buildTime = btime;
    }
}

