/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.core.util.BondTable;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.io.MFieldAccessor;
import chemaxon.marvin.io.fieldaccess.MoleculeFieldAccessor;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.util.PackedIntArray;
import chemaxon.marvin.view.StoredRecord;
import chemaxon.marvin.view.StoredRecordArray;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.prop.MMoleculeProp;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class MDocStorage {
    private static final int INITIAL_LENGTH = 10;
    private static final int F_SGCONTREXP = 1;
    private static final int F_HYDROGENIZE = 2;
    private static final int F_AROMATIZE = 4;
    private static final int F_CLEAN = 8;
    private int theSize;
    private boolean sizeIsFinal = true;
    private int[] accessQueue = null;
    private int accessQueuePointer = 0;
    private PackedIntArray idBackgroundRGBA = null;
    private PackedIntArray idForegroundRGBA = null;
    private StoredRecordArray storedRecords;
    private MDocSource docSource = null;
    private MFieldAccessor fieldAccessor = new MoleculeFieldAccessor();
    private int docSourceOffset = 0;
    private int docSourceMax = 0;
    private List<Listener> listeners;
    private int commandFlags = 0;
    private boolean contractExpandSwitch = true;
    private boolean hydrogenizeSwitch = true;
    private boolean aromatizeSwitch = true;
    private int aromatizeMethod = 0;
    private int cleanDimension = 2;
    private String cleanOptions = null;
    private Object cacheLock = new Object();

    public MDocStorage() {
        this(10);
        this.theSize = 0;
    }

    public MDocStorage(int n) {
        this.theSize = n;
        this.storedRecords = new StoredRecordArray(n);
    }

    public MDocSource getDocSource() {
        return this.docSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocSource(MDocSource dp, int offset, int max) {
        this.docSource = dp;
        int oldoffset = this.docSourceOffset;
        this.docSourceOffset = offset;
        this.docSourceMax = max;
        this.sizeIsFinal = dp == null;
        Object object = this.cacheLock;
        synchronized (object) {
            this.shiftArrays(offset - oldoffset);
        }
    }

    public MFieldAccessor getFieldAccessor() {
        return this.fieldAccessor;
    }

    public void setFieldAccessor(MFieldAccessor fa) {
        this.fieldAccessor = fa;
    }

    private void shiftArrays(int d) {
        block8: {
            block7: {
                if (d <= 0) break block7;
                int n = this.theSize - d;
                if (n > 0) {
                    this.storedRecords.moveElements(d, 0, n);
                }
                if (n >= 0) {
                    this.storedRecords.unsetElements(n, d);
                }
                for (int i = 0; i < this.accessQueue.length; ++i) {
                    int k = this.accessQueue[i] - 1;
                    if (k < 0) continue;
                    if ((k -= d) >= 0) {
                        this.accessQueue[i] = k + 1;
                        continue;
                    }
                    this.removeAccessQueueEntryOnly(i);
                    --i;
                }
                break block8;
            }
            if (d >= 0) break block8;
            int n = this.theSize - (d = -d);
            if (n > 0) {
                this.storedRecords.moveElements(0, d, n);
            }
            this.storedRecords.unsetElements(0, Math.min(d, this.theSize));
            for (int i = 0; i < this.accessQueue.length; ++i) {
                int k = this.accessQueue[i] - 1;
                if (k < 0) continue;
                if ((k += d) < this.theSize) {
                    this.accessQueue[i] = k + 1;
                    continue;
                }
                this.removeAccessQueueEntryOnly(i);
                --i;
            }
        }
    }

    public int getOffset() {
        return this.docSourceOffset;
    }

    public int getDocSourcePosition() {
        MDocSource dp = this.docSource;
        return dp != null ? dp.getRecordCount() : -1;
    }

    public void addListener(Listener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(Listener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public Listener[] getListeners() {
        if (this.listeners == null) {
            return null;
        }
        Listener[] arr = new Listener[this.listeners.size()];
        this.listeners.toArray(arr);
        return arr;
    }

    public void setListeners(Listener[] arr) {
        if (arr == null) {
            this.listeners = null;
        } else {
            this.listeners = new ArrayList<Listener>();
            for (int i = 0; i < arr.length; ++i) {
                this.listeners.add(arr[i]);
            }
        }
    }

    public int getSize() {
        return this.theSize;
    }

    public void setSize(int n) {
        this.ensureCapacity(n, true);
        this.setSize0(n);
    }

    public boolean isSizeFinal() {
        return this.sizeIsFinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSize0(int n) {
        int old = this.theSize;
        if (old == n) {
            return;
        }
        this.theSize = n;
        if (n < old) {
            Object object = this.cacheLock;
            synchronized (object) {
                this.storedRecords.unsetElements(n, old - n);
                if (this.accessQueue != null) {
                    for (int i = 0; i < this.accessQueue.length; ++i) {
                        int k = this.accessQueue[i] - 1;
                        if (k < n) continue;
                        this.removeAccessQueueEntryOnly(i);
                        --i;
                    }
                }
            }
        }
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener l = this.listeners.get(i);
                l.storageSizeChanged(this, old, n);
            }
        }
    }

    private void setFinalSize(int n) {
        int capacity = this.getCapacity();
        if (capacity < n || capacity > (3 * n + 1) / 2) {
            this.setCapacity(n);
        }
        if (this.getSize() != n) {
            this.setSize0(n);
        }
        if (this.storedRecords.size() != n) {
            this.storedRecords.setSize(n);
        }
        this.sizeIsFinal = true;
        for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
            Listener l = this.listeners.get(i);
            l.storageSizeFinalized(this);
        }
    }

    private int getCurrentSize() {
        return this.docSource.getRecordCountMax() - this.docSourceOffset;
    }

    private void setSizeAfterExtend() {
        int n = this.getCurrentSize();
        if (n >= 0) {
            this.ensureCapacity(n, true);
            this.setSize0(n);
        }
    }

    public int getCapacity() {
        return this.storedRecords.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCapacity(int n) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.storedRecords.setSize(n);
            if (this.accessQueue != null) {
                for (int i = 0; i < this.accessQueue.length; ++i) {
                    if (this.accessQueue[i] - 1 < n) continue;
                    this.removeAccessQueueEntryOnly(i);
                    --i;
                }
            }
        }
        if (this.theSize > n) {
            this.setSize0(n);
        }
    }

    private void ensureCapacity(int n, boolean more) {
        if (this.storedRecords.size() < n) {
            this.setCapacity(more ? (3 * n + 1) / 2 : n);
        }
    }

    public int getCacheCapacity() {
        int[] a = this.accessQueue;
        return a != null ? a.length : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheCapacity(int max) {
        if (this.getCacheCapacity() != max) {
            if (this.getCapacity() < max) {
                this.setCapacity(max);
            }
            Object object = this.cacheLock;
            synchronized (object) {
                if (max == 0) {
                    this.accessQueue = null;
                    this.accessQueuePointer = 0;
                    this.storedRecords.setSparse(false);
                } else if (this.accessQueue != null) {
                    int d = max - this.accessQueue.length;
                    if (d > 0) {
                        this.growCache(d);
                    } else if (d < 0) {
                        this.shrinkCache(-d);
                    }
                } else {
                    this.accessQueue = new int[max];
                    this.accessQueuePointer = 0;
                    this.storedRecords.setSparse(true);
                }
            }
        }
    }

    private void growCache(int d) {
        int max = this.accessQueue.length + d;
        int[] tmp = new int[max];
        System.arraycopy(this.accessQueue, 0, tmp, 0, this.accessQueuePointer);
        System.arraycopy(this.accessQueue, this.accessQueuePointer, tmp, this.accessQueuePointer + d, this.accessQueue.length - this.accessQueuePointer);
        this.accessQueue = tmp;
        Iterator<StoredRecord> it = this.storedRecords.iterator();
        while (it.hasNext()) {
            StoredRecord rec = it.next();
            int index = rec != null ? rec.getAccessQueueIndex() : 0;
            int j = index - 1;
            if (j < this.accessQueuePointer) continue;
            rec.setAccessQueueIndex(index + d);
        }
    }

    private void shrinkCache(int d) {
        int max = this.accessQueue.length - d;
        int[] tmp = new int[max];
        if (this.accessQueuePointer < max) {
            System.arraycopy(this.accessQueue, 0, tmp, 0, this.accessQueuePointer);
            System.arraycopy(this.accessQueue, this.accessQueuePointer + d, tmp, this.accessQueuePointer, max - this.accessQueuePointer);
            for (int i = this.accessQueuePointer; i < this.accessQueuePointer + d; ++i) {
                int k = this.accessQueue[i] - 1;
                if (k < 0) continue;
                this.storedRecords.set(k, null);
            }
            Iterator<StoredRecord> it = this.storedRecords.iterator();
            while (it.hasNext()) {
                StoredRecord rec = it.next();
                int index = rec != null ? rec.getAccessQueueIndex() : 0;
                int j = index - 1;
                if (j >= this.accessQueuePointer + d) {
                    rec.setAccessQueueIndex(index - d);
                    continue;
                }
                if (j < this.accessQueuePointer) continue;
                rec.setAccessQueueIndex(0);
            }
        } else {
            int k;
            int i;
            int d2 = this.accessQueuePointer - max;
            System.arraycopy(this.accessQueue, d2, tmp, 0, max);
            for (i = 0; i < d2; ++i) {
                k = this.accessQueue[i] - 1;
                if (k < 0) continue;
                this.storedRecords.set(k, null);
            }
            for (i = this.accessQueuePointer; i < this.accessQueue.length; ++i) {
                k = this.accessQueue[i] - 1;
                if (k < 0) continue;
                this.storedRecords.set(k, null);
            }
            Iterator<StoredRecord> it = this.storedRecords.iterator();
            while (it.hasNext()) {
                StoredRecord rec = it.next();
                int index = rec != null ? rec.getAccessQueueIndex() : 0;
                int j = index - 1;
                if (j >= d2 && j < this.accessQueuePointer) {
                    rec.setAccessQueueIndex(index - d2);
                    continue;
                }
                if (rec == null) continue;
                rec.setAccessQueueIndex(0);
                if (!rec.isEmpty()) continue;
                it.remove();
            }
            this.accessQueuePointer = 0;
        }
        this.accessQueue = tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCachedDocIndices() {
        int[] tmp;
        if (this.accessQueue != null) {
            Object object = this.cacheLock;
            synchronized (object) {
                int n = 0;
                for (int i = 0; i < this.accessQueue.length; ++i) {
                    int k = this.accessQueue[i] - 1;
                    if (k < 0) continue;
                    ++n;
                }
                tmp = new int[n];
                int j = 0;
                for (int i = 0; i < this.accessQueue.length; ++i) {
                    int k = this.accessQueue[i] - 1;
                    if (k < 0) continue;
                    tmp[j++] = k;
                }
            }
        } else {
            tmp = new int[this.getSize()];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = i;
            }
        }
        return tmp;
    }

    public boolean isRewindable() {
        return this.docSource == null || this.docSource.isRewindable() || this.getCacheCapacity() >= this.getCapacity();
    }

    public MDocument getDoc(int k, String key) throws RecordUnavailableException, IOException {
        try {
            return this.getDoc(k, key, null);
        }
        catch (CancellationException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MDocument getDoc(int k, String key, MProgressMonitor pmon) throws RecordUnavailableException, CancellationException, IOException {
        MDocument d;
        if (key == null) {
            return this.getMainDoc(k, pmon);
        }
        StoredRecord rec = this.storedRecords.get(k);
        String[] fieldDocumentKeys = null;
        MDocument[] fieldDocuments = null;
        if (rec != null) {
            fieldDocumentKeys = rec.getFieldDocumentKeys();
            fieldDocuments = rec.getFieldDocuments();
        }
        if (fieldDocumentKeys != null) {
            Object object = this.cacheLock;
            synchronized (object) {
                d = this.getCachedDoc0(k, key);
                if (d != null && !this.isFixed(k)) {
                    this.accessCachedDoc(k);
                }
            }
        } else if ((rec == null || rec.getMainDocument() == null) && this.docSource != null) {
            this.getMainDoc(k, pmon);
            Object object = this.cacheLock;
            synchronized (object) {
                d = this.getCachedDoc0(k, key);
            }
        } else {
            d = null;
        }
        return d;
    }

    public MDocument getMainDoc(int k) throws RecordUnavailableException, IOException {
        try {
            return this.getMainDoc(k, null);
        }
        catch (CancellationException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MDocument getMainDoc(int k, MProgressMonitor pmon) throws RecordUnavailableException, CancellationException, IOException {
        MDocument d;
        StoredRecord rec;
        StoredRecord storedRecord = rec = k < this.theSize ? this.storedRecords.get(k) : null;
        if (rec != null && rec.getMainDocument() != null) {
            if (!this.isFixed(k)) {
                Object object = this.cacheLock;
                synchronized (object) {
                    this.accessCachedDoc(k);
                }
            }
            d = rec.getMainDocument();
        } else if (this.docSource != null && k >= this.docSource.getRecordCountMax() - this.docSourceOffset) {
            this.tryToExtend(k + 1, pmon);
            rec = this.storedRecords.get(k);
            d = rec != null ? rec.getMainDocument() : null;
        } else if (this.docSource != null && this.docSource.isRewindable()) {
            this.docSource.seekRecord(this.docSourceOffset + k, null);
            if (rec == null || rec.getMainDocument() == null) {
                this.readDoc();
                rec = this.storedRecords.get(k);
            }
            d = rec != null ? rec.getMainDocument() : null;
        } else {
            d = null;
        }
        return d;
    }

    public String getDocLabel(int k, MDocument doc) {
        int irec = this.docSourceOffset + k;
        return this.docSource != null ? this.docSource.getDocLabel(irec, doc) : String.valueOf(irec + 1);
    }

    private void tryToExtend(int newsz, MProgressMonitor pmon) throws RecordUnavailableException, CancellationException, IOException {
        if (this.docSource != null) {
            int k = newsz - 1;
            int kmax = this.docSource.getRecordCountMax() - this.docSourceOffset;
            if (this.docSourceMax != 0) {
                if (k >= this.docSourceMax) {
                    k = this.docSourceMax - 1;
                }
                if (kmax > this.docSourceMax) {
                    kmax = this.docSourceMax;
                }
            }
            try {
                this.docSource.seekRecord(this.docSourceOffset + k, pmon);
            }
            catch (MolFormatException ex) {
                if (!(ex.getFinalCause() instanceof EOFException)) {
                    throw ex;
                }
            }
            catch (EOFException ex) {
                // empty catch block
            }
            if (this.docSource.getRecordCount() == this.docSourceOffset + k) {
                if (k >= kmax && this.isSizeFinal() || this.docSourceMax != 0 && newsz - 1 >= this.docSourceMax) {
                    int n = this.docSource.getRecordCountMax();
                    throw new RecordUnavailableException(this.docSourceOffset + k, "Cannot extend storage beyond end of input source. (" + (this.docSourceOffset + k) + " is out of range [" + this.docSourceOffset + ", " + (this.docSourceOffset + n - 1) + "])");
                }
                this.readDoc();
            }
            if (this.docSource.getRecordCount() != this.docSourceOffset + k + 1) {
                if (pmon != null && pmon.isCanceled()) {
                    throw new CancellationException("Reading canceled");
                }
                int n = this.docSource.getRecordCountMax() - this.docSourceOffset;
                if (n < 0) {
                    n = 0;
                }
                this.setFinalSize(n);
                throw new RecordUnavailableException(this.docSourceOffset + k, "Cannot extend storage beyond end of input source. (" + (this.docSourceOffset + k) + " is out of range [" + this.docSourceOffset + ", " + (this.docSourceOffset + n - 1) + "])");
            }
            this.setSizeAfterExtend();
        }
    }

    public int countRecords(MProgressMonitor pmon, int dt, Runnable sizeupdater, int max) throws IOException {
        if (this.docSource == null) {
            return this.getSize();
        }
        if (this.docSource.isEndReached()) {
            return this.docSource.getRecordCountMax();
        }
        int k = this.docSource.getRecordCount();
        this.docSource.seekForward(max, pmon, dt, sizeupdater);
        int k2 = this.docSource.getRecordCountMax();
        if (pmon != null && pmon.isCanceled()) {
            this.setSize(k2 - this.docSourceOffset);
            return -1;
        }
        this.docSource.seekRecord(k, null);
        int sz = k2 - this.docSourceOffset;
        if (this.docSource.isEndReached()) {
            this.setFinalSize(sz);
        } else {
            this.setSize(sz);
        }
        return k2;
    }

    public int countRecordsInFraction(double q, int ncols, MProgressMonitor pmon) throws IOException {
        if (this.docSource == null) {
            return this.getSize();
        }
        if (this.docSource.isEndReached()) {
            int m = this.docSource.getRecordCountMax();
            int k = (int)(q * (double)(m + ncols - 1) / (double)ncols) * ncols;
            if (k > m) {
                k = m;
            }
            return k;
        }
        int k = this.docSource.getRecordCount();
        this.docSource.seekRecordAtFraction(q, this.docSourceOffset, this.docSourceMax, ncols, pmon);
        int k2 = this.docSource.getRecordCount();
        if (pmon != null && pmon.isCanceled()) {
            this.setSize(this.getCurrentSize());
            return -1;
        }
        this.docSource.seekRecord(k, null);
        if (this.docSource.isEndReached()) {
            this.setFinalSize(this.docSource.getRecordCountMax() - this.docSourceOffset);
        } else {
            this.setSize(this.getCurrentSize());
        }
        return k2;
    }

    public boolean isFractionQuicklyAvailable(double x) {
        if (this.docSource == null) {
            return true;
        }
        int max = this.getCurrentSize();
        return (double)(this.docSource.getRecordCountMax() - this.docSourceOffset) >= x * (double)max;
    }

    public Object getCacheLock() {
        return this.cacheLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxDimCached() {
        int dim = 0;
        Object object = this.cacheLock;
        synchronized (object) {
            Iterator<StoredRecord> it = this.storedRecords.iterator();
            while (it.hasNext()) {
                StoredRecord rec = it.next();
                MDocument doc = rec != null ? rec.getMainDocument() : null;
                dim = MDocStorage.getMaxDim(doc, dim);
            }
        }
        return dim;
    }

    private static int getMaxDim(MDocument doc, int dim) {
        if (doc != null) {
            Molecule[] m = doc.getAllNonEmptyMolecules();
            for (int j = 0; j < m.length; ++j) {
                int d = m[j].getDim();
                if (d <= dim) continue;
                dim = d;
            }
        }
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MDocument getCachedDoc(int k, String key) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (k >= this.storedRecords.size()) {
                return null;
            }
            MDocument d = this.getCachedDoc0(k, key);
            if (d != null && !this.isFixed(k)) {
                this.accessCachedDoc(k);
            }
            return d;
        }
    }

    private MDocument getCachedDoc0(int k, String key) {
        if (key == null) {
            StoredRecord rec = this.storedRecords.get(k);
            return rec != null ? rec.getMainDocument() : null;
        }
        int i = this.getExistingMolFieldIndex(k, key);
        if (i >= 0) {
            StoredRecord rec = this.storedRecords.get(k);
            return rec.getFieldDocuments()[i];
        }
        return null;
    }

    public void storeDoc(MDocument doc, int k, String key) {
        if (key == null) {
            this.storeMainDoc(doc, k);
        } else {
            MDocument maindoc = null;
            Molecule mainmol = null;
            try {
                maindoc = this.getMainDoc(k, null);
                mainmol = maindoc != null ? (Molecule)maindoc.getMainMoleculeGraph() : null;
            }
            catch (Exception ex) {
                System.err.println("storeDoc(doc, " + k + ", " + key + "): cannot getMainDoc(" + k + ")");
            }
            int i = this.getMolFieldIndex(k, key);
            StoredRecord rec = this.storedRecords.get(k);
            String[] fieldDocumentKeys = rec.getFieldDocumentKeys();
            MDocument[] fieldDocuments = rec.getFieldDocuments();
            fieldDocumentKeys[i] = key;
            fieldDocuments[i] = doc;
            if (maindoc != null) {
                MoleculeGraph m = doc != null ? doc.getMainMoleculeGraph() : null;
                mainmol.setPropertyObject(key, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMainDoc(MDocument doc, int k) {
        StoredRecord rec;
        if (doc == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                int i;
                StoredRecord rec2 = this.storedRecords.get(k);
                if (this.accessQueue != null && rec2 != null && (i = rec2.getAccessQueueIndex() - 1) != -1) {
                    this.removeAccessQueueEntry(i);
                    --i;
                }
                if (rec2 != null && rec2.isFixed()) {
                    rec2.clearDoc();
                } else {
                    this.storedRecords.set(k, null);
                }
            }
        }
        Object object = this.cacheLock;
        synchronized (object) {
            if (!this.isFixed(k)) {
                this.ensureCapacity(k + 1, true);
                this.accessCachedDoc(k);
            }
            if ((rec = this.storedRecords.get(k)) == null) {
                rec = new StoredRecord(doc);
                this.storedRecords.set(k, rec);
            } else {
                rec.setMainDocument(doc);
            }
        }
        this.retrieveFields(rec, k);
        if (k >= this.theSize) {
            this.setSize0(k + 1);
        }
    }

    private int getExistingMolFieldIndex(int k, String key) {
        String[] keys;
        StoredRecord rec = this.storedRecords.get(k);
        String[] stringArray = keys = rec != null ? rec.getFieldDocumentKeys() : null;
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].equalsIgnoreCase(key)) continue;
                return i;
            }
        }
        return -1;
    }

    private int getMolFieldIndex(int k, String key) {
        Object tmp;
        int i = this.getExistingMolFieldIndex(k, key);
        if (i >= 0) {
            return i;
        }
        StoredRecord rec = this.storedRecords.get(k);
        if (rec == null) {
            rec = new StoredRecord(null);
        }
        String[] keys = rec.getFieldDocumentKeys();
        MDocument[] docs = rec.getFieldDocuments();
        MolPainter[] painters = rec.getMolPainters();
        DPoint3[] centers = rec.getMolCenters();
        int[][] selat = rec.getSelectedAtoms();
        int[][] atsetseqs = rec.getAtomSetSeqs();
        List<int[]>[] bondsetseqs = rec.getBondSetSeqs();
        if (keys != null) {
            Object tmp2;
            int n = keys.length;
            String[] tmpkeys = new String[n + 1];
            MDocument[] tmpdocs = new MDocument[n + 1];
            System.arraycopy(keys, 0, tmpkeys, 0, n);
            System.arraycopy(docs, 0, tmpdocs, 0, n);
            tmpkeys[n] = key;
            tmpdocs[n] = null;
            rec.setFieldDocumentKeys(tmpkeys);
            rec.setFieldDocuments(tmpdocs);
            if (painters != null) {
                tmp2 = new MolPainter[n + 2];
                System.arraycopy(painters, 0, tmp2, 0, n + 1);
                rec.setMolPainters((MolPainter[])tmp2);
            }
            if (centers != null) {
                tmp2 = new DPoint3[n + 2];
                System.arraycopy(centers, 0, tmp2, 0, n + 1);
                rec.setMolCenters((DPoint3[])tmp2);
            }
            if (selat != null) {
                tmp2 = new int[n + 2][];
                System.arraycopy(selat, 0, tmp2, 0, n + 1);
                rec.setSelectedAtoms((int[][])tmp2);
            }
            if (atsetseqs != null) {
                tmp2 = new int[n + 2][];
                System.arraycopy(atsetseqs, 0, tmp2, 0, n + 1);
                rec.setAtomSetSeqs((int[][])tmp2);
            }
            if (bondsetseqs != null) {
                tmp2 = new List[n + 2];
                System.arraycopy(bondsetseqs, 0, tmp2, 0, n + 1);
                rec.setBondSetSeqs((List<int[]>[])tmp2);
            }
            return n;
        }
        keys = new String[]{key};
        rec.setFieldDocumentKeys(keys);
        rec.setFieldDocuments(new MDocument[1]);
        if (painters != null) {
            tmp = new MolPainter[2];
            tmp[0] = painters[0];
            rec.setMolPainters((MolPainter[])tmp);
        }
        if (centers != null) {
            tmp = new DPoint3[2];
            tmp[0] = centers[0];
            rec.setMolCenters((DPoint3[])tmp);
        }
        if (selat != null) {
            tmp = new int[2][];
            tmp[0] = selat[0];
            rec.setSelectedAtoms((int[][])tmp);
        }
        if (atsetseqs != null) {
            tmp = new int[2][];
            tmp[0] = atsetseqs[0];
            rec.setAtomSetSeqs((int[][])tmp);
        }
        if (bondsetseqs != null) {
            tmp = new List[2];
            tmp[0] = bondsetseqs[0];
            rec.setBondSetSeqs((List<int[]>[])tmp);
        }
        return 0;
    }

    private void retrieveFields(StoredRecord rec, int k) {
        MDocument doc = rec.getMainDocument();
        Molecule mol = (Molecule)doc.getMainMoleculeGraph();
        String[] keys = this.fieldAccessor.getKeys(k, mol);
        MProp[] props = new MProp[keys.length];
        this.fieldAccessor.getFields(k, mol, keys, props);
        ArrayList<String> keylist = new ArrayList<String>();
        ArrayList<MDocument> doclist = new ArrayList<MDocument>();
        for (int i = 0; i < props.length; ++i) {
            String key = keys[i];
            MProp p = props[i];
            if (p == null) {
                keylist.add(key);
                doclist.add(new MDocument(new Molecule()));
                continue;
            }
            if (!(p instanceof MMoleculeProp)) continue;
            Molecule m = ((MMoleculeProp)p).getMolecule().cloneMolecule();
            keylist.add(key);
            doclist.add(new MDocument(m));
        }
        int n = keylist.size();
        if (n != 0) {
            MDocument[] fieldDocuments = new MDocument[n];
            String[] fieldDocumentKeys = new String[n];
            doclist.toArray(fieldDocuments);
            keylist.toArray(fieldDocumentKeys);
            rec.setFieldDocuments(fieldDocuments);
            rec.setFieldDocumentKeys(fieldDocumentKeys);
        } else {
            rec.setFieldDocuments(null);
            rec.setFieldDocumentKeys(null);
        }
    }

    public boolean isFixed(int k) {
        if (k >= this.storedRecords.size()) {
            return false;
        }
        StoredRecord rec = this.storedRecords.get(k);
        return rec != null && rec.isFixed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixed(int k) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (k >= this.storedRecords.size() && !this.storedRecords.isSparse()) {
                throw new IndexOutOfBoundsException("index " + k + " is larger than the capacity (" + this.storedRecords.size() + ")");
            }
            StoredRecord rec = this.storedRecords.get(k);
            if (rec == null) {
                rec = new StoredRecord(null);
            }
            if (!rec.isFixed()) {
                rec.setFixed();
                this.storedRecords.set(k, rec);
                if (this.accessQueue != null) {
                    for (int i = 0; i < this.accessQueue.length; ++i) {
                        if (this.accessQueue[i] != k + 1) continue;
                        this.removeAccessQueueEntry(i);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MolPainter getMolPainter(int k, String key) {
        MolPainter[] painters;
        StoredRecord rec = k < this.storedRecords.size() ? this.storedRecords.get(k) : null;
        MolPainter[] molPainterArray = painters = rec != null ? rec.getMolPainters() : null;
        if (painters == null) {
            return null;
        }
        if (key == null) {
            return painters[0];
        }
        MDocStorage mDocStorage = this;
        synchronized (mDocStorage) {
            int i = this.getExistingMolFieldIndex(k, key);
            MolPainter painter = i >= 0 ? painters[i + 1] : null;
            return painter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMolPainter(int k, String key, MolPainter p) {
        MolPainter[] painters;
        if (k >= this.storedRecords.size() && p == null) {
            return;
        }
        this.ensureCapacity(k + 1, !this.isSizeFinal());
        StoredRecord rec = this.storedRecords.get(k);
        if (rec == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                rec = new StoredRecord(null);
                this.storedRecords.set(k, rec);
            }
        }
        if ((painters = rec.getMolPainters()) == null) {
            MDocument[] fielddocs = rec.getFieldDocuments();
            int nf = fielddocs != null ? fielddocs.length : 0;
            painters = new MolPainter[nf + 1];
            rec.setMolPainters(painters);
        }
        if (key == null) {
            painters[0] = p;
        } else {
            int i = this.getMolFieldIndex(k, key);
            if (i >= 0) {
                painters = rec.getMolPainters();
                painters[i + 1] = p;
            } else {
                throw new IllegalArgumentException("cannot set molecule painter in record " + k + " for non-existent field " + key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DPoint3 getMolCenter(int k, String key) {
        DPoint3[] c;
        StoredRecord rec = k < this.storedRecords.size() ? this.storedRecords.get(k) : null;
        DPoint3[] dPoint3Array = c = rec != null ? rec.getMolCenters() : null;
        if (c == null) {
            return null;
        }
        if (key == null) {
            return c[0];
        }
        MDocStorage mDocStorage = this;
        synchronized (mDocStorage) {
            int i = this.getExistingMolFieldIndex(k, key);
            return i >= 0 ? c[i + 1] : null;
        }
    }

    private void calcTransformedCenter(int k, String key, DPoint3 q) {
        MolPainter p = this.getMolPainter(k, key);
        DPoint3 qq = this.getMolCenter(k, key);
        if (qq != null) {
            q.set(qq);
            CTransform3D t = p.getRTransform();
            t.transform(q);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMolCenter(int k, String key, DPoint3 p) {
        DPoint3[] centers;
        StoredRecord rec = k < this.storedRecords.size() ? this.storedRecords.get(k) : null;
        DPoint3[] dPoint3Array = centers = rec != null ? rec.getMolCenters() : null;
        if (centers == null) {
            MDocument[] fielddocs;
            if (rec == null) {
                Object object = this.cacheLock;
                synchronized (object) {
                    rec = new StoredRecord(null);
                    this.storedRecords.set(k, rec);
                }
            }
            int nf = (fielddocs = rec.getFieldDocuments()) != null ? fielddocs.length : 0;
            centers = new DPoint3[nf + 1];
            rec.setMolCenters(centers);
        }
        if (key == null) {
            centers[0] = p;
        } else {
            int i = this.getExistingMolFieldIndex(k, key);
            if (i >= 0) {
                centers[i + 1] = p;
            } else {
                throw new IllegalArgumentException("cannot set molecule center in record " + k + " for non-existent field " + key);
            }
        }
    }

    public int[] getSelectedAtoms(int k, String key) {
        StoredRecord rec = this.storedRecords.get(k);
        int[][] selk = rec.getSelectedAtoms();
        if (selk != null) {
            if (key == null) {
                return selk[0];
            }
            int i = this.getExistingMolFieldIndex(k, key);
            if (i >= 0) {
                return selk[i + 1];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedAtoms(int k, String key, int[] sel) {
        int nf;
        StoredRecord rec;
        StoredRecord storedRecord = rec = k < this.storedRecords.size() ? this.storedRecords.get(k) : null;
        if (sel == null && (rec == null || rec.getSelectedAtoms() == null)) {
            return;
        }
        this.ensureCapacity(k + 1, false);
        Object selk = rec != null ? rec.getSelectedAtoms() : (int[][])null;
        MDocument[] fielddocs = rec != null ? rec.getFieldDocuments() : null;
        int n = nf = fielddocs != null ? fielddocs.length : 0;
        if (selk == null) {
            if (sel == null) {
                return;
            }
            if (rec == null) {
                Object object = this.cacheLock;
                synchronized (object) {
                    rec = new StoredRecord(null);
                    this.storedRecords.set(k, rec);
                }
            }
            int[][] nArrayArray = new int[nf + 1][];
            selk = nArrayArray;
            rec.setSelectedAtoms(nArrayArray);
        }
        if (key == null) {
            selk[0] = sel;
        } else {
            int i;
            int n2 = i = sel != null ? this.getMolFieldIndex(k, key) : this.getExistingMolFieldIndex(k, key);
            if (i >= 0) {
                selk[i + 1] = sel;
            }
        }
        if (sel == null) {
            for (int i = 0; i < ((int[][])selk).length; ++i) {
                if (selk[i] == null) continue;
                return;
            }
            if (rec != null) {
                rec.setSelectedAtoms(null);
                if (rec.isEmpty()) {
                    Object object = this.cacheLock;
                    synchronized (object) {
                        this.storedRecords.set(k, null);
                    }
                }
            }
        }
    }

    public void setSelectedAtoms(int k, String key, String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        ArrayList<Integer> v = new ArrayList<Integer>();
        while (st.hasMoreTokens()) {
            v.add(Integer.valueOf(st.nextToken().trim()));
        }
        int n = v.size();
        int[] sel = new int[n];
        for (int j = 0; j < n; ++j) {
            int l;
            sel[j] = l = ((Integer)v.get(j)).intValue();
        }
        this.setSelectedAtoms(k, key, sel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomSetSeqs(int k, String key, int[] seqs) {
        int nf;
        StoredRecord rec;
        StoredRecord storedRecord = rec = k < this.storedRecords.size() ? this.storedRecords.get(k) : null;
        if (seqs == null && (rec == null || rec.getAtomSetSeqs() == null)) {
            return;
        }
        this.ensureCapacity(k + 1, false);
        Object seqk = rec != null ? rec.getAtomSetSeqs() : (int[][])null;
        MDocument[] fielddocs = rec != null ? rec.getFieldDocuments() : null;
        int n = nf = fielddocs != null ? fielddocs.length : 0;
        if (seqk == null) {
            if (seqs == null) {
                return;
            }
            if (rec == null) {
                Object object = this.cacheLock;
                synchronized (object) {
                    rec = new StoredRecord(null);
                    this.storedRecords.set(k, rec);
                }
            }
            int[][] nArrayArray = new int[nf + 1][];
            seqk = nArrayArray;
            rec.setAtomSetSeqs(nArrayArray);
        }
        if (key == null) {
            seqk[0] = seqs;
        } else {
            int i;
            int n2 = i = seqs != null ? this.getMolFieldIndex(k, key) : this.getExistingMolFieldIndex(k, key);
            if (i >= 0) {
                seqk[i + 1] = seqs;
            }
        }
        if (seqs == null) {
            for (int i = 0; i < ((int[][])seqk).length; ++i) {
                if (seqk[i] == null) continue;
                return;
            }
            if (rec != null) {
                rec.setAtomSetSeqs(null);
                if (rec.isEmpty()) {
                    Object object = this.cacheLock;
                    synchronized (object) {
                        this.storedRecords.set(k, null);
                    }
                }
            }
        }
    }

    public void setAtomSetSeq(int k, String key, String str, int setSeq) {
        StringTokenizer st = new StringTokenizer(str, ",");
        ArrayList<Integer> v = new ArrayList<Integer>();
        int max = -1;
        while (st.hasMoreTokens()) {
            Integer o = Integer.valueOf(st.nextToken().trim());
            int x = o;
            if (x > max) {
                max = x;
            }
            v.add(o);
        }
        int[] seqk = this.atomSetSeqArray(k, key, max);
        int n = v.size();
        for (int j = 0; j < n; ++j) {
            seqk[((Integer)v.get((int)j)).intValue()] = setSeq;
        }
    }

    public void setAtomSetSeq(int k, String key, int atom, int seq) {
        int[] v = this.atomSetSeqArray(k, key, atom);
        v[atom] = seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] atomSetSeqArray(int k, String key, int max) {
        int nf;
        StoredRecord rec;
        this.ensureCapacity(k + 1, false);
        int i = 0;
        if (key != null) {
            i = this.getMolFieldIndex(k, key) + 1;
        }
        Object seqk = (rec = this.storedRecords.get(k)) != null ? rec.getAtomSetSeqs() : (int[][])null;
        MDocument[] fielddocs = rec != null ? rec.getFieldDocuments() : null;
        int n = nf = fielddocs != null ? fielddocs.length : 0;
        if (seqk == null) {
            if (rec == null) {
                Object object = this.cacheLock;
                synchronized (object) {
                    rec = new StoredRecord(null);
                    this.storedRecords.set(k, rec);
                }
            }
            int[][] nArrayArray = new int[nf + 1][];
            seqk = nArrayArray;
            rec.setAtomSetSeqs(nArrayArray);
        }
        if (seqk[i] == null) {
            seqk[i] = new int[max + 1];
        } else if (seqk[i].length <= max) {
            int[] tmp = new int[max + 1];
            System.arraycopy(seqk[i], 0, tmp, 0, seqk[i].length);
            seqk[i] = tmp;
        }
        return seqk[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBondSetSeqs(int k, String key, List<int[]> seqs) {
        int nf;
        StoredRecord rec;
        StoredRecord storedRecord = rec = k < this.storedRecords.size() ? this.storedRecords.get(k) : null;
        if (seqs == null && (rec == null || rec.getBondSetSeqs() == null)) {
            return;
        }
        this.ensureCapacity(k + 1, false);
        List<int[]>[] bseqv = rec != null ? rec.getBondSetSeqs() : null;
        MDocument[] fielddocs = rec != null ? rec.getFieldDocuments() : null;
        int n = nf = fielddocs != null ? fielddocs.length : 0;
        if (bseqv == null) {
            if (seqs == null) {
                return;
            }
            if (rec == null) {
                Object object = this.cacheLock;
                synchronized (object) {
                    rec = new StoredRecord(null);
                    this.storedRecords.set(k, rec);
                }
            }
            bseqv = new List[nf + 1];
            rec.setBondSetSeqs(bseqv);
        }
        if (key == null) {
            bseqv[0] = seqs;
        } else {
            int i;
            int n2 = i = seqs != null ? this.getMolFieldIndex(k, key) : this.getExistingMolFieldIndex(k, key);
            if (i >= 0) {
                bseqv[i + 1] = seqs;
            }
        }
        if (seqs == null) {
            for (int i = 0; i < bseqv.length; ++i) {
                if (bseqv[i] == null) continue;
                return;
            }
            if (rec != null) {
                rec.setBondSetSeqs(null);
                if (rec.isEmpty()) {
                    Object object = this.cacheLock;
                    synchronized (object) {
                        this.storedRecords.set(k, null);
                    }
                }
            }
        }
    }

    public void setBondSetSeq(int k, String key, String str, int setSeq) {
        List<int[]> v = this.bondSetSeqVector(k, key);
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String ss = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(ss, "-");
            int prev = -1;
            while (st2.hasMoreTokens()) {
                int j = Integer.parseInt(st2.nextToken());
                if (prev >= 0) {
                    int[] w = new int[3];
                    w[0] = setSeq;
                    if (prev < j) {
                        w[1] = prev;
                        w[2] = j;
                    } else {
                        w[1] = j;
                        w[2] = prev;
                    }
                    v.add(w);
                }
                prev = j;
            }
        }
    }

    public void setBondSetSeq(int k, String key, int j1, int j2, int seq) {
        List<int[]> v = this.bondSetSeqVector(k, key);
        if (j2 < j1) {
            int t = j2;
            j2 = j1;
            j1 = t;
        }
        for (int j = 0; j < v.size(); ++j) {
            int[] w = v.get(j);
            if (w[1] != j1 || w[2] != j2) continue;
            w[0] = seq;
            return;
        }
        int[] w = new int[]{seq, j1, j2};
        v.add(w);
    }

    public void setBondSetSeqAll(int k, String key, int seq) {
        List<int[]> v = this.bondSetSeqVector(k, key);
        v.clear();
        int[] w = new int[]{seq};
        v.add(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<int[]> bondSetSeqVector(int k, String key) {
        int nf;
        StoredRecord rec;
        this.ensureCapacity(k + 1, false);
        int i = 0;
        if (key != null) {
            i = this.getMolFieldIndex(k, key) + 1;
        }
        List<int[]>[] bseqv = (rec = this.storedRecords.get(k)) != null ? rec.getBondSetSeqs() : null;
        MDocument[] fielddocs = rec != null ? rec.getFieldDocuments() : null;
        int n = nf = fielddocs != null ? fielddocs.length : 0;
        if (bseqv == null) {
            if (rec == null) {
                Object object = this.cacheLock;
                synchronized (object) {
                    rec = new StoredRecord(null);
                    this.storedRecords.set(k, rec);
                }
            }
            bseqv = new List[nf + 1];
            rec.setBondSetSeqs(bseqv);
        }
        if (bseqv[i] == null) {
            bseqv[i] = new ArrayList<int[]>();
        }
        return bseqv[i];
    }

    public void doSetSetSeqs(Molecule[] mols, int k, String key) {
        List<int[]>[] bseqv;
        int[][] aseqk;
        int i = 0;
        if (key != null && (i = this.getExistingMolFieldIndex(k, key) + 1) == 0) {
            return;
        }
        StoredRecord rec = this.storedRecords.get(k);
        int[][] nArray = aseqk = rec != null ? rec.getAtomSetSeqs() : (int[][])null;
        if (aseqk != null && aseqk[i] != null) {
            int[] aseqki = aseqk[i];
            for (int j = 0; j < mols.length; ++j) {
                Molecule m = mols[j];
                int na = m.getAtomCount();
                if (na > aseqki.length) {
                    na = aseqki.length;
                }
                for (int l = 0; l < na; ++l) {
                    m.getAtom(l).setSetSeq(aseqki[l]);
                }
            }
        }
        this.setAtomSetSeqs(k, key, null);
        List<int[]>[] listArray = bseqv = rec != null ? rec.getBondSetSeqs() : null;
        if (bseqv != null && bseqv[i] != null) {
            List<int[]> v = bseqv[i];
            for (int j = 0; j < mols.length; ++j) {
                Molecule m = mols[j];
                BondTable btab = m.getBondTable();
                for (int kv = 0; kv < v.size(); ++kv) {
                    int[] w = v.get(kv);
                    if (w.length == 1) {
                        for (int l = 0; l < m.getBondCount(); ++l) {
                            MolBond b = m.getBond(l);
                            b.setSetSeq(w[0]);
                        }
                        continue;
                    }
                    MolBond b = m.getBond(btab.getBondIndex(w[1], w[2]));
                    b.setSetSeq(w[0]);
                }
            }
        }
        this.setBondSetSeqs(k, key, null);
        if (aseqk != null || bseqv != null) {
            this.setFixed(k);
        }
    }

    public String getL(int k, int j) {
        StoredRecord rec = this.storedRecords.get(k);
        String[] lab = rec != null ? rec.getLabels() : null;
        return lab != null ? lab[j] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setL(int k, int j, String l) {
        String[] lab;
        StoredRecord rec;
        StoredRecord storedRecord = rec = k < this.storedRecords.size() ? this.storedRecords.get(k) : null;
        if (l == null && (rec == null || rec.getLabels() == null)) {
            return;
        }
        this.ensureCapacity(k + 1, false);
        String[] stringArray = lab = rec != null ? rec.getLabels() : null;
        if (lab == null) {
            if (l != null) {
                lab = new String[j + 1];
                lab[j] = l;
                if (rec == null) {
                    Object object = this.cacheLock;
                    synchronized (object) {
                        rec = new StoredRecord(null);
                        this.storedRecords.set(k, rec);
                    }
                }
                rec.setLabels(lab);
            }
        } else if (l == null) {
            if (j < lab.length) {
                lab[j] = null;
            }
            for (int i = 0; i < lab.length; ++i) {
                if (lab[i] == null) continue;
                return;
            }
            if (rec != null) {
                rec.setLabels(null);
                if (rec.isEmpty()) {
                    Object i = this.cacheLock;
                    synchronized (i) {
                        this.storedRecords.set(k, null);
                    }
                }
            }
        } else if (j < lab.length) {
            lab[j] = l;
        } else {
            String[] tmp = new String[j + 1];
            System.arraycopy(lab, 0, tmp, 0, lab.length);
            tmp[j] = l;
            rec.setLabels(tmp);
        }
    }

    public String getT(int k, int j) {
        StoredRecord rec = this.storedRecords.get(k);
        String[] s = rec != null ? rec.getTxtStrings() : null;
        return s != null ? s[j] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setT(int k, int j, String l) {
        String[] txt;
        StoredRecord rec = this.storedRecords.get(k);
        String[] stringArray = txt = rec != null ? rec.getTxtStrings() : null;
        if (txt == null) {
            if (l != null) {
                txt = new String[j + 1];
                txt[j] = l;
                if (rec == null) {
                    Object object = this.cacheLock;
                    synchronized (object) {
                        rec = new StoredRecord(null);
                        this.storedRecords.set(k, rec);
                    }
                }
                rec.setTxtStrings(txt);
            }
        } else if (l == null) {
            if (j < txt.length) {
                txt[j] = null;
            }
            for (int i = 0; i < txt.length; ++i) {
                if (txt[i] == null) continue;
                return;
            }
            if (rec != null) {
                rec.setTxtStrings(null);
                if (rec.isEmpty()) {
                    Object i = this.cacheLock;
                    synchronized (i) {
                        this.storedRecords.set(k, null);
                    }
                }
            }
        } else if (j < txt.length) {
            txt[j] = l;
        } else {
            String[] tmp = new String[j + 1];
            System.arraycopy(txt, 0, tmp, 0, txt.length);
            tmp[j] = l;
            rec.setTxtStrings(tmp);
        }
    }

    public boolean isEnabledT(int k, int j) {
        StoredRecord rec = this.storedRecords.get(k);
        boolean[] s = rec != null ? rec.getTxtEnabled() : null;
        return s != null && j < s.length && s[j];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabledT(int k, int j, boolean l) {
        boolean[] txt;
        StoredRecord rec = this.storedRecords.get(k);
        boolean[] blArray = txt = rec != null ? rec.getTxtEnabled() : null;
        if (txt == null) {
            if (l) {
                txt = new boolean[j + 1];
                txt[j] = l;
                if (rec == null) {
                    Object object = this.cacheLock;
                    synchronized (object) {
                        rec = new StoredRecord(null);
                        this.storedRecords.set(k, rec);
                    }
                }
                rec.setTxtEnabled(txt);
            }
        } else if (!l) {
            if (j < txt.length) {
                txt[j] = false;
            }
            for (int i = 0; i < txt.length; ++i) {
                if (!txt[i]) continue;
                return;
            }
            if (rec != null) {
                rec.setTxtEnabled(null);
                if (rec.isEmpty()) {
                    Object i = this.cacheLock;
                    synchronized (i) {
                        this.storedRecords.set(k, null);
                    }
                }
            }
        } else if (j < txt.length) {
            txt[j] = l;
        } else {
            boolean[] tmp = new boolean[j + 1];
            System.arraycopy(txt, 0, tmp, 0, txt.length);
            tmp[j] = l;
            rec.setTxtEnabled(tmp);
        }
    }

    public int getIDBackgroundRGBA(int k) {
        if (this.idBackgroundRGBA == null) {
            return 0;
        }
        return this.idBackgroundRGBA.get(this.docSourceOffset + k);
    }

    public boolean setIDBackgroundRGBA(int k, int rgba) {
        if (this.idBackgroundRGBA == null) {
            this.idBackgroundRGBA = new PackedIntArray();
        }
        return this.idBackgroundRGBA.set(this.docSourceOffset + k, rgba);
    }

    public int getIDForegroundRGBA(int k) {
        if (this.idForegroundRGBA == null) {
            return 0;
        }
        return this.idForegroundRGBA.get(this.docSourceOffset + k);
    }

    public boolean setIDForegroundRGBA(int k, int rgba) {
        if (this.idForegroundRGBA == null) {
            this.idForegroundRGBA = new PackedIntArray();
        }
        return this.idForegroundRGBA.set(this.docSourceOffset + k, rgba);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillWithNulls() {
        if (this.accessQueue != null) {
            Object object = this.cacheLock;
            synchronized (object) {
                for (int i = 0; i < this.accessQueue.length; ++i) {
                    int k = this.accessQueue[i] - 1;
                    if (k == -1) continue;
                    this.accessQueue[i] = 0;
                    this.storedRecords.set(k, null);
                }
            }
        } else {
            int n = this.getCapacity();
            this.storedRecords.unsetElements(0, n);
        }
    }

    public boolean contractOrExpandSgroupsAll(boolean contract) {
        boolean r;
        int n = this.getSize();
        StoredRecord rec0 = this.storedRecords.get(0);
        if (n == 1 && (rec0 == null || rec0.getFieldDocuments() == null)) {
            r = this.contractOrExpandSgroups(0, null, contract);
        } else {
            r = false;
            Iterator<StoredRecordArray.Entry> it = this.storedRecords.entryIterator();
            while (it.hasNext()) {
                StoredRecordArray.Entry e = it.next();
                int k = e.index();
                StoredRecord rec = e.value();
                r |= this.contractOrExpandSgroups(k, null, contract, false);
                String[] keys = rec != null ? rec.getFieldDocumentKeys() : null;
                if (keys == null) continue;
                for (int i = 0; i < keys.length; ++i) {
                    r |= this.contractOrExpandSgroups(k, keys[i], contract, false);
                }
            }
            this.contractExpandSwitch = contract;
            this.commandFlags |= 1;
        }
        return r;
    }

    public boolean contractOrExpandSgroups(int k, String key, boolean contr) {
        return this.contractOrExpandSgroups(k, key, contr, true);
    }

    private boolean contractOrExpandSgroups(int k, String key, boolean contr, boolean fix) {
        MDocument doc = this.getCachedDoc0(k, key);
        Molecule[] mols = doc != null ? doc.getAllNonEmptyMolecules() : null;
        boolean r = false;
        if (mols != null) {
            for (int i = 0; i < mols.length; ++i) {
                if (contr) {
                    r |= mols[i].contractSgroups();
                    continue;
                }
                r |= mols[i].expandSgroups();
            }
            if (r && fix) {
                this.setFixed(k);
            }
        }
        return r;
    }

    public boolean hydrogenizeAll(boolean hydr, String[] warn) {
        boolean r;
        int n = this.getSize();
        StoredRecord rec0 = this.storedRecords.get(0);
        if (n == 1 && (rec0 == null || rec0.getFieldDocuments() == null)) {
            r = this.hydrogenize(0, null, hydr, warn);
        } else {
            r = false;
            Iterator<StoredRecordArray.Entry> it = this.storedRecords.entryIterator();
            while (it.hasNext()) {
                StoredRecordArray.Entry e = it.next();
                int k = e.index();
                StoredRecord rec = e.value();
                r |= this.hydrogenize(k, null, hydr, null, false);
                String[] keys = rec != null ? rec.getFieldDocumentKeys() : null;
                if (keys == null) continue;
                for (int i = 0; i < keys.length; ++i) {
                    r |= this.hydrogenize(k, keys[i], hydr, null, false);
                }
            }
            this.hydrogenizeSwitch = hydr;
            this.commandFlags |= 2;
        }
        return r;
    }

    public boolean hydrogenize(int k, String key, boolean hydr, String[] warn) {
        return this.hydrogenize(k, key, hydr, warn, true);
    }

    private boolean hydrogenize(int k, String key, boolean hydr, String[] warn, boolean fix) {
        Molecule[] mols;
        MDocument doc = this.getCachedDoc0(k, key);
        Molecule[] moleculeArray = mols = doc != null ? doc.getAllNonEmptyMolecules() : null;
        if (mols != null) {
            int dN = 0;
            boolean hadH = false;
            for (int i = 0; i < mols.length; ++i) {
                int n0 = mols[i].getAtomCount();
                for (int j = 0; j < n0; ++j) {
                    int atno = mols[i].getAtom(j).getAtno();
                    hadH |= atno == 1;
                }
                Molecule m = mols[i];
                m.hydrogenize(hydr);
                dN += m.getAtomCount() - n0;
            }
            if (dN != 0) {
                if (fix) {
                    this.setFixed(k);
                }
                return true;
            }
            if (warn != null) {
                String msg = null;
                if (hydr) {
                    msg = "Cannot add ";
                    if (hadH) {
                        msg = msg + "more ";
                    }
                    msg = msg + "Hydrogens to this structure";
                } else {
                    msg = "No explicit Hydrogens to remove";
                }
                warn[0] = msg;
            }
        }
        return false;
    }

    public boolean aromatizeAll(boolean v, int method, String[] warn) {
        boolean r;
        int n = this.getSize();
        StoredRecord rec0 = this.storedRecords.get(0);
        if (n == 1 && (rec0 == null || rec0.getFieldDocuments() == null)) {
            r = this.aromatize(0, null, v, method, warn);
        } else {
            r = false;
            Iterator<StoredRecordArray.Entry> it = this.storedRecords.entryIterator();
            while (it.hasNext()) {
                StoredRecordArray.Entry e = it.next();
                int k = e.index();
                StoredRecord rec = e.value();
                r |= this.aromatize(k, null, v, method, null, false);
                String[] keys = rec != null ? rec.getFieldDocumentKeys() : null;
                if (keys == null) continue;
                for (int i = 0; i < keys.length; ++i) {
                    r |= this.aromatize(k, keys[i], v, method, null, false);
                }
            }
            this.aromatizeSwitch = v;
            this.aromatizeMethod = method;
            this.commandFlags |= 4;
        }
        return r;
    }

    public boolean aromatize(int k, String key, boolean v, int method, String[] warn) {
        return this.aromatize(k, key, v, method, warn, true);
    }

    private boolean aromatize(int k, String key, boolean v, int method, String[] warn, boolean fix) {
        Molecule[] mols;
        MDocument doc = this.getCachedDoc0(k, key);
        Molecule[] moleculeArray = mols = doc != null ? doc.getAllNonEmptyMolecules() : null;
        if (mols != null) {
            int dn = 0;
            for (int i = 0; i < mols.length; ++i) {
                Molecule m = mols[i];
                int nb = m.getBondCount();
                int n0 = 0;
                for (int j = 0; j < nb; ++j) {
                    if (m.getBond(j).getType() != 4) continue;
                    ++n0;
                }
                if (v) {
                    ((MoleculeGraph)m).aromatize(method);
                } else {
                    ((MoleculeGraph)m).dearomatize();
                }
                int n1 = 0;
                for (int j = 0; j < nb; ++j) {
                    if (m.getBond(j).getType() != 4) continue;
                    ++n1;
                }
                dn += Math.abs(n1 - n0);
            }
            if (dn != 0) {
                if (fix) {
                    this.setFixed(k);
                }
                return true;
            }
            if (warn != null) {
                String msg = null;
                msg = v ? "Cannot aromatize this structure" : "Cannot dearomatize this structure";
                warn[0] = msg;
            }
        }
        return false;
    }

    public boolean cleanAll(int dim, String opts, MProgressMonitor pm, String[] warn) {
        boolean r;
        int n = this.getSize();
        StoredRecord rec0 = this.storedRecords.get(0);
        if (n == 1 && (rec0 == null || rec0.getFieldDocuments() == null)) {
            r = this.clean(0, null, dim, opts, pm, warn);
        } else {
            r = false;
            Iterator<StoredRecordArray.Entry> it = this.storedRecords.entryIterator();
            while (it.hasNext()) {
                StoredRecordArray.Entry e = it.next();
                int k = e.index();
                StoredRecord rec = e.value();
                r |= this.clean(k, null, dim, opts, pm, null, false);
                String[] keys = rec != null ? rec.getFieldDocumentKeys() : null;
                if (keys == null) continue;
                for (int i = 0; i < keys.length; ++i) {
                    r |= this.clean(k, keys[i], dim, opts, pm, null, false);
                }
            }
            this.cleanDimension = dim;
            this.cleanOptions = opts;
            this.commandFlags |= 8;
        }
        return r;
    }

    public boolean clean(int k, String key, int dim, String opts, MProgressMonitor pm, String[] warn) {
        return this.clean(k, key, dim, opts, pm, warn, true);
    }

    private boolean clean(int k, String key, int dim, String opts, MProgressMonitor pm, String[] warn, boolean fix) {
        MDocument doc = this.getCachedDoc0(k, key);
        Molecule[] mols = doc != null ? doc.getAllNonEmptyMolecules() : null;
        MolPainter p = this.getMolPainter(k, key);
        if (mols != null && p != null) {
            int dn = 0;
            for (int i = 0; i < mols.length; ++i) {
                Molecule m = mols[i];
                if (!m.clean(dim, opts, pm)) continue;
                CTransform3D t = p.getRTransform();
                double scale = t.getScale();
                t.setIdentity();
                DPoint3 roto = new DPoint3();
                this.calcTransformedCenter(k, key, roto);
                t.setScale(scale);
                t.setRotationCenter(roto);
                p.setRTransform(t);
                ++dn;
            }
            p.setBoundsFor(doc);
            if (dn != 0) {
                if (fix) {
                    this.setFixed(k);
                }
                return true;
            }
            if (warn != null) {
                warn[0] = mols.length > 1 ? "Cannot clean these structures" : "Cannot clean this structure";
            }
        }
        return false;
    }

    private MDocument readDoc() throws IOException, RecordUnavailableException {
        StoredRecord rec;
        int k = this.docSource.getRecordCount() - this.docSourceOffset;
        int kmax = this.docSource.getRecordCountMax() - this.docSourceOffset;
        if (this.docSourceMax != 0) {
            if (k >= this.docSourceMax) {
                k = this.docSourceMax - 1;
            }
            if (kmax > this.docSourceMax) {
                kmax = this.docSourceMax;
            }
        }
        MDocument doc = this.docSource.nextDoc();
        int reccountmax = this.docSource.getRecordCountMax();
        if (doc == null && this.docSource.getRecordCount() >= reccountmax && this.docSource.isEndReached()) {
            this.setFinalSize(reccountmax - this.docSourceOffset);
            throw new RecordUnavailableException(this.docSourceOffset + k, "Cannot read document beyond end of input source. (" + (this.docSourceOffset + k) + " is out of range [" + this.docSourceOffset + ", " + reccountmax + "])");
        }
        if (this.storedRecords.size() < kmax) {
            this.ensureCapacity(kmax, true);
        }
        if (((rec = this.storedRecords.get(k)) != null && rec.getMainDocument() != null || doc == null) && rec != null && rec.getMainDocument() != null && doc == null) {
            throw new IOException("Cannot read molecule in a previously readable position " + k + " (file truncated?)");
        }
        this.storeMainDoc(doc, k);
        if (doc == null) {
            return null;
        }
        this.performCommandsOnNewDoc(k);
        int n = this.docSource.getRecordCount() - this.docSourceOffset;
        if (n > this.theSize && (this.docSourceMax == 0 || n <= this.docSourceMax)) {
            this.setSize0(n);
        }
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener l = this.listeners.get(i);
                l.docProduced(this, doc, k);
            }
        }
        return doc;
    }

    private void performCommandsOnNewDoc(int k) {
        int i;
        String[] fieldkeys;
        StoredRecord rec = this.storedRecords.get(k);
        String[] stringArray = fieldkeys = rec != null ? rec.getFieldDocumentKeys() : null;
        if ((this.commandFlags & 1) != 0) {
            this.contractOrExpandSgroups(k, null, this.contractExpandSwitch, false);
            if (fieldkeys != null) {
                for (i = 0; i < fieldkeys.length; ++i) {
                    this.contractOrExpandSgroups(k, fieldkeys[i], this.contractExpandSwitch, false);
                }
            }
        }
        if ((this.commandFlags & 2) != 0) {
            this.hydrogenize(k, null, this.hydrogenizeSwitch, null, false);
            if (fieldkeys != null) {
                for (i = 0; i < fieldkeys.length; ++i) {
                    this.hydrogenize(k, fieldkeys[i], this.hydrogenizeSwitch, null, false);
                }
            }
        }
        if ((this.commandFlags & 4) != 0) {
            this.aromatize(k, null, this.aromatizeSwitch, this.aromatizeMethod, null, false);
            if (fieldkeys != null) {
                for (i = 0; i < fieldkeys.length; ++i) {
                    this.aromatize(k, fieldkeys[i], this.aromatizeSwitch, this.aromatizeMethod, null, false);
                }
            }
        }
        if ((this.commandFlags & 8) != 0) {
            this.clean(k, null, this.cleanDimension, this.cleanOptions, null, null, false);
            if (fieldkeys != null) {
                for (i = 0; i < fieldkeys.length; ++i) {
                    this.clean(k, fieldkeys[i], this.cleanDimension, this.cleanOptions, null, null, false);
                }
            }
        }
    }

    private void accessCachedDoc(int k) {
        if (this.accessQueue != null) {
            int index;
            StoredRecord rec;
            int n = this.accessQueue.length;
            int i = this.accessQueuePointer;
            int oldestk = this.accessQueue[i] - 1;
            if (k == oldestk) {
                this.accessQueuePointer = (i + 1) % n;
                return;
            }
            if (k < this.storedRecords.size()) {
                rec = this.storedRecords.get(k);
                int n2 = index = rec != null ? rec.getAccessQueueIndex() : 0;
                if (index != 0) {
                    int i0 = index - 1;
                    if ((i0 + 1) % n != this.accessQueuePointer) {
                        int dn = (this.accessQueuePointer - i0 - 1 + n) % n;
                        for (int j = 0; j < dn; ++j) {
                            int kk = this.accessQueue[(i0 + 1 + j) % n] - 1;
                            int ii = (i0 + j) % n;
                            this.accessQueue[ii] = kk + 1;
                            if (kk < 0) continue;
                            StoredRecord rr = this.storedRecords.get(kk);
                            rr.setAccessQueueIndex(ii + 1);
                        }
                        int ii = (this.accessQueuePointer - 1 + n) % n;
                        this.accessQueue[ii] = k + 1;
                        rec.setAccessQueueIndex(ii + 1);
                    }
                    return;
                }
            }
            if (oldestk >= 0) {
                this.storedRecords.set(oldestk, null);
            }
            int n3 = index = (rec = this.storedRecords.get(k)) != null ? rec.getAccessQueueIndex() : 0;
            if (index != 0) {
                this.removeAccessQueueEntry(index - 1);
            }
            i = this.accessQueuePointer;
            this.setAccessQueueEntry(i, k);
            this.accessQueuePointer = (i + 1) % n;
        }
    }

    private void removeAccessQueueEntry(int i) {
        this.setAccessQueueEntry(i, -1);
        if (i < this.accessQueuePointer) {
            for (int j = i + 1; j < this.accessQueuePointer; ++j) {
                int k = this.accessQueue[j] - 1;
                if (k == -1 || k >= this.theSize) continue;
                StoredRecord rec = this.storedRecords.get(k);
                rec.setAccessQueueIndex(j);
            }
            --this.accessQueuePointer;
            System.arraycopy(this.accessQueue, i + 1, this.accessQueue, i, this.accessQueuePointer - i);
            this.accessQueue[this.accessQueuePointer] = 0;
        } else if (i > this.accessQueuePointer) {
            for (int j = this.accessQueuePointer; j < i; ++j) {
                int k = this.accessQueue[j] - 1;
                if (k == -1) continue;
                StoredRecord rec = this.storedRecords.get(k);
                rec.setAccessQueueIndex(j + 2);
            }
            System.arraycopy(this.accessQueue, this.accessQueuePointer, this.accessQueue, this.accessQueuePointer + 1, i - this.accessQueuePointer);
            this.accessQueue[this.accessQueuePointer] = 0;
        }
    }

    private void removeAccessQueueEntryOnly(int i) {
        this.accessQueue[i] = 0;
        if (i < this.accessQueuePointer) {
            --this.accessQueuePointer;
            System.arraycopy(this.accessQueue, i + 1, this.accessQueue, i, this.accessQueuePointer - i);
            this.accessQueue[this.accessQueuePointer] = 0;
        } else if (i > this.accessQueuePointer) {
            System.arraycopy(this.accessQueue, this.accessQueuePointer, this.accessQueue, this.accessQueuePointer + 1, i - this.accessQueuePointer);
            this.accessQueue[this.accessQueuePointer] = 0;
        }
    }

    private void setAccessQueueEntry(int i, int k) {
        StoredRecord rec;
        int oldk = this.accessQueue[i] - 1;
        if (oldk >= 0 && oldk < this.storedRecords.size() && (rec = this.storedRecords.get(oldk)) != null) {
            rec.setAccessQueueIndex(0);
            if (rec.isEmpty()) {
                this.storedRecords.set(oldk, null);
            }
        }
        this.accessQueue[i] = k + 1;
        if (k >= 0) {
            rec = this.storedRecords.get(k);
            if (rec == null) {
                rec = new StoredRecord(null);
                this.storedRecords.set(k, rec);
            }
            rec.setAccessQueueIndex(i + 1);
        }
    }

    public MPropertyContainer getGlobalGUIProperties() {
        MPropertyContainer gProperties = null;
        if (this.docSource instanceof MolImporter) {
            gProperties = ((MolImporter)this.docSource).getGlobalProperties();
        }
        return gProperties;
    }

    public class CancellationException
    extends Exception {
        private CancellationException(String msg) {
            super(msg);
        }

        public void finishCancel() {
            MDocStorage.this.setSizeAfterExtend();
        }
    }

    public class RecordUnavailableException
    extends Exception {
        private int recordIndex;

        private RecordUnavailableException(int i, String msg) {
            super(msg);
            this.recordIndex = i;
        }

        public int getRecordIndex() {
            return this.recordIndex;
        }

        public int getRecordIndexMin() {
            return MDocStorage.this.docSourceOffset;
        }

        public int getRecordIndexMax() {
            int n = MDocStorage.this.docSource.getRecordCountMax();
            return MDocStorage.this.docSourceOffset + n - 1;
        }

        public boolean isEndReached() {
            return this.getRecordIndex() == this.getRecordIndexMax() + 1 && MDocStorage.this.sizeIsFinal;
        }
    }

    public static interface Listener {
        public void docProduced(MDocStorage var1, MDocument var2, int var3);

        public void storageSizeChanged(MDocStorage var1, int var2, int var3);

        public void storageSizeFinalized(MDocStorage var1);
    }
}

