/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view;

import chemaxon.license.LicenseThread;
import chemaxon.marvin.view.TaskScheduler;
import java.lang.reflect.InvocationTargetException;
import java.util.SortedSet;
import java.util.TreeSet;

public class SequentialScheduler
implements TaskScheduler {
    private Thread taskThread = null;
    private SortedSet<CmpRunnable> tasks = null;
    private Object lock = new Object();
    private boolean debug = false;

    public int getTaskCount() {
        SortedSet<CmpRunnable> set = this.tasks;
        return set != null ? set.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskThread() {
        Object object = this.lock;
        synchronized (object) {
            Thread t = Thread.currentThread();
            return t == this.taskThread;
        }
    }

    @Override
    public void invokeLater(Runnable task, int index) {
        this.invokeLater(task, index, "user task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable r, int priority, String desc) {
        Object object = this.lock;
        synchronized (object) {
            if (this.tasks == null) {
                this.tasks = new TreeSet<CmpRunnable>();
            }
            if (this.isEnqueued(r)) {
                return;
            }
            this.tasks.add(new CmpRunnable(r, priority, desc));
            this.recreateTaskThreadIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        CmpRunnable task;
        Object object = this.lock;
        synchronized (object) {
            if (this.tasks == null) {
                this.tasks = new TreeSet<CmpRunnable>();
            }
            if (this.isEnqueued(runnable)) {
                return;
            }
            task = new CmpRunnable(runnable, 0, "urgent");
            this.tasks.add(task);
            this.recreateTaskThreadIfNeeded();
            this.waitFor(task);
        }
        if (task.throwable != null) {
            throw new InvocationTargetException(task.throwable);
        }
    }

    private void recreateTaskThreadIfNeeded() {
        if (this.taskThread != null) {
            return;
        }
        this.taskThread = new LicenseThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean again;
                if (SequentialScheduler.this.debug) {
                    System.err.println(SequentialScheduler.this.toString() + ": taskThread.run");
                }
                Object object = SequentialScheduler.this.lock;
                synchronized (object) {
                    SequentialScheduler.this.lock.notify();
                }
                do {
                    Object object2;
                    CmpRunnable r;
                    again = false;
                    String msg = SequentialScheduler.this.toString();
                    while ((r = SequentialScheduler.this.next()) != null) {
                        if (SequentialScheduler.this.debug) {
                            System.err.println(msg + ": " + r.toString());
                        }
                        r.run();
                        if (SequentialScheduler.this.debug) {
                            System.err.println(msg + ": ...end task@" + Integer.toHexString(r.runnable.hashCode()));
                        }
                        object2 = SequentialScheduler.this.lock;
                        synchronized (object2) {
                            SequentialScheduler.this.lock.notify();
                        }
                        msg = SequentialScheduler.this.toString();
                    }
                    if (SequentialScheduler.this.debug) {
                        System.err.println(SequentialScheduler.this.toString() + ": no more tasks");
                    }
                    object2 = SequentialScheduler.this.lock;
                    synchronized (object2) {
                        if (SequentialScheduler.this.getTaskCount() != 0) {
                            again = true;
                        } else {
                            SequentialScheduler.this.taskThread = null;
                            SequentialScheduler.this.tasks = null;
                        }
                    }
                } while (again);
                if (SequentialScheduler.this.debug) {
                    System.err.println(SequentialScheduler.this.toString() + ": taskThread.run ended");
                }
            }
        };
        this.taskThread.start();
        try {
            this.lock.wait();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public void setDebug(boolean v) {
        this.debug = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForAll() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.waitFor(null);
        }
    }

    private void waitFor(CmpRunnable task) throws InterruptedException {
        while (this.tasks != null && (task == null || this.tasks.contains(task) || !task.stopped)) {
            this.lock.wait(250L);
            if (this.tasks == null || task != null && !this.tasks.contains(task) && task.stopped) continue;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued(Runnable r) {
        SortedSet<CmpRunnable> set = this.tasks;
        if (set == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            for (CmpRunnable t : set) {
                if (t.getRunnable() != r) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmpRunnable next() {
        Object object = this.lock;
        synchronized (object) {
            if (this.tasks.size() != 0) {
                CmpRunnable r = this.tasks.first();
                this.tasks.remove(r);
                return r;
            }
            return null;
        }
    }

    public String toString() {
        int h = this.hashCode();
        StringBuffer sb = new StringBuffer("SequentialScheduler@");
        sb.append(Integer.toHexString(h));
        sb.append("[");
        sb.append(this.getTaskCount());
        sb.append("]");
        return sb.toString();
    }

    private class CmpRunnable
    implements Runnable,
    Comparable {
        private Runnable runnable;
        private int priority;
        private String description;
        private boolean stopped;
        private Throwable throwable;

        public CmpRunnable(Runnable r, int p, String desc) {
            this.runnable = r;
            this.priority = p;
            this.description = desc;
            this.stopped = false;
            this.throwable = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            Object object = SequentialScheduler.this.lock;
            synchronized (object) {
                this.stopped = true;
                SequentialScheduler.this.lock.notify();
            }
        }

        public int compareTo(Object o) {
            CmpRunnable c = (CmpRunnable)o;
            if (c == this) {
                return 0;
            }
            if (this.priority < c.priority) {
                return -1;
            }
            if (this.priority > c.priority) {
                return 1;
            }
            if (this.hashCode() < c.hashCode()) {
                return -1;
            }
            return 1;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public String toString() {
            int h = this.runnable.hashCode();
            StringBuffer sb = new StringBuffer("task@");
            sb.append(Integer.toHexString(h));
            sb.append("[");
            if (this.priority == Integer.MAX_VALUE) {
                sb.append("MAX");
            } else {
                sb.append(this.priority);
            }
            if (this.description != null && this.description.length() != 0) {
                sb.append(",");
                sb.append(this.description);
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

