/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view;

import chemaxon.marvin.view.StoredRecord;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class StoredRecordArray {
    private int theSize;
    private StoredRecord[] array;
    private Map<Integer, StoredRecord> map;

    public StoredRecordArray(int n) {
        this.array = new StoredRecord[n];
        this.map = null;
        this.theSize = n;
    }

    public StoredRecord get(int i) {
        if (this.array != null) {
            return this.array[i];
        }
        return this.map.get(new Integer(i));
    }

    public void set(int i, StoredRecord r) {
        if (this.array != null) {
            this.array[i] = r;
        } else if (r != null) {
            this.map.put(new Integer(i), r);
        } else {
            this.map.remove(new Integer(i));
        }
    }

    public void unsetElements(int offset, int len) {
        int end = offset + len;
        if (this.array != null) {
            if (end > this.array.length) {
                end = this.array.length;
            }
            for (int i = offset; i < end; ++i) {
                this.array[i] = null;
            }
        } else {
            for (int i = offset; i < end; ++i) {
                this.map.remove(new Integer(i));
            }
        }
    }

    public void moveElements(int si, int ti, int n) {
        if (si == ti) {
            return;
        }
        if (this.array != null) {
            System.arraycopy(this.array, si, this.array, ti, n);
        } else {
            int d = ti - si;
            if (ti > si) {
                for (int i = si + n - 1; i >= si; --i) {
                    Integer oldkey = new Integer(i);
                    Integer newkey = new Integer(i + d);
                    StoredRecord r = this.map.get(oldkey);
                    if (r != null) {
                        this.map.remove(oldkey);
                        this.map.put(newkey, r);
                        continue;
                    }
                    this.map.remove(oldkey);
                    this.map.remove(newkey);
                }
            } else {
                int end = si + n;
                for (int i = si; i < end; ++i) {
                    Integer oldkey = new Integer(i);
                    Integer newkey = new Integer(i + d);
                    StoredRecord r = this.map.get(oldkey);
                    if (r != null) {
                        this.map.remove(oldkey);
                        this.map.put(newkey, r);
                        continue;
                    }
                    this.map.remove(oldkey);
                    this.map.remove(newkey);
                }
            }
        }
    }

    public void setSize(int n) {
        if (this.theSize == n) {
            return;
        }
        if (this.array != null) {
            int nmin = Math.min(this.theSize, n);
            StoredRecord[] newarr = new StoredRecord[n];
            System.arraycopy(this.array, 0, newarr, 0, nmin);
            this.array = newarr;
        } else {
            Iterator<Map.Entry<Integer, StoredRecord>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, StoredRecord> e = it.next();
                int i = e.getKey();
                if (i < n) continue;
                it.remove();
            }
        }
        this.theSize = n;
    }

    public int size() {
        return this.theSize;
    }

    public Iterator<StoredRecord> iterator() {
        if (this.array != null) {
            return new Iterator<StoredRecord>(){
                private int i = 0;
                private boolean remove_called = false;

                @Override
                public boolean hasNext() {
                    return this.i < StoredRecordArray.this.array.length;
                }

                @Override
                public StoredRecord next() {
                    this.remove_called = false;
                    return StoredRecordArray.this.array[this.i++];
                }

                @Override
                public void remove() {
                    if (this.remove_called) {
                        throw new IllegalStateException("StoredRecordArray iterator: remove() already called for index " + this.i);
                    }
                    if (this.i < 0) {
                        throw new IllegalStateException("StoredRecordArray iterator: remove() called before any next()");
                    }
                    ((StoredRecordArray)StoredRecordArray.this).array[this.i - 1] = null;
                    this.remove_called = true;
                }
            };
        }
        return new Iterator<StoredRecord>(){
            private Iterator<StoredRecord> it;
            {
                this.it = StoredRecordArray.this.map.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public StoredRecord next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    public Iterator<Entry> entryIterator() {
        if (this.array != null) {
            return new Iterator<Entry>(){
                private int i = 0;
                private boolean remove_called = false;

                @Override
                public boolean hasNext() {
                    return this.i < StoredRecordArray.this.array.length;
                }

                @Override
                public Entry next() {
                    this.remove_called = false;
                    Entry e = new Entry(this.i, StoredRecordArray.this.array[this.i]);
                    ++this.i;
                    return e;
                }

                @Override
                public void remove() {
                    if (this.remove_called) {
                        throw new IllegalStateException("StoredRecordArray entryIterator: remove() already called for index " + this.i);
                    }
                    if (this.i < 0) {
                        throw new IllegalStateException("StoredRecordArray entryIterator: remove() called before any next()");
                    }
                    ((StoredRecordArray)StoredRecordArray.this).array[this.i - 1] = null;
                    this.remove_called = true;
                }
            };
        }
        return new Iterator<Entry>(){
            private Iterator<Map.Entry<Integer, StoredRecord>> it;
            {
                this.it = new HashSet(StoredRecordArray.this.map.entrySet()).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Entry next() {
                Map.Entry<Integer, StoredRecord> e = this.it.next();
                return new Entry(e.getKey(), e.getValue());
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    public boolean isSparse() {
        return this.map != null;
    }

    public void setSparse(boolean v) {
        if (this.array != null) {
            TreeMap<Integer, StoredRecord> newmap = new TreeMap<Integer, StoredRecord>();
            for (int i = 0; i < this.array.length; ++i) {
                StoredRecord r = this.array[i];
                if (r == null) continue;
                newmap.put(new Integer(i), r);
            }
            this.array = null;
            this.map = Collections.synchronizedSortedMap(newmap);
        } else {
            StoredRecord[] newarray = new StoredRecord[this.theSize];
            for (Map.Entry<Integer, StoredRecord> e : this.map.entrySet()) {
                int i = e.getKey();
                newarray[i] = e.getValue();
            }
            this.array = newarray;
            this.map = null;
        }
    }

    public class Entry {
        private int theIndex;
        private StoredRecord theValue;

        private Entry(int i, StoredRecord r) {
            this.theIndex = i;
            this.theValue = r;
        }

        public int index() {
            return this.theIndex;
        }

        public StoredRecord value() {
            return this.theValue;
        }
    }
}

