/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import chemaxon.common.util.ColorParser;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class SDFColoring {
    private ViewPanel vpan;
    private String sdfColoringPropertyTag = null;
    private Properties sdfColoringProps = null;
    private ArrayList colorKeys = null;

    public SDFColoring(ViewPanel p, String tag, Properties props) {
        this.vpan = p;
        this.sdfColoringPropertyTag = tag;
        this.sdfColoringProps = props;
    }

    public void init() {
        if (this.sdfColoringPropertyTag == null || this.sdfColoringProps == null) {
            return;
        }
        this.colorKeys = new ArrayList();
        Enumeration<Object> e = this.sdfColoringProps.keys();
        while (e.hasMoreElements()) {
            Color color;
            String key = (String)e.nextElement();
            String colorSt = this.sdfColoringProps.getProperty(key);
            try {
                color = ColorParser.parseColor(colorSt);
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Unknown color string: \"" + colorSt + "\".");
                color = Color.black;
            }
            if (key.equals("other")) {
                this.vpan.setAtomSetColor(63, color);
                continue;
            }
            if (key.equals("empty")) {
                this.vpan.setAtomSetColor(0, color);
                continue;
            }
            this.vpan.setAtomSetColor(this.colorKeys.size() + 1, color);
            this.colorKeys.add(SDFColoring.orderTokens(key, "/"));
        }
    }

    public boolean perform(MDocument doc) {
        String symbols;
        boolean changed = false;
        Molecule mainmol = (Molecule)doc.getMainMoleculeGraph();
        Molecule primol = doc.getPrimaryMolecule();
        if (this.sdfColoringPropertyTag != null && (symbols = mainmol.getProperty(this.sdfColoringPropertyTag)) != null) {
            StringTokenizer st = new StringTokenizer(symbols, ";", true);
            ArrayList<String> atoms = new ArrayList<String>();
            boolean lastWasDelim = true;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals(";")) {
                    if (lastWasDelim) {
                        atoms.add(new String());
                    }
                    lastWasDelim = true;
                    continue;
                }
                lastWasDelim = false;
                atoms.add(token);
            }
            if (lastWasDelim) {
                atoms.add(new String());
            }
            if (atoms.size() != primol.getAtomCount()) {
                System.err.println("Warning : Property count and molecule number mismatch.");
            } else {
                for (int x = 0; x < atoms.size(); ++x) {
                    String atomSt = (String)atoms.get(x);
                    if (atomSt.length() <= 0) continue;
                    String newAtomSt = SDFColoring.orderTokens(atomSt, "/");
                    atoms.set(x, newAtomSt);
                    int num = this.colorKeys.indexOf(newAtomSt);
                    if (num != -1) {
                        primol.getAtom(x).setSetSeq(num + 1);
                    } else {
                        primol.getAtom(x).setSetSeq(63);
                    }
                    changed = true;
                }
            }
        }
        return changed;
    }

    private static String orderTokens(String input, String delimiter) {
        StringTokenizer st = null;
        if (delimiter == null) {
            return null;
        }
        if (delimiter.length() == 0) {
            return null;
        }
        st = new StringTokenizer(input, delimiter.substring(0, 1));
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        Collections.sort(list);
        String newSt = "";
        for (int y = 0; y < list.size(); ++y) {
            if (y > 0) {
                newSt = newSt + delimiter;
            }
            newSt = newSt + (String)list.get(y);
        }
        return newSt;
    }
}

