/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseManager;
import chemaxon.marvin.swing.ActionCheckBox;
import chemaxon.marvin.swing.ToggleButtonAction;
import chemaxon.marvin.view.CellType;
import chemaxon.marvin.view.swing.TwoLists;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.WholeNumberField;
import chemaxon.struc.MDocument;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MMoleculeProp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TableOptions {
    public static final int VH_AUTO = 0;
    public static final int VH_GRIDBAG = 1;
    public static final int VH_SPREADSHEET = 2;
    public static final int MMF_UNSET = 0;
    public static final int MMF_FIELD = 1;
    public static final int MMF_NOT_FIELD = 2;
    private static final int[] FONT_SIZES;
    private static final int[] FONT_SIZE_INDEXES;
    private static final int DEFAULT_FONT_SIZE = 10;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Component parentComponent;
    private JDialog dialog;
    private boolean canceled;
    private WholeNumberField startAtTextField;
    private WholeNumberField maxSizeTextField;
    private int viewHandlerType = 0;
    private JComboBox viewHandlerCombo;
    private int rowHeightValue = 64;
    private int columnWidthValue = 75;
    private int[] columnWidthValues = new int[]{64};
    private WholeNumberField rowHeightTextField;
    private WholeNumberField columnWidthTextField;
    private JComboBox maxColsCombo;
    private JComboBox maxRowsCombo;
    private boolean subsetChangableValue = false;
    private int startAtValue = 1;
    private int maxSizeValue = 0;
    private int maxColsValue = 4;
    private int maxRowsValue = 4;
    private boolean singleCellLabelShown = false;
    private JCheckBox fieldsShownCheckBox;
    private JCheckBox molNameShownCheckBox;
    private JCheckBox genNameShownCheckBox;
    private JCheckBox smilesShownCheckBox;
    private ToggleButtonAction fieldsShownAction;
    private ToggleButtonAction molNameShownAction;
    private ToggleButtonAction genNameShownAction;
    private ToggleButtonAction smilesShownAction;
    private int fieldFontSize;
    private int molNameFontSize;
    private int genNameFontSize;
    private int smilesFontSize;
    private JLabel fieldFontSizeLabel;
    private JLabel molNameFontSizeLabel;
    private JLabel genNameFontSizeLabel;
    private JLabel smilesFontSizeLabel;
    private JComboBox fieldFontSizeCombo;
    private JComboBox molNameFontSizeCombo;
    private JComboBox genNameFontSizeCombo;
    private JComboBox smilesFontSizeCombo;
    private TwoLists fieldList;
    private String[] sdFields = new String[0];
    private String[] selectedFields = new String[0];
    private boolean selectedFieldsSetAutomatically = false;
    private int mainMolFieldness = 0;
    private boolean allSelected = true;
    private Map<String, CellType> fieldTypeMap;
    private List<String> tmpFieldList;
    private Font listFont = null;
    private boolean isfieldsinitialized = false;
    private ActionListener myActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object src = ev.getSource();
            if (src instanceof Timer) {
                TableOptions.this.showDialog0();
                return;
            }
            String cmd = ev.getActionCommand();
            if (src == TableOptions.this.startAtTextField || src == TableOptions.this.maxSizeTextField || src == TableOptions.this.rowHeightTextField || src == TableOptions.this.columnWidthTextField || cmd.equals("ok")) {
                TableOptions.this.doIt();
            } else if (cmd.equals("cancel")) {
                TableOptions.this.dialog.setVisible(false);
            }
        }
    };

    TableOptions(Component p) {
        this.parentComponent = p;
        this.init();
    }

    public void setListFont(Font f) {
        this.listFont = f;
    }

    private void init() {
        this.fieldsShownAction = new ToggleButtonAction("fieldsShown", "'F'Show Fields"){

            @Override
            protected void doAction(ActionEvent ev) {
                boolean enable = this.isSelected();
                if (TableOptions.this.fieldList != null) {
                    TableOptions.this.fieldList.setEnabled(enable);
                }
                if (TableOptions.this.fieldFontSizeLabel != null) {
                    TableOptions.this.fieldFontSizeLabel.setEnabled(enable);
                }
                if (TableOptions.this.fieldFontSizeCombo != null) {
                    TableOptions.this.fieldFontSizeCombo.setEnabled(enable);
                }
            }
        };
        this.molNameShownAction = new ToggleButtonAction("molNameShown", "'M'Show Molecule Name"){

            @Override
            protected void doAction(ActionEvent ev) {
                boolean enable = this.isSelected();
                if (TableOptions.this.molNameFontSizeLabel != null) {
                    TableOptions.this.molNameFontSizeLabel.setEnabled(enable);
                }
                if (TableOptions.this.molNameFontSizeCombo != null) {
                    TableOptions.this.molNameFontSizeCombo.setEnabled(enable);
                }
            }
        };
        this.genNameShownAction = new ToggleButtonAction("genNameShown", "'g'Show Generated Name"){

            @Override
            protected void doAction(ActionEvent ev) {
                if (!LicenseHandler.getInstance().isLicensed("Structure to Name Plugin")) {
                    this.setSelected(false);
                    JOptionPane.showMessageDialog(TableOptions.this.getParentWindow(), LicenseManager.getLicenseExceptionPanel("Structure to Name Plugin"));
                }
                boolean enable = this.isSelected();
                if (TableOptions.this.genNameFontSizeLabel != null) {
                    TableOptions.this.genNameFontSizeLabel.setEnabled(enable);
                }
                if (TableOptions.this.genNameFontSizeCombo != null) {
                    TableOptions.this.genNameFontSizeCombo.setEnabled(enable);
                }
            }
        };
        this.smilesShownAction = new ToggleButtonAction("smilesShown", "'S'Show SMILES"){

            @Override
            protected void doAction(ActionEvent ev) {
                boolean enable = this.isSelected();
                if (TableOptions.this.smilesFontSizeLabel != null) {
                    TableOptions.this.smilesFontSizeLabel.setEnabled(enable);
                }
                if (TableOptions.this.smilesFontSizeCombo != null) {
                    TableOptions.this.smilesFontSizeCombo.setEnabled(enable);
                }
            }
        };
        this.fieldFontSize = 10;
        this.molNameFontSize = 10;
        this.genNameFontSize = 10;
        this.smilesFontSize = 10;
    }

    public void initFields() {
        this.fieldTypeMap = new HashMap<String, CellType>();
        this.tmpFieldList = new ArrayList<String>();
        this.sdFields = new String[0];
        if (this.selectedFieldsSetAutomatically) {
            this.selectedFields = new String[0];
        }
        this.mainMolFieldness = 0;
        this.isfieldsinitialized = true;
    }

    public void updateFields(MDocument doc) {
        if (doc != null) {
            if (!this.isfieldsinitialized) {
                this.initFields();
            }
            boolean changed = false;
            Map<String, CellType> map = this.fieldTypeMap;
            List<String> list = this.tmpFieldList;
            Molecule m = (Molecule)doc.getMainMoleculeGraph();
            int n = m.getPropertyCount();
            boolean mainMolIsField = false;
            MPropertyContainer props = m.properties();
            for (int k = 0; k < n; ++k) {
                String name = props.getKey(k);
                String lname = name.toLowerCase();
                MProp prop = props.get(name);
                int size = map.size();
                CellType type = CellType.TEXT;
                if (prop instanceof MMoleculeProp) {
                    type = CellType.MOLECULE;
                }
                map.put(lname, type);
                if (m != null) {
                    Object o;
                    Object object = o = prop != null ? prop.getPropValue() : null;
                    if (o == m) {
                        mainMolIsField = true;
                    }
                }
                if (map.size() == size) continue;
                list.add(name);
                changed = true;
            }
            this.mainMolFieldness = mainMolIsField ? (this.mainMolFieldness |= 1) : (this.mainMolFieldness |= 2);
            if (changed) {
                this.sdFields = new String[list.size()];
                list.toArray(this.sdFields);
                if (this.allSelected) {
                    this.selectedFields = new String[list.size()];
                    list.toArray(this.selectedFields);
                    this.selectedFieldsSetAutomatically = true;
                }
            }
        }
    }

    public void updateFields(MDocument[] docarr) {
        if (docarr != null) {
            for (int i = 0; i < docarr.length; ++i) {
                this.updateFields(docarr[i]);
            }
        }
    }

    public boolean isSubsetChangable() {
        return this.subsetChangableValue;
    }

    public void setSubsetChangable(boolean b) {
        this.subsetChangableValue = b;
    }

    public int getStartAt() {
        return this.startAtValue;
    }

    public void setStartAt(int s) {
        this.startAtValue = s;
    }

    public int getMaxSize() {
        return this.maxSizeValue;
    }

    public void setMaxSize(int n) {
        this.maxSizeValue = n;
    }

    public int getViewHandlerType() {
        return this.viewHandlerType;
    }

    public void setViewHandlerType(int t) {
        this.viewHandlerType = t;
        if (this.viewHandlerCombo != null) {
            this.viewHandlerCombo.setSelectedIndex(t);
        }
        if (this.maxColsCombo != null) {
            this.rowHeightTextField.setEnabled(t == 2 || t == 0);
            this.columnWidthTextField.setEnabled(t == 2 || t == 0);
            this.maxRowsCombo.setEnabled(t == 1 || t == 0);
            this.maxColsCombo.setEnabled(t == 1 || t == 0);
        }
    }

    public void setRowHeight(int h) {
        this.rowHeightValue = h;
    }

    public int getRowHeight() {
        return this.rowHeightValue;
    }

    public void setColumnWidth(int w) {
        this.columnWidthValue = w;
    }

    public int getColumnWidth() {
        return this.columnWidthValue;
    }

    public void setColumnWidth(int i, int w) {
        if (this.columnWidthValues.length <= i) {
            int[] tmp = new int[3 * (i + 1) / 2];
            System.arraycopy(this.columnWidthValues, 0, tmp, 0, this.columnWidthValues.length);
            this.columnWidthValues = tmp;
        }
        this.columnWidthValues[i] = w;
    }

    public int getColumnWidth(int i) {
        int w = 0;
        if (this.columnWidthValues != null && i < this.columnWidthValues.length) {
            w = this.columnWidthValues[i];
        }
        return w != 0 ? w : this.getColumnWidth();
    }

    public String getColumnWidthsString() {
        StringBuilder sb = new StringBuilder();
        if (this.columnWidthValues != null) {
            for (int i = 0; i < this.columnWidthValues.length; ++i) {
                int w = this.columnWidthValues[i];
                if (w == 0) continue;
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(i);
                sb.append(':');
                sb.append(w);
            }
        }
        return sb.toString();
    }

    public int getMaxCols() {
        return this.maxColsValue;
    }

    public void setMaxCols(int v) {
        this.maxColsValue = v;
    }

    public int getMaxRows() {
        return this.maxRowsValue;
    }

    public void setMaxRows(int v) {
        this.maxRowsValue = v;
    }

    public boolean isMolNameShown() {
        return this.molNameShownAction.isSelected();
    }

    public void setMolNameShown(boolean v) {
        this.molNameShownAction.setSelected(v);
    }

    ToggleButtonAction getMolNameShownAction() {
        return this.molNameShownAction;
    }

    public int getMolNameFontSize() {
        return this.molNameFontSize;
    }

    public void setMolNameFontSize(int v) {
        this.molNameFontSize = v;
    }

    public boolean isGenNameShown() {
        return this.genNameShownAction.isSelected();
    }

    public void setGenNameShown(boolean v) {
        this.genNameShownAction.setSelected(v);
    }

    ToggleButtonAction getGenNameShownAction() {
        return this.genNameShownAction;
    }

    public int getGenNameFontSize() {
        return this.genNameFontSize;
    }

    public void setGenNameFontSize(int v) {
        this.genNameFontSize = v;
    }

    public boolean isSMILESShown() {
        return this.smilesShownAction.isSelected();
    }

    public void setSMILESShown(boolean v) {
        this.smilesShownAction.setSelected(v);
    }

    ToggleButtonAction getSMILESShownAction() {
        return this.smilesShownAction;
    }

    public int getSMILESFontSize() {
        return this.smilesFontSize;
    }

    public void setSMILESFontSize(int v) {
        this.smilesFontSize = v;
    }

    public boolean isSingleCellLabelShown() {
        return this.singleCellLabelShown;
    }

    public void setSingleCellLabelShown(boolean v) {
        this.singleCellLabelShown = v;
    }

    public boolean getFieldsShown() {
        return this.fieldsShownAction.isSelected();
    }

    public void setFieldsShown(boolean v) {
        this.fieldsShownAction.setSelected(v);
    }

    ToggleButtonAction getFieldsShownAction() {
        return this.fieldsShownAction;
    }

    public int getFieldFontSize() {
        return this.fieldFontSize;
    }

    public void setFieldFontSize(int v) {
        this.fieldFontSize = v;
    }

    public String[] getSelectedFields() {
        return this.selectedFields;
    }

    public int getSelectedFieldCount() {
        return this.selectedFields != null ? this.selectedFields.length : 0;
    }

    public CellType[] getSelectedFieldTypes() {
        String[] fields = this.selectedFields;
        if (fields != null) {
            CellType[] types = new CellType[fields.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = this.fieldTypeMap.get(fields[i].toLowerCase());
            }
            return types;
        }
        return null;
    }

    public int getMainMolFieldness() {
        return this.mainMolFieldness;
    }

    public void setSelectedFields(String[] fields) {
        this.selectedFields = new String[fields.length];
        this.selectedFieldsSetAutomatically = false;
        for (int i = 0; i < fields.length; ++i) {
            this.selectedFields[i] = fields[i];
        }
        this.allSelected = false;
    }

    public void showDialog() {
        Timer t = new Timer(20, this.myActionListener);
        t.setRepeats(false);
        t.start();
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners.contains(l)) {
            return;
        }
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    private void showDialog0() {
        Window win = this.getParentWindow();
        this.dialog = win instanceof Dialog ? new JDialog((Dialog)win, "Table Options", true) : new JDialog((Frame)win, "Table Options", true);
        this.dialog.setResizable(false);
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets.left = 10;
        gbc.insets.right = 10;
        gbc.fill = 2;
        gbl.setConstraints(this.addMoleculeSubsetPanel(this.dialog), gbc);
        ++gbc.gridy;
        gbl.setConstraints(this.addTableTypePanel(this.dialog), gbc);
        ++gbc.gridy;
        gbl.setConstraints(this.addVisibleSizePanel(this.dialog), gbc);
        ++gbc.gridy;
        gbc.anchor = 18;
        gbl.setConstraints(this.addFieldsPanel(this.dialog), gbc);
        gbc.anchor = 10;
        gbc.insets.top = 20;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        gbl.setConstraints(this.addOkCancelPanel(this.dialog), gbc);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(win);
        this.canceled = true;
        int prevStartAt = this.startAtValue;
        int prevMaxSize = this.maxSizeValue;
        int prevMaxRows = this.maxRowsValue;
        int prevMaxCols = this.maxColsValue;
        boolean prevMolNameShown = this.molNameShownAction.isSelected();
        boolean prevGenNameShown = this.genNameShownAction.isSelected();
        boolean prevSmilesShown = this.smilesShownAction.isSelected();
        boolean prevFieldsShown = this.fieldsShownAction.isSelected();
        int prevMolNameFontSize = this.molNameFontSize;
        int prevGenNameFontSize = this.genNameFontSize;
        int prevSmilesFontSize = this.smilesFontSize;
        int prevFieldFontSize = this.fieldFontSize;
        this.dialog.setVisible(true);
        if (this.canceled) {
            this.startAtValue = prevStartAt;
            this.maxSizeValue = prevMaxSize;
            this.maxRowsValue = prevMaxRows;
            this.maxColsValue = prevMaxCols;
            this.molNameShownAction.setSelected(prevMolNameShown);
            this.genNameShownAction.setSelected(prevGenNameShown);
            this.smilesShownAction.setSelected(prevSmilesShown);
            this.fieldsShownAction.setSelected(prevFieldsShown);
            this.molNameFontSize = prevMolNameFontSize;
            this.genNameFontSize = prevGenNameFontSize;
            this.smilesFontSize = prevSmilesFontSize;
            this.fieldFontSize = prevFieldFontSize;
        } else {
            ActionEvent ev = new ActionEvent(this, 0, "showMolecules");
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ActionListener l = this.actionListeners.get(i);
                l.actionPerformed(ev);
            }
        }
    }

    private JPanel addOkCancelPanel(JDialog dialog) {
        JPanel panel = new JPanel();
        dialog.getContentPane().add(panel);
        JButton btn = new JButton("OK");
        panel.add(btn);
        btn.setActionCommand("ok");
        btn.setMnemonic('O');
        btn.addActionListener(this.myActionListener);
        btn = new JButton("Cancel");
        panel.add(btn);
        btn.setActionCommand("cancel");
        btn.setMnemonic('C');
        btn.addActionListener(this.myActionListener);
        return panel;
    }

    private JPanel addMoleculeSubsetPanel(JDialog dialog) {
        JPanel panel = new JPanel();
        dialog.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Molecule subset to display"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        JLabel label = new JLabel("Starting index:");
        panel.add(label);
        label.setEnabled(this.subsetChangableValue);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.gridwidth = 1;
        gbc1.weightx = 1.0;
        gbc1.anchor = 18;
        gbc1.insets.right = 10;
        gbl1.setConstraints(label, gbc1);
        this.startAtTextField = new WholeNumberField(this.startAtValue, 10, 1);
        panel.add(this.startAtTextField);
        this.startAtTextField.setHorizontalAlignment(4);
        this.startAtTextField.setEnabled(this.subsetChangableValue);
        this.startAtTextField.addActionListener(this.myActionListener);
        ++gbc1.gridx;
        gbl1.setConstraints(this.startAtTextField, gbc1);
        label = new JLabel("Number of molecules or 0:");
        panel.add(label);
        label.setEnabled(this.subsetChangableValue);
        gbc1.gridx = 0;
        ++gbc1.gridy;
        gbl1.setConstraints(label, gbc1);
        this.maxSizeTextField = new WholeNumberField(this.maxSizeValue, 10, 3);
        panel.add(this.maxSizeTextField);
        this.maxSizeTextField.setHorizontalAlignment(4);
        this.maxSizeTextField.setEnabled(this.subsetChangableValue);
        this.maxSizeTextField.addActionListener(this.myActionListener);
        ++gbc1.gridx;
        gbl1.setConstraints(this.maxSizeTextField, gbc1);
        return panel;
    }

    private JPanel addTableTypePanel(JDialog dialog) {
        JPanel panel = new JPanel();
        dialog.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Table type"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.gridwidth = 1;
        gbc1.weightx = 1.0;
        gbc1.insets.right = 10;
        String[] list = new String[3];
        list[0] = "Automatic";
        list[2] = "Spreadsheet";
        list[1] = "Molecule matrix";
        this.viewHandlerCombo = new JComboBox<String>(list);
        panel.add(this.viewHandlerCombo);
        this.viewHandlerCombo.setActionCommand("viewHandler");
        this.viewHandlerCombo.setSelectedIndex(this.viewHandlerType);
        this.viewHandlerCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    JComboBox cb = (JComboBox)ev.getSource();
                    int t = cb.getSelectedIndex();
                    if (t == 1 || t == 2) {
                        TableOptions.this.fieldsShownAction.setSelected(t == 2);
                    }
                    TableOptions.this.maxRowsCombo.setEnabled(t == 1);
                    TableOptions.this.maxColsCombo.setEnabled(t == 1);
                    TableOptions.this.rowHeightTextField.setEnabled(t == 2);
                    TableOptions.this.columnWidthTextField.setEnabled(t == 2);
                }
            }
        });
        gbc1.fill = 0;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.viewHandlerCombo, gbc1);
        return panel;
    }

    private JPanel addVisibleSizePanel(JDialog dialog) {
        JPanel panel = new JPanel();
        dialog.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Size of visible part"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        JLabel label = new JLabel("Row height:", 2);
        panel.add(label);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.gridwidth = 1;
        gbc1.weightx = 0.0;
        gbc1.anchor = 17;
        gbc1.fill = 0;
        gbc1.insets.right = 10;
        gbl1.setConstraints(label, gbc1);
        this.rowHeightTextField = new WholeNumberField(this.rowHeightValue, 4, 1);
        panel.add(this.rowHeightTextField);
        this.rowHeightTextField.setHorizontalAlignment(4);
        this.rowHeightTextField.setEnabled(this.viewHandlerType == 2 || this.viewHandlerType == 0);
        this.rowHeightTextField.addActionListener(this.myActionListener);
        ++gbc1.gridx;
        gbc1.insets.right = 0;
        gbl1.setConstraints(this.rowHeightTextField, gbc1);
        ++gbc1.gridx;
        gbc1.insets.right = 20;
        gbc1.weightx = 1.0;
        gbl1.setConstraints(panel.add(new JLabel("px", 2)), gbc1);
        label = new JLabel("Column width:", 2);
        panel.add(label);
        gbc1.gridx = 0;
        ++gbc1.gridy;
        gbc1.weightx = 0.0;
        gbl1.setConstraints(label, gbc1);
        this.columnWidthTextField = new WholeNumberField(this.columnWidthValue, 4, 3);
        panel.add(this.columnWidthTextField);
        this.columnWidthTextField.setHorizontalAlignment(4);
        this.columnWidthTextField.setEnabled(this.viewHandlerType == 2 || this.viewHandlerType == 0);
        this.columnWidthTextField.addActionListener(this.myActionListener);
        ++gbc1.gridx;
        gbc1.insets.right = 0;
        gbl1.setConstraints(this.columnWidthTextField, gbc1);
        ++gbc1.gridx;
        gbc1.insets.right = 20;
        gbc1.weightx = 1.0;
        gbl1.setConstraints(panel.add(new JLabel("px", 2)), gbc1);
        ++gbc1.gridx;
        label = new JLabel("Max. Rows:", 2);
        panel.add(label);
        gbc1.gridy = 0;
        gbc1.fill = 2;
        gbc1.weightx = 1.0;
        gbc1.anchor = 10;
        gbc1.insets.right = 10;
        gbl1.setConstraints(label, gbc1);
        String[] list = new String[100];
        for (int i = 0; i < list.length - 1; ++i) {
            list[i] = String.valueOf(i + 1);
        }
        list[list.length - 1] = "?";
        this.maxRowsCombo = new JComboBox<String>(list);
        panel.add(this.maxRowsCombo);
        this.maxRowsCombo.setSelectedIndex(this.maxRowsValue <= list.length ? this.maxRowsValue - 1 : list.length - 1);
        this.maxRowsCombo.setEnabled(this.viewHandlerType == 1 || this.viewHandlerType == 0);
        ++gbc1.gridx;
        gbc1.fill = 0;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.maxRowsCombo, gbc1);
        label = new JLabel("Max. Columns:", 2);
        panel.add(label);
        gbc1.gridx = 3;
        ++gbc1.gridy;
        gbc1.fill = 2;
        gbc1.anchor = 10;
        gbl1.setConstraints(label, gbc1);
        this.maxColsCombo = new JComboBox<String>(list);
        panel.add(this.maxColsCombo);
        this.maxColsCombo.setSelectedIndex(this.maxColsValue <= list.length ? this.maxColsValue - 1 : list.length - 1);
        this.maxColsCombo.setEnabled(this.viewHandlerType == 1 || this.viewHandlerType == 0);
        ++gbc1.gridx;
        gbc1.fill = 0;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.maxColsCombo, gbc1);
        return panel;
    }

    private JPanel addFieldsPanel(JDialog dialog) {
        JPanel panel = new JPanel();
        dialog.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Fields"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        this.fieldsShownCheckBox = new ActionCheckBox(this.fieldsShownAction);
        panel.add(this.fieldsShownCheckBox);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.gridwidth = 1;
        gbc1.weightx = 1.0;
        gbc1.weighty = 1.0;
        gbc1.anchor = 18;
        gbc1.insets.right = 10;
        gbl1.setConstraints(this.fieldsShownCheckBox, gbc1);
        this.fieldFontSizeLabel = new JLabel("Font Size:", 4);
        panel.add(this.fieldFontSizeLabel);
        this.fieldFontSizeLabel.setEnabled(this.getFieldsShown());
        ++gbc1.gridx;
        gbc1.fill = 2;
        gbc1.anchor = 10;
        gbl1.setConstraints(this.fieldFontSizeLabel, gbc1);
        Integer[] list = new Integer[FONT_SIZES.length];
        int fieldfntszi = FONT_SIZE_INDEXES[this.fieldFontSize];
        int molnamefntszi = FONT_SIZE_INDEXES[this.molNameFontSize];
        int iupacnamefntszi = FONT_SIZE_INDEXES[this.genNameFontSize];
        int smilesfntszi = FONT_SIZE_INDEXES[this.smilesFontSize];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new Integer(FONT_SIZES[i]);
        }
        this.fieldFontSizeCombo = new JComboBox<Integer>(list);
        panel.add(this.fieldFontSizeCombo);
        this.fieldFontSizeCombo.setSelectedIndex(fieldfntszi >= 0 ? fieldfntszi : 0);
        this.fieldFontSizeCombo.setEnabled(this.getFieldsShown());
        this.fieldFontSizeCombo.setActionCommand("fieldFontSize");
        ++gbc1.gridx;
        gbc1.fill = 0;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.fieldFontSizeCombo, gbc1);
        this.molNameShownCheckBox = new ActionCheckBox(this.molNameShownAction);
        panel.add(this.molNameShownCheckBox);
        gbc1.gridx = 0;
        ++gbc1.gridy;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.molNameShownCheckBox, gbc1);
        this.molNameFontSizeLabel = new JLabel("Font Size:", 4);
        panel.add(this.molNameFontSizeLabel);
        this.molNameFontSizeLabel.setEnabled(this.isMolNameShown());
        ++gbc1.gridx;
        gbc1.fill = 2;
        gbc1.anchor = 10;
        gbl1.setConstraints(this.molNameFontSizeLabel, gbc1);
        this.molNameFontSizeCombo = new JComboBox<Integer>(list);
        panel.add(this.molNameFontSizeCombo);
        this.molNameFontSizeCombo.setSelectedIndex(molnamefntszi >= 0 ? molnamefntszi : 0);
        this.molNameFontSizeCombo.setEnabled(this.isMolNameShown());
        ++gbc1.gridx;
        gbc1.fill = 0;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.molNameFontSizeCombo, gbc1);
        this.genNameShownCheckBox = new ActionCheckBox(this.genNameShownAction);
        panel.add(this.genNameShownCheckBox);
        gbc1.gridx = 0;
        ++gbc1.gridy;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.genNameShownCheckBox, gbc1);
        this.genNameFontSizeLabel = new JLabel("Font Size:", 4);
        panel.add(this.genNameFontSizeLabel);
        this.genNameFontSizeLabel.setEnabled(this.isSMILESShown());
        ++gbc1.gridx;
        gbc1.fill = 2;
        gbc1.anchor = 10;
        gbl1.setConstraints(this.genNameFontSizeLabel, gbc1);
        this.genNameFontSizeCombo = new JComboBox<Integer>(list);
        panel.add(this.genNameFontSizeCombo);
        this.genNameFontSizeCombo.setSelectedIndex(iupacnamefntszi >= 0 ? iupacnamefntszi : 0);
        this.genNameFontSizeCombo.setEnabled(this.isSMILESShown());
        ++gbc1.gridx;
        gbc1.fill = 0;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.genNameFontSizeCombo, gbc1);
        this.smilesShownCheckBox = new ActionCheckBox(this.smilesShownAction);
        panel.add(this.smilesShownCheckBox);
        gbc1.gridx = 0;
        ++gbc1.gridy;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.smilesShownCheckBox, gbc1);
        this.smilesFontSizeLabel = new JLabel("Font Size:", 4);
        panel.add(this.smilesFontSizeLabel);
        this.smilesFontSizeLabel.setEnabled(this.isSMILESShown());
        ++gbc1.gridx;
        gbc1.fill = 2;
        gbc1.anchor = 10;
        gbl1.setConstraints(this.smilesFontSizeLabel, gbc1);
        this.smilesFontSizeCombo = new JComboBox<Integer>(list);
        panel.add(this.smilesFontSizeCombo);
        this.smilesFontSizeCombo.setSelectedIndex(smilesfntszi >= 0 ? smilesfntszi : 0);
        this.smilesFontSizeCombo.setEnabled(this.isSMILESShown());
        ++gbc1.gridx;
        gbc1.fill = 0;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.smilesFontSizeCombo, gbc1);
        gbc1.gridx = 0;
        ++gbc1.gridy;
        gbc1.gridwidth = 3;
        this.fieldList = new TwoLists(this.sdFields, this.selectedFields, this.allSelected);
        panel.add(this.fieldList);
        this.fieldList.setListFont(this.listFont);
        this.fieldList.setEnabled(this.fieldsShownAction.isSelected());
        gbl1.setConstraints(this.fieldList, gbc1);
        return panel;
    }

    private void doIt() {
        this.startAtValue = this.startAtTextField.getValue();
        this.maxSizeValue = this.maxSizeTextField.getValue();
        this.viewHandlerType = this.viewHandlerCombo != null ? this.viewHandlerCombo.getSelectedIndex() : 1;
        try {
            ((ViewPanel)this.parentComponent).getUserSettings().setViewLayout(this.viewHandlerType);
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        this.rowHeightValue = this.rowHeightTextField.getValue();
        this.columnWidthValue = this.columnWidthTextField.getValue();
        this.maxRowsValue = this.maxRowsCombo.getSelectedIndex() + 1;
        this.maxColsValue = this.maxColsCombo.getSelectedIndex() + 1;
        this.fieldFontSize = FONT_SIZES[this.fieldFontSizeCombo.getSelectedIndex()];
        this.molNameFontSize = FONT_SIZES[this.molNameFontSizeCombo.getSelectedIndex()];
        if (this.genNameFontSizeCombo != null) {
            int i = this.genNameFontSizeCombo.getSelectedIndex();
            this.genNameFontSize = FONT_SIZES[i];
        }
        this.smilesFontSize = FONT_SIZES[this.smilesFontSizeCombo.getSelectedIndex()];
        this.selectedFields = this.fieldList.getListData2();
        this.selectedFieldsSetAutomatically = false;
        this.allSelected = this.fieldList.getAllSelected();
        this.dialog.setVisible(false);
        this.canceled = false;
    }

    private Window getParentWindow() {
        for (Component c = this.parentComponent; c != null; c = c.getParent()) {
            if (!(c instanceof Window)) continue;
            return (Window)c;
        }
        return null;
    }

    static {
        int i;
        FONT_SIZE_INDEXES = new int[40];
        for (i = 0; i < FONT_SIZE_INDEXES.length; ++i) {
            TableOptions.FONT_SIZE_INDEXES[i] = -1;
        }
        FONT_SIZES = new int[25];
        i = 0;
        while (i < FONT_SIZES.length) {
            int k;
            TableOptions.FONT_SIZES[i] = k = 8 + i;
            TableOptions.FONT_SIZE_INDEXES[k] = i++;
        }
    }
}

