/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TwoLists
extends JPanel
implements ActionListener {
    private String[] listData1;
    private String[] listData2;
    private JList list1;
    private JList list2;
    private JButton addButton;
    private JButton addAllButton;
    private JButton removeButton;
    private JButton removeAllButton;
    private boolean allSelected = false;

    public TwoLists(String[] l1, String[] l2, boolean all) {
        this.allSelected = all;
        if (l1 == null) {
            l1 = new String[]{};
        }
        this.listData1 = new String[l1.length];
        System.arraycopy(l1, 0, this.listData1, 0, l1.length);
        l1 = this.listData1;
        if (l2 == null) {
            l2 = new String[]{};
        }
        this.listData2 = new String[l2.length];
        System.arraycopy(l2, 0, this.listData2, 0, l2.length);
        l2 = this.listData2;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.list1 = new JList<String>(l1);
        JScrollPane pane1 = new JScrollPane(this.list1, 20, 30);
        this.add(pane1);
        pane1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Available"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.list1.setSelectionMode(2);
        this.list1.setFixedCellWidth(100);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbl.setConstraints(pane1, gbc);
        JPanel panel = this.addSelectRemovePanel();
        this.add(panel);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbl.setConstraints(panel, gbc);
        this.list2 = new JList<String>(l2);
        JScrollPane pane2 = new JScrollPane(this.list2, 20, 30);
        this.add(pane2);
        pane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Selected"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.list2.setSelectionMode(2);
        this.list2.setFixedCellWidth(100);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbl.setConstraints(pane2, gbc);
    }

    public boolean getAllSelected() {
        return this.allSelected;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd.equals("add") || cmd.equals("addAll") || cmd.equals("remove") || cmd.equals("removeAll")) {
            Vector<String> v = new Vector<String>();
            if (cmd.equals("add")) {
                int i;
                int[] selected = this.list1.getSelectedIndices();
                if (selected.length == 0) {
                    return;
                }
                for (i = 0; i < this.listData2.length; ++i) {
                    v.addElement(this.listData2[i]);
                }
                for (i = 0; i < selected.length; ++i) {
                    String key = this.listData1[selected[i]];
                    if (v.contains(key)) continue;
                    v.addElement(key);
                }
                this.list1.clearSelection();
            } else if (cmd.equals("addAll")) {
                int i;
                this.allSelected = true;
                for (i = 0; i < this.listData2.length; ++i) {
                    v.addElement(this.listData2[i]);
                }
                for (i = 0; i < this.listData1.length; ++i) {
                    String key = this.listData1[i];
                    if (v.contains(key)) continue;
                    v.addElement(key);
                }
            } else if (cmd.equals("remove")) {
                this.allSelected = false;
                for (int i = 0; i < this.listData2.length; ++i) {
                    if (this.list2.isSelectedIndex(i)) continue;
                    v.addElement(this.listData2[i]);
                }
                if (v.size() == this.listData2.length) {
                    return;
                }
                this.list2.clearSelection();
            } else {
                this.allSelected = false;
            }
            Object[] l2 = new String[v.size()];
            v.copyInto(l2);
            this.list2.setListData(l2);
            String[] old = this.listData2;
            this.listData2 = l2;
            this.firePropertyChange("listData2", old, l2);
        }
    }

    private JPanel addSelectRemovePanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        this.addButton = new JButton("Add");
        panel.add(this.addButton);
        this.addButton.setActionCommand("add");
        this.addButton.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbl.setConstraints(this.addButton, gbc);
        this.removeButton = new JButton("Remove");
        panel.add(this.removeButton);
        this.removeButton.setActionCommand("remove");
        this.removeButton.addActionListener(this);
        ++gbc.gridy;
        gbl.setConstraints(this.removeButton, gbc);
        this.addAllButton = new JButton("Add All");
        panel.add(this.addAllButton);
        this.addAllButton.setActionCommand("addAll");
        this.addAllButton.addActionListener(this);
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbl.setConstraints(this.addAllButton, gbc);
        this.removeAllButton = new JButton("Remove All");
        panel.add(this.removeAllButton);
        this.removeAllButton.setActionCommand("removeAll");
        this.removeAllButton.addActionListener(this);
        gbc.insets.top = 0;
        ++gbc.gridy;
        gbl.setConstraints(this.removeAllButton, gbc);
        return panel;
    }

    @Override
    public void setEnabled(boolean v) {
        super.setEnabled(v);
        this.list1.setEnabled(v);
        this.list2.setEnabled(v);
        this.addButton.setEnabled(v);
        this.addAllButton.setEnabled(v);
        this.removeButton.setEnabled(v);
        this.removeAllButton.setEnabled(v);
    }

    public String[] getListData2() {
        return this.listData2;
    }

    public void setListData2(String[] data) {
        this.listData2 = data;
        this.list2.setListData(data);
    }

    public void setListFont(Font f) {
        this.list1.setFont(f);
        this.list2.setFont(f);
    }
}

