/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import chemaxon.marvin.common.swing.MolButton;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.SequentialScheduler;
import chemaxon.marvin.view.swing.CellFiller;
import chemaxon.marvin.view.swing.RecordFetcher;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.VisibleDocuments;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;

public abstract class ViewHandler
implements Serializable {
    private boolean debug = false;
    private VisibleDocuments visibleDocs;

    public abstract String getNameAndArgs();

    protected abstract void destruct();

    protected abstract void init(ViewPanel var1, Window var2);

    protected abstract void setMarvinCursor();

    protected abstract void initTransientC();

    public abstract boolean isIncrementable();

    protected boolean getDebug() {
        return this.debug;
    }

    protected void setDebug(boolean g) {
        this.debug = g;
        SequentialScheduler scheduler = this.getScheduler();
        if (scheduler != null) {
            scheduler.setDebug(g);
        }
    }

    public abstract MDocStorage getStorage();

    public abstract CellFiller getCellFiller();

    public SequentialScheduler getScheduler() {
        return this.getRecordFetcher().getScheduler();
    }

    public abstract RecordFetcher getRecordFetcher();

    public abstract int getColumnCount();

    public abstract int getNumRecordsInARow();

    public int getNumRecords() {
        MDocStorage ds = this.getStorage();
        if (ds != null) {
            MDocSource docsrc = ds.getDocSource();
            int min = ds.getOffset();
            int dssize = ds.getSize();
            int docsrcn = docsrc != null ? docsrc.getRecordCountMax() - min : dssize;
            int rfmax = this.getRecordFetcher().getEndRecordIndex() - min;
            return Math.min(rfmax, docsrcn);
        }
        return 0;
    }

    protected abstract void setNumRecords(int var1);

    protected abstract void storageSizeChanged(int var1, int var2);

    protected abstract void storageSizeFinalized(int var1);

    public abstract int getNumMoleculesInRecord();

    public abstract String[] readTextFieldValues(int var1, String[] var2);

    protected abstract void setMainDocumentInRecord(int var1, MDocument var2);

    protected abstract void initMainDocumentInRecord(int var1, boolean var2);

    protected abstract void setDocument(int var1, int var2, MDocument var3);

    protected abstract MDocument getCachedDocument(int var1, int var2);

    public abstract MolPainter getMolPainter(int var1);

    protected abstract void setMolPainter(int var1, int var2, MolPainter var3);

    public final void setMolPainter(int icell, MolPainter p) {
        int irec = this.recordIndexFromMolCellIndex(icell);
        int im = icell - irec * this.getNumMoleculesInRecord();
        this.setMolPainter(irec, im, p);
    }

    public abstract void setMolCenter(int var1, DPoint3 var2);

    public abstract DPoint3 getMolCenter(int var1);

    protected abstract void molLoaded(MDocument var1, int var2);

    protected abstract void setValueAt(Object var1, int var2, String var3);

    public abstract void setAtomSetSeq(int var1, int var2, int var3);

    public abstract void setBondSetSeq(int var1, int var2, int var3, int var4);

    public abstract void setBondSetSeqAll(int var1, int var2);

    protected abstract void setWinScale(double var1);

    protected abstract void setWinScale(int var1, double var2);

    protected abstract void setDetachable(boolean var1);

    protected abstract void setWinmode(int var1, int var2);

    public abstract Window getFrame(int var1);

    protected abstract void updateRecord(int var1);

    protected abstract void repaintMolComponent(int var1);

    protected abstract void repaintMols();

    protected abstract void repaintText();

    protected abstract void setVisibleSize(int var1, int var2);

    public abstract void setAnimated(int var1, boolean var2);

    public abstract ViewCanvas getCanvas(int var1);

    protected void setTableContentsEnabled(boolean v) {
    }

    public VisibleDocuments getVisibleDocs() {
        return this.visibleDocs;
    }

    public void setVisibleDocs(VisibleDocuments vd) {
        this.visibleDocs = vd;
    }

    public abstract void updateVisibleCells(int var1);

    protected abstract void removeCellFromPanel(int var1);

    protected abstract void addCanvasAgain(int var1, int var2);

    public abstract int getVisibleRows();

    public abstract int getVisibleCols();

    public int getVisibleCellIndex(int absindex) {
        return -1;
    }

    public int getAbsoluteCellIndex(int visibleIndex) {
        return -1;
    }

    public void setBorderWidth(int b) {
    }

    public String getL(int n) {
        return null;
    }

    public void setL(int n, String s) {
    }

    public abstract void setRecordIDBackground(int var1, Color var2);

    public abstract void setRecordIDForeground(int var1, Color var2);

    public void setActionB(int i, String s) {
    }

    public void setActionC(int i, String s) {
    }

    public boolean getC(int n) {
        return false;
    }

    public void setC(int n, boolean s) {
    }

    public String getT(int n) {
        return null;
    }

    public void setT(int n, String s) {
    }

    public AbstractButton getVisibleButtonB(int i) {
        return null;
    }

    public AbstractButton getVisibleButtonC(int i) {
        return null;
    }

    public int indexOfButtonC(AbstractButton cb) {
        return -1;
    }

    public int indexOfButtonB(AbstractButton b) {
        return -1;
    }

    public void unsetWinmode(int i, MolPainter painter, double tabScale) {
    }

    protected void setVisibleCell(int icell) {
    }

    public void setVisibleCanvas(MolPainterCommon pcommon, int k, int icell) {
    }

    protected abstract void visibleCells(boolean var1);

    protected void mouseReleasedOver(MolButton b) {
    }

    protected abstract void keyPressed(int var1);

    public abstract int getTopLeft();

    public abstract void setTopLeft(int var1);

    public void setVerticalScrollBarMaximum(int max) {
    }

    public abstract void setScrollBarsValue(int var1, int var2);

    public abstract int getScrollBarRowIncrement();

    public abstract int[] getScrollBarsMax();

    public abstract void setScrollBarsMax(int var1, int var2);

    public int[] getScrollBarsMin() {
        int[] value = new int[]{-1, -1};
        return value;
    }

    public int[] getScrollBarsValue() {
        int[] value = new int[]{-1, -1};
        return value;
    }

    public abstract boolean setSelectedCellIndex(int var1);

    public abstract void unselectMoleculeCell(int var1);

    public abstract int molCellIndexFromCellIndex(int var1);

    public abstract int recordIndexFromCellIndex(int var1);

    public abstract int recordIndexFromMolCellIndex(int var1);

    public abstract String fieldKeyFromMolCellIndex(int var1);

    public abstract int rowFromRecordIndex(int var1);

    public int getCellCount() {
        return 0;
    }

    public double getBestTabScale(int irec, int im) {
        return -1.0;
    }

    protected static void destroyViewCanvas(ViewCanvas v) {
        v.removeFromListeners();
    }

    protected void handlePropertyChange(PropertyChangeEvent ev, Component vpan) {
        String name = ev.getPropertyName();
        Object val = ev.getNewValue();
        if (ev.getSource() == vpan && name.equals("windowClosing")) {
            String sval = val.toString();
            try {
                int fixk = -1;
                if (sval.startsWith("sketchInView")) {
                    fixk = Integer.parseInt(sval.substring(12));
                } else if (sval.startsWith("EditMolfileFrame-import")) {
                    fixk = Integer.parseInt(sval.substring(23));
                }
                if (fixk >= 0) {
                    this.getStorage().setFixed(fixk);
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    public abstract String getMultiPageSupportedPrintProviderClassName();

    public abstract boolean hasVerticalScrollbar();
}

