/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import chemaxon.struc.MDocument;

public class VisibleDocuments {
    private int recordIndex;
    private MDocument[] documents;

    public VisibleDocuments(int irec, MDocument[] docs) {
        this.recordIndex = irec;
        this.documents = docs;
    }

    public int getRecordIndex() {
        return this.recordIndex;
    }

    public int getNumDocuments() {
        return this.documents.length;
    }

    public boolean isVisibleRecord(int irec) {
        return irec >= this.recordIndex && irec < this.recordIndex + this.documents.length;
    }

    public void store(int irec, MDocument doc) {
        if (irec >= this.recordIndex && irec < this.recordIndex + this.documents.length) {
            this.documents[irec - this.recordIndex] = doc;
        }
    }

    public MDocument getMainDocument(int irec) {
        if (this.isVisibleRecord(irec)) {
            return this.documents[irec - this.recordIndex];
        }
        return null;
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(i >= 0 ? s.substring(i + 1) : s);
        sb.append('[');
        sb.append(this.recordIndex);
        sb.append('-');
        sb.append(this.recordIndex + this.documents.length - 1);
        sb.append(']');
        return sb.toString();
    }
}

