/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.util.Properties;

public class MolsView
implements CallbackIface {
    private static int TEMP_CACHE_SIZE = 512;
    private Molecule[] mols = null;
    private int size = 200;
    private int cols = 2;
    private int visibleRows = 2;
    private int dim = 2;
    private boolean animation = false;
    private int cells = 0;

    private ViewPanel createViewPanel() {
        ViewPanel vpan = new ViewPanel(null, this.dim, null);
        int rows = 1;
        if (!this.animation) {
            if (this.cells == 0) {
                if (this.mols == null || this.mols.length == 0) {
                    return null;
                }
                this.cells = this.mols.length;
            }
            this.cols = Math.min(this.cells, this.cols);
            int n = rows = this.cols != 0 ? (this.cells + this.cols - 1) / this.cols : 0;
        }
        if (rows == 0) {
            return null;
        }
        String layout = ":2:1:M:1:0:1:1:c:b:1:1:L:0:0:1:1:c:n:0:1";
        String param = ":M:" + this.size + ":" + this.size + ":L:10";
        Properties props = new Properties();
        props.put("rows", String.valueOf(Math.min(2 * this.visibleRows, rows)));
        props.put("cols", String.valueOf(this.cols));
        props.put("visiblecols", String.valueOf(this.cols));
        if (rows > this.visibleRows) {
            props.put("visiblerows", String.valueOf(this.visibleRows));
        }
        props.put("layout", layout);
        props.put("param", param);
        props.put("autoTabScale", "true");
        props.put("editable", "0");
        props.put("importEnabled", "false");
        props.put("molbg", this.dim == 3 ? "#000000" : "#ffffff");
        props.put("rendering", this.dim == 3 ? "ballstick" : "wireframe");
        props.put("viewHelp", "chemaxon/marvin/help/view-index.html");
        props.put("viewQuickHelp", "chemaxon/marvin/help/view.html");
        vpan.setProperties(props);
        vpan.setBorderWidth(1);
        vpan.setMolbg(this.dim == 3 ? Color.black : Color.white);
        vpan.setDetachable(false);
        if (this.animation) {
            vpan.molLoaded(this.mols, 0L);
        }
        return vpan;
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setCells")) {
            this.cells = (Integer)arg;
        } else if (method.equals("setDim")) {
            this.dim = (Integer)arg;
        } else if (method.equals("setMols")) {
            this.mols = (Molecule[])arg;
            if (this.mols.length != 0) {
                this.dim = this.mols[0].getDim();
            }
        } else if (method.equals("setM")) {
            this.animation = true;
            this.mols = (Molecule[])arg;
            if (this.mols.length != 0) {
                this.dim = this.mols[0].getDim();
            }
        } else if (method.equals("setSize")) {
            this.size = (Integer)arg;
        } else if (method.equals("setCols")) {
            this.cols = (Integer)arg;
        } else if (method.equals("setVisibleRows")) {
            this.visibleRows = (Integer)arg;
        } else if (method.equals("createViewPanel")) {
            return this.createViewPanel();
        }
        return null;
    }
}

